@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin

import com.pulumi.alicloud.cr.VpcEndpointLinkedVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CR Vpc Endpoint Linked Vpc resource.
 * For information about CR Vpc Endpoint Linked Vpc and how to use it, see [What is Vpc Endpoint Linked Vpc](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createinstancevpcendpointlinkedvpc).
 * > **NOTE:** Available since v1.199.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultRegistryEnterpriseInstance = new alicloud.cr.RegistryEnterpriseInstance("default", {
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewPeriod: 0,
 *     renewalStatus: "ManualRenewal",
 *     instanceType: "Advanced",
 *     instanceName: name,
 * });
 * const defaultVpcEndpointLinkedVpc = new alicloud.cr.VpcEndpointLinkedVpc("default", {
 *     instanceId: defaultRegistryEnterpriseInstance.id,
 *     vpcId: defaultNetwork.id,
 *     vswitchId: defaultSwitch.id,
 *     moduleName: "Registry",
 *     enableCreateDnsRecordInPvzt: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("default",
 *     payment_type="Subscription",
 *     period=1,
 *     renew_period=0,
 *     renewal_status="ManualRenewal",
 *     instance_type="Advanced",
 *     instance_name=name)
 * default_vpc_endpoint_linked_vpc = alicloud.cr.VpcEndpointLinkedVpc("default",
 *     instance_id=default_registry_enterprise_instance.id,
 *     vpc_id=default_network.id,
 *     vswitch_id=default_switch.id,
 *     module_name="Registry",
 *     enable_create_dns_record_in_pvzt=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultRegistryEnterpriseInstance = new AliCloud.CR.RegistryEnterpriseInstance("default", new()
 *     {
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewPeriod = 0,
 *         RenewalStatus = "ManualRenewal",
 *         InstanceType = "Advanced",
 *         InstanceName = name,
 *     });
 *     var defaultVpcEndpointLinkedVpc = new AliCloud.CR.VpcEndpointLinkedVpc("default", new()
 *     {
 *         InstanceId = defaultRegistryEnterpriseInstance.Id,
 *         VpcId = defaultNetwork.Id,
 *         VswitchId = defaultSwitch.Id,
 *         ModuleName = "Registry",
 *         EnableCreateDnsRecordInPvzt = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRegistryEnterpriseInstance, err := cr.NewRegistryEnterpriseInstance(ctx, "default", &cr.RegistryEnterpriseInstanceArgs{
 * 			PaymentType:   pulumi.String("Subscription"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(0),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			InstanceType:  pulumi.String("Advanced"),
 * 			InstanceName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cr.NewVpcEndpointLinkedVpc(ctx, "default", &cr.VpcEndpointLinkedVpcArgs{
 * 			InstanceId:                  defaultRegistryEnterpriseInstance.ID(),
 * 			VpcId:                       defaultNetwork.ID(),
 * 			VswitchId:                   defaultSwitch.ID(),
 * 			ModuleName:                  pulumi.String("Registry"),
 * 			EnableCreateDnsRecordInPvzt: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstance;
 * import com.pulumi.alicloud.cr.RegistryEnterpriseInstanceArgs;
 * import com.pulumi.alicloud.cr.VpcEndpointLinkedVpc;
 * import com.pulumi.alicloud.cr.VpcEndpointLinkedVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultRegistryEnterpriseInstance = new RegistryEnterpriseInstance("defaultRegistryEnterpriseInstance", RegistryEnterpriseInstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewPeriod(0)
 *             .renewalStatus("ManualRenewal")
 *             .instanceType("Advanced")
 *             .instanceName(name)
 *             .build());
 *         var defaultVpcEndpointLinkedVpc = new VpcEndpointLinkedVpc("defaultVpcEndpointLinkedVpc", VpcEndpointLinkedVpcArgs.builder()
 *             .instanceId(defaultRegistryEnterpriseInstance.id())
 *             .vpcId(defaultNetwork.id())
 *             .vswitchId(defaultSwitch.id())
 *             .moduleName("Registry")
 *             .enableCreateDnsRecordInPvzt(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultRegistryEnterpriseInstance:
 *     type: alicloud:cr:RegistryEnterpriseInstance
 *     name: default
 *     properties:
 *       paymentType: Subscription
 *       period: 1
 *       renewPeriod: 0
 *       renewalStatus: ManualRenewal
 *       instanceType: Advanced
 *       instanceName: ${name}
 *   defaultVpcEndpointLinkedVpc:
 *     type: alicloud:cr:VpcEndpointLinkedVpc
 *     name: default
 *     properties:
 *       instanceId: ${defaultRegistryEnterpriseInstance.id}
 *       vpcId: ${defaultNetwork.id}
 *       vswitchId: ${defaultSwitch.id}
 *       moduleName: Registry
 *       enableCreateDnsRecordInPvzt: true
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CR Vpc Endpoint Linked Vpc can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cr/vpcEndpointLinkedVpc:VpcEndpointLinkedVpc example <instance_id>:<vpc_id>:<vswitch_id>:<module_name>
 * ```
 * @property enableCreateDnsRecordInPvzt Specifies whether to automatically create an Alibaba Cloud DNS PrivateZone record. Valid Values:
 * @property instanceId The ID of the instance.
 * @property moduleName The name of the module that you want to access. Valid Values:
 * - `Registry`: the image repository.
 * - `Chart`: a Helm chart.
 * @property vpcId The ID of the VPC.
 * @property vswitchId The ID of the vSwitch.
 */
public data class VpcEndpointLinkedVpcArgs(
    public val enableCreateDnsRecordInPvzt: Output<Boolean>? = null,
    public val instanceId: Output<String>? = null,
    public val moduleName: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.VpcEndpointLinkedVpcArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.VpcEndpointLinkedVpcArgs =
        com.pulumi.alicloud.cr.VpcEndpointLinkedVpcArgs.builder()
            .enableCreateDnsRecordInPvzt(enableCreateDnsRecordInPvzt?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .moduleName(moduleName?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointLinkedVpcArgs].
 */
@PulumiTagMarker
public class VpcEndpointLinkedVpcArgsBuilder internal constructor() {
    private var enableCreateDnsRecordInPvzt: Output<Boolean>? = null

    private var instanceId: Output<String>? = null

    private var moduleName: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Specifies whether to automatically create an Alibaba Cloud DNS PrivateZone record. Valid Values:
     */
    @JvmName("tuvoygclnvkucstc")
    public suspend fun enableCreateDnsRecordInPvzt(`value`: Output<Boolean>) {
        this.enableCreateDnsRecordInPvzt = value
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("psrqylinsuagugfr")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of the module that you want to access. Valid Values:
     * - `Registry`: the image repository.
     * - `Chart`: a Helm chart.
     */
    @JvmName("mdwrufkwfjfatoba")
    public suspend fun moduleName(`value`: Output<String>) {
        this.moduleName = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("wkwcghdnmkbveclt")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the vSwitch.
     */
    @JvmName("betkipcxqrqctsxh")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Specifies whether to automatically create an Alibaba Cloud DNS PrivateZone record. Valid Values:
     */
    @JvmName("cqujogkwlcvgvndg")
    public suspend fun enableCreateDnsRecordInPvzt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCreateDnsRecordInPvzt = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("jlswqqdknxtpfmdm")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the module that you want to access. Valid Values:
     * - `Registry`: the image repository.
     * - `Chart`: a Helm chart.
     */
    @JvmName("mrbrkgbrutxoxble")
    public suspend fun moduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moduleName = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("jsatpndyfqyndgle")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the vSwitch.
     */
    @JvmName("fkexovhntacltgff")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): VpcEndpointLinkedVpcArgs = VpcEndpointLinkedVpcArgs(
        enableCreateDnsRecordInPvzt = enableCreateDnsRecordInPvzt,
        instanceId = instanceId,
        moduleName = moduleName,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
