@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.ChainChainConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property nodes Each node in the delivery chain. See `nodes` below.
 * > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
 * @property routers Execution sequence relationship between delivery chain nodes. See `routers` below.
 */
public data class ChainChainConfigArgs(
    public val nodes: Output<List<ChainChainConfigNodeArgs>>? = null,
    public val routers: Output<List<ChainChainConfigRouterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.ChainChainConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.ChainChainConfigArgs =
        com.pulumi.alicloud.cr.inputs.ChainChainConfigArgs.builder()
            .nodes(nodes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .routers(
                routers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChainChainConfigArgs].
 */
@PulumiTagMarker
public class ChainChainConfigArgsBuilder internal constructor() {
    private var nodes: Output<List<ChainChainConfigNodeArgs>>? = null

    private var routers: Output<List<ChainChainConfigRouterArgs>>? = null

    /**
     * @param value Each node in the delivery chain. See `nodes` below.
     * > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
     */
    @JvmName("dqlpkuocdvuvengv")
    public suspend fun nodes(`value`: Output<List<ChainChainConfigNodeArgs>>) {
        this.nodes = value
    }

    @JvmName("vjecipxftlgixjpk")
    public suspend fun nodes(vararg values: Output<ChainChainConfigNodeArgs>) {
        this.nodes = Output.all(values.asList())
    }

    /**
     * @param values Each node in the delivery chain. See `nodes` below.
     * > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
     */
    @JvmName("aiqitmgnmcmvtkbs")
    public suspend fun nodes(values: List<Output<ChainChainConfigNodeArgs>>) {
        this.nodes = Output.all(values)
    }

    /**
     * @param value Execution sequence relationship between delivery chain nodes. See `routers` below.
     */
    @JvmName("gotuhfdwkdsdcrod")
    public suspend fun routers(`value`: Output<List<ChainChainConfigRouterArgs>>) {
        this.routers = value
    }

    @JvmName("dglasswryuoswelk")
    public suspend fun routers(vararg values: Output<ChainChainConfigRouterArgs>) {
        this.routers = Output.all(values.asList())
    }

    /**
     * @param values Execution sequence relationship between delivery chain nodes. See `routers` below.
     */
    @JvmName("yekxrpevqabqadhj")
    public suspend fun routers(values: List<Output<ChainChainConfigRouterArgs>>) {
        this.routers = Output.all(values)
    }

    /**
     * @param value Each node in the delivery chain. See `nodes` below.
     * > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
     */
    @JvmName("wstdnlhouxkcmxvw")
    public suspend fun nodes(`value`: List<ChainChainConfigNodeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodes = mapped
    }

    /**
     * @param argument Each node in the delivery chain. See `nodes` below.
     * > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
     */
    @JvmName("gkvbfpuqvuhebigm")
    public suspend fun nodes(argument: List<suspend ChainChainConfigNodeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigNodeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodes = mapped
    }

    /**
     * @param argument Each node in the delivery chain. See `nodes` below.
     * > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
     */
    @JvmName("wlqwckwaakfhvqat")
    public suspend fun nodes(vararg argument: suspend ChainChainConfigNodeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigNodeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodes = mapped
    }

    /**
     * @param argument Each node in the delivery chain. See `nodes` below.
     * > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
     */
    @JvmName("tigmbpuiwbnfitju")
    public suspend fun nodes(argument: suspend ChainChainConfigNodeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ChainChainConfigNodeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nodes = mapped
    }

    /**
     * @param values Each node in the delivery chain. See `nodes` below.
     * > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
     */
    @JvmName("wybcteqrjesxpcbe")
    public suspend fun nodes(vararg values: ChainChainConfigNodeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodes = mapped
    }

    /**
     * @param value Execution sequence relationship between delivery chain nodes. See `routers` below.
     */
    @JvmName("lvpkxtfmvqprmmti")
    public suspend fun routers(`value`: List<ChainChainConfigRouterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routers = mapped
    }

    /**
     * @param argument Execution sequence relationship between delivery chain nodes. See `routers` below.
     */
    @JvmName("sxelfeeryeaackip")
    public suspend fun routers(argument: List<suspend ChainChainConfigRouterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigRouterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routers = mapped
    }

    /**
     * @param argument Execution sequence relationship between delivery chain nodes. See `routers` below.
     */
    @JvmName("sdpicrildvlrncyu")
    public suspend fun routers(vararg argument: suspend ChainChainConfigRouterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigRouterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routers = mapped
    }

    /**
     * @param argument Execution sequence relationship between delivery chain nodes. See `routers` below.
     */
    @JvmName("sclafweliiplnqcu")
    public suspend fun routers(argument: suspend ChainChainConfigRouterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ChainChainConfigRouterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routers = mapped
    }

    /**
     * @param values Execution sequence relationship between delivery chain nodes. See `routers` below.
     */
    @JvmName("heahnucmqtlpmjfv")
    public suspend fun routers(vararg values: ChainChainConfigRouterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routers = mapped
    }

    internal fun build(): ChainChainConfigArgs = ChainChainConfigArgs(
        nodes = nodes,
        routers = routers,
    )
}
