@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enable Whether to enable the delivery chain node. Valid values: `true`, `false`.
 * @property nodeConfigs The configuration of delivery chain node. See `node_config` below.
 * @property nodeName The name of delivery chain node.
 */
public data class ChainChainConfigNodeArgs(
    public val enable: Output<Boolean>? = null,
    public val nodeConfigs: Output<List<ChainChainConfigNodeNodeConfigArgs>>? = null,
    public val nodeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeArgs =
        com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeArgs.builder()
            .enable(enable?.applyValue({ args0 -> args0 }))
            .nodeConfigs(
                nodeConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .nodeName(nodeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChainChainConfigNodeArgs].
 */
@PulumiTagMarker
public class ChainChainConfigNodeArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    private var nodeConfigs: Output<List<ChainChainConfigNodeNodeConfigArgs>>? = null

    private var nodeName: Output<String>? = null

    /**
     * @param value Whether to enable the delivery chain node. Valid values: `true`, `false`.
     */
    @JvmName("ecfwvrthbaftnsae")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The configuration of delivery chain node. See `node_config` below.
     */
    @JvmName("durxlvbvbfisounj")
    public suspend fun nodeConfigs(`value`: Output<List<ChainChainConfigNodeNodeConfigArgs>>) {
        this.nodeConfigs = value
    }

    @JvmName("qksewwjuobdurkbd")
    public suspend fun nodeConfigs(vararg values: Output<ChainChainConfigNodeNodeConfigArgs>) {
        this.nodeConfigs = Output.all(values.asList())
    }

    /**
     * @param values The configuration of delivery chain node. See `node_config` below.
     */
    @JvmName("ckremareowskmlci")
    public suspend fun nodeConfigs(values: List<Output<ChainChainConfigNodeNodeConfigArgs>>) {
        this.nodeConfigs = Output.all(values)
    }

    /**
     * @param value The name of delivery chain node.
     */
    @JvmName("chiofjywrlcgprrc")
    public suspend fun nodeName(`value`: Output<String>) {
        this.nodeName = value
    }

    /**
     * @param value Whether to enable the delivery chain node. Valid values: `true`, `false`.
     */
    @JvmName("estepoluwgngthiy")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The configuration of delivery chain node. See `node_config` below.
     */
    @JvmName("hocngkxdmqtndsap")
    public suspend fun nodeConfigs(`value`: List<ChainChainConfigNodeNodeConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeConfigs = mapped
    }

    /**
     * @param argument The configuration of delivery chain node. See `node_config` below.
     */
    @JvmName("hkmrptwkwwmibage")
    public suspend fun nodeConfigs(argument: List<suspend ChainChainConfigNodeNodeConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigNodeNodeConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.nodeConfigs = mapped
    }

    /**
     * @param argument The configuration of delivery chain node. See `node_config` below.
     */
    @JvmName("tfkqyjejscudsxcw")
    public suspend fun nodeConfigs(vararg argument: suspend ChainChainConfigNodeNodeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigNodeNodeConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.nodeConfigs = mapped
    }

    /**
     * @param argument The configuration of delivery chain node. See `node_config` below.
     */
    @JvmName("wliduoufucseijjk")
    public suspend fun nodeConfigs(argument: suspend ChainChainConfigNodeNodeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChainChainConfigNodeNodeConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.nodeConfigs = mapped
    }

    /**
     * @param values The configuration of delivery chain node. See `node_config` below.
     */
    @JvmName("rnxtvoymkbkhxrxl")
    public suspend fun nodeConfigs(vararg values: ChainChainConfigNodeNodeConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeConfigs = mapped
    }

    /**
     * @param value The name of delivery chain node.
     */
    @JvmName("xbsqwuojhfafmmyn")
    public suspend fun nodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeName = mapped
    }

    internal fun build(): ChainChainConfigNodeArgs = ChainChainConfigNodeArgs(
        enable = enable,
        nodeConfigs = nodeConfigs,
        nodeName = nodeName,
    )
}
