@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeNodeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property denyPolicies Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
 */
public data class ChainChainConfigNodeNodeConfigArgs(
    public val denyPolicies: Output<List<ChainChainConfigNodeNodeConfigDenyPolicyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeNodeConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeNodeConfigArgs =
        com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeNodeConfigArgs.builder()
            .denyPolicies(
                denyPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChainChainConfigNodeNodeConfigArgs].
 */
@PulumiTagMarker
public class ChainChainConfigNodeNodeConfigArgsBuilder internal constructor() {
    private var denyPolicies: Output<List<ChainChainConfigNodeNodeConfigDenyPolicyArgs>>? = null

    /**
     * @param value Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
     */
    @JvmName("cdswlhyrbwvaubxs")
    public suspend fun denyPolicies(`value`: Output<List<ChainChainConfigNodeNodeConfigDenyPolicyArgs>>) {
        this.denyPolicies = value
    }

    @JvmName("bytxrvbijbvuqaif")
    public suspend fun denyPolicies(vararg values: Output<ChainChainConfigNodeNodeConfigDenyPolicyArgs>) {
        this.denyPolicies = Output.all(values.asList())
    }

    /**
     * @param values Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
     */
    @JvmName("nxeiikugketlyhml")
    public suspend fun denyPolicies(values: List<Output<ChainChainConfigNodeNodeConfigDenyPolicyArgs>>) {
        this.denyPolicies = Output.all(values)
    }

    /**
     * @param value Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
     */
    @JvmName("ducbdrvepybpmhwn")
    public suspend fun denyPolicies(`value`: List<ChainChainConfigNodeNodeConfigDenyPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.denyPolicies = mapped
    }

    /**
     * @param argument Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
     */
    @JvmName("ovspoproufmndtod")
    public suspend fun denyPolicies(argument: List<suspend ChainChainConfigNodeNodeConfigDenyPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigNodeNodeConfigDenyPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.denyPolicies = mapped
    }

    /**
     * @param argument Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
     */
    @JvmName("nbbffneaqysugouh")
    public suspend fun denyPolicies(vararg argument: suspend ChainChainConfigNodeNodeConfigDenyPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigNodeNodeConfigDenyPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.denyPolicies = mapped
    }

    /**
     * @param argument Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
     */
    @JvmName("nygpmkwhtnvbyqbj")
    public suspend fun denyPolicies(argument: suspend ChainChainConfigNodeNodeConfigDenyPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChainChainConfigNodeNodeConfigDenyPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.denyPolicies = mapped
    }

    /**
     * @param values Blocking rules for scanning nodes in delivery chain nodes. See `deny_policy` below. **Note:** When `node_name` is `VULNERABILITY_SCANNING`, the parameters in `deny_policy` need to be filled in.
     */
    @JvmName("tlobidynfnyltdcl")
    public suspend fun denyPolicies(vararg values: ChainChainConfigNodeNodeConfigDenyPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.denyPolicies = mapped
    }

    internal fun build(): ChainChainConfigNodeNodeConfigArgs = ChainChainConfigNodeNodeConfigArgs(
        denyPolicies = denyPolicies,
    )
}
