@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeNodeConfigDenyPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
 * @property issueCount The count of scanning vulnerabilities that triggers blocking.
 * @property issueLevel The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
 * @property logic The logic of trigger blocking. Valid values: `AND`, `OR`.
 */
public data class ChainChainConfigNodeNodeConfigDenyPolicyArgs(
    public val action: Output<String>? = null,
    public val issueCount: Output<String>? = null,
    public val issueLevel: Output<String>? = null,
    public val logic: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeNodeConfigDenyPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeNodeConfigDenyPolicyArgs = com.pulumi.alicloud.cr.inputs.ChainChainConfigNodeNodeConfigDenyPolicyArgs.builder()
        .action(action?.applyValue({ args0 -> args0 }))
        .issueCount(issueCount?.applyValue({ args0 -> args0 }))
        .issueLevel(issueLevel?.applyValue({ args0 -> args0 }))
        .logic(logic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChainChainConfigNodeNodeConfigDenyPolicyArgs].
 */
@PulumiTagMarker
public class ChainChainConfigNodeNodeConfigDenyPolicyArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var issueCount: Output<String>? = null

    private var issueLevel: Output<String>? = null

    private var logic: Output<String>? = null

    /**
     * @param value The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
     */
    @JvmName("dxjqnorvlodblftv")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The count of scanning vulnerabilities that triggers blocking.
     */
    @JvmName("yanyefadxymlopuh")
    public suspend fun issueCount(`value`: Output<String>) {
        this.issueCount = value
    }

    /**
     * @param value The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
     */
    @JvmName("jftqmamuoarrjtvi")
    public suspend fun issueLevel(`value`: Output<String>) {
        this.issueLevel = value
    }

    /**
     * @param value The logic of trigger blocking. Valid values: `AND`, `OR`.
     */
    @JvmName("lydgskbpsclmdpud")
    public suspend fun logic(`value`: Output<String>) {
        this.logic = value
    }

    /**
     * @param value The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
     */
    @JvmName("riplpwsydirlpkka")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The count of scanning vulnerabilities that triggers blocking.
     */
    @JvmName("dwnoffdvuhnpblvm")
    public suspend fun issueCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issueCount = mapped
    }

    /**
     * @param value The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
     */
    @JvmName("cyqxyyvqisfhksep")
    public suspend fun issueLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issueLevel = mapped
    }

    /**
     * @param value The logic of trigger blocking. Valid values: `AND`, `OR`.
     */
    @JvmName("yqxnewxsbqpgtdgy")
    public suspend fun logic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logic = mapped
    }

    internal fun build(): ChainChainConfigNodeNodeConfigDenyPolicyArgs =
        ChainChainConfigNodeNodeConfigDenyPolicyArgs(
            action = action,
            issueCount = issueCount,
            issueLevel = issueLevel,
            logic = logic,
        )
}
