@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.ChainChainConfigRouterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property froms Source node. See `from` below.
 * @property tos Destination node. See `to` below.
 */
public data class ChainChainConfigRouterArgs(
    public val froms: Output<List<ChainChainConfigRouterFromArgs>>? = null,
    public val tos: Output<List<ChainChainConfigRouterToArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.ChainChainConfigRouterArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.ChainChainConfigRouterArgs =
        com.pulumi.alicloud.cr.inputs.ChainChainConfigRouterArgs.builder()
            .froms(froms?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tos(
                tos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChainChainConfigRouterArgs].
 */
@PulumiTagMarker
public class ChainChainConfigRouterArgsBuilder internal constructor() {
    private var froms: Output<List<ChainChainConfigRouterFromArgs>>? = null

    private var tos: Output<List<ChainChainConfigRouterToArgs>>? = null

    /**
     * @param value Source node. See `from` below.
     */
    @JvmName("ppvjqhggsudachhj")
    public suspend fun froms(`value`: Output<List<ChainChainConfigRouterFromArgs>>) {
        this.froms = value
    }

    @JvmName("lovoillqxtyyqrxr")
    public suspend fun froms(vararg values: Output<ChainChainConfigRouterFromArgs>) {
        this.froms = Output.all(values.asList())
    }

    /**
     * @param values Source node. See `from` below.
     */
    @JvmName("kojwouhidqxokwov")
    public suspend fun froms(values: List<Output<ChainChainConfigRouterFromArgs>>) {
        this.froms = Output.all(values)
    }

    /**
     * @param value Destination node. See `to` below.
     */
    @JvmName("bhytyukuksuvocpo")
    public suspend fun tos(`value`: Output<List<ChainChainConfigRouterToArgs>>) {
        this.tos = value
    }

    @JvmName("yoifyclkiqyxrpbd")
    public suspend fun tos(vararg values: Output<ChainChainConfigRouterToArgs>) {
        this.tos = Output.all(values.asList())
    }

    /**
     * @param values Destination node. See `to` below.
     */
    @JvmName("tixcohscxbgwhdyy")
    public suspend fun tos(values: List<Output<ChainChainConfigRouterToArgs>>) {
        this.tos = Output.all(values)
    }

    /**
     * @param value Source node. See `from` below.
     */
    @JvmName("wodglifumaiquqsn")
    public suspend fun froms(`value`: List<ChainChainConfigRouterFromArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.froms = mapped
    }

    /**
     * @param argument Source node. See `from` below.
     */
    @JvmName("uhdepomvejmhdgpi")
    public suspend fun froms(argument: List<suspend ChainChainConfigRouterFromArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigRouterFromArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.froms = mapped
    }

    /**
     * @param argument Source node. See `from` below.
     */
    @JvmName("ckucdmbnxepnbuom")
    public suspend fun froms(vararg argument: suspend ChainChainConfigRouterFromArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigRouterFromArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.froms = mapped
    }

    /**
     * @param argument Source node. See `from` below.
     */
    @JvmName("gnchkcsecmgqedxj")
    public suspend fun froms(argument: suspend ChainChainConfigRouterFromArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChainChainConfigRouterFromArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.froms = mapped
    }

    /**
     * @param values Source node. See `from` below.
     */
    @JvmName("gobfocjsqukeebvx")
    public suspend fun froms(vararg values: ChainChainConfigRouterFromArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.froms = mapped
    }

    /**
     * @param value Destination node. See `to` below.
     */
    @JvmName("ktpjdwxehyvchjwc")
    public suspend fun tos(`value`: List<ChainChainConfigRouterToArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tos = mapped
    }

    /**
     * @param argument Destination node. See `to` below.
     */
    @JvmName("thtsyfknbortxtao")
    public suspend fun tos(argument: List<suspend ChainChainConfigRouterToArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigRouterToArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tos = mapped
    }

    /**
     * @param argument Destination node. See `to` below.
     */
    @JvmName("gdxcwceqfyitwajc")
    public suspend fun tos(vararg argument: suspend ChainChainConfigRouterToArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChainChainConfigRouterToArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tos = mapped
    }

    /**
     * @param argument Destination node. See `to` below.
     */
    @JvmName("anuikedukmapxaqu")
    public suspend fun tos(argument: suspend ChainChainConfigRouterToArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChainChainConfigRouterToArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tos = mapped
    }

    /**
     * @param values Destination node. See `to` below.
     */
    @JvmName("opsuwwyaohcgtipw")
    public suspend fun tos(vararg values: ChainChainConfigRouterToArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tos = mapped
    }

    internal fun build(): ChainChainConfigRouterArgs = ChainChainConfigRouterArgs(
        froms = froms,
        tos = tos,
    )
}
