@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.ChainChainConfigRouterFromArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nodeName The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
 */
public data class ChainChainConfigRouterFromArgs(
    public val nodeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.ChainChainConfigRouterFromArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.ChainChainConfigRouterFromArgs =
        com.pulumi.alicloud.cr.inputs.ChainChainConfigRouterFromArgs.builder()
            .nodeName(nodeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChainChainConfigRouterFromArgs].
 */
@PulumiTagMarker
public class ChainChainConfigRouterFromArgsBuilder internal constructor() {
    private var nodeName: Output<String>? = null

    /**
     * @param value The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
     */
    @JvmName("kyvwvnveogvkenwr")
    public suspend fun nodeName(`value`: Output<String>) {
        this.nodeName = value
    }

    /**
     * @param value The name of node. Valid values: `DOCKER_IMAGE_BUILD`, `DOCKER_IMAGE_PUSH`, `VULNERABILITY_SCANNING`, `ACTIVATE_REPLICATION`, `TRIGGER`, `SNAPSHOT`, `TRIGGER_SNAPSHOT`.
     */
    @JvmName("cwtapsuicfutwfpt")
    public suspend fun nodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeName = mapped
    }

    internal fun build(): ChainChainConfigRouterFromArgs = ChainChainConfigRouterFromArgs(
        nodeName = nodeName,
    )
}
