@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.GetChainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getChains.
 * @property enableDetails
 * @property ids A list of Chain IDs.
 * @property instanceId The ID of CR Enterprise Edition instance.
 * @property nameRegex A regex string to filter results by Chain name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property repoName The name of CR Enterprise Edition repository.
 * @property repoNamespaceName The name of CR Enterprise Edition namespace.
 */
public data class GetChainsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val repoName: String? = null,
    public val repoNamespaceName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.GetChainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.GetChainsPlainArgs =
        com.pulumi.alicloud.cr.inputs.GetChainsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .repoName(repoName?.let({ args0 -> args0 }))
            .repoNamespaceName(repoNamespaceName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetChainsPlainArgs].
 */
@PulumiTagMarker
public class GetChainsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var repoName: String? = null

    private var repoNamespaceName: String? = null

    /**
     * @param value
     */
    @JvmName("gxlgrvukycycbwny")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Chain IDs.
     */
    @JvmName("bgchbqoiulwqxwgp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Chain IDs.
     */
    @JvmName("fvhupqpncsacradp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of CR Enterprise Edition instance.
     */
    @JvmName("abbwnwofpdvbjrue")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by Chain name.
     */
    @JvmName("ufkhnyepkkfffkgp")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wpvfekmyqssmrdni")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of CR Enterprise Edition repository.
     */
    @JvmName("nesgqomwsvdvjdin")
    public suspend fun repoName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.repoName = mapped
    }

    /**
     * @param value The name of CR Enterprise Edition namespace.
     */
    @JvmName("abnyvhuiedefecim")
    public suspend fun repoNamespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.repoNamespaceName = mapped
    }

    internal fun build(): GetChainsPlainArgs = GetChainsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        repoName = repoName,
        repoNamespaceName = repoNamespaceName,
    )
}
