@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.GetChartNamespacesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getChartNamespaces.
 * @property ids A list of matched Container Registry Enterprise Edition namespaces.
 * @property instanceId The ID of the Container Registry instance.
 * @property nameRegex A regex string to filter results by name space name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetChartNamespacesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.GetChartNamespacesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.GetChartNamespacesPlainArgs =
        com.pulumi.alicloud.cr.inputs.GetChartNamespacesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetChartNamespacesPlainArgs].
 */
@PulumiTagMarker
public class GetChartNamespacesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of matched Container Registry Enterprise Edition namespaces.
     */
    @JvmName("oskorrnioelnpqhl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of matched Container Registry Enterprise Edition namespaces.
     */
    @JvmName("lfkbptkouujcsovm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the Container Registry instance.
     */
    @JvmName("eyaiujhckdhiyavd")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by name space name.
     */
    @JvmName("uqlryohanjwwwyln")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("umyvpksvtprfddqc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetChartNamespacesPlainArgs = GetChartNamespacesPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
