@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.GetEndpointAclPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEndpointAclPolicies.
 * @property endpointType The type of endpoint. Valid values: `internet`.
 * @property ids A list of Endpoint Acl Policy IDs.
 * @property instanceId The ID of the CR Instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetEndpointAclPoliciesPlainArgs(
    public val endpointType: String,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.GetEndpointAclPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.GetEndpointAclPoliciesPlainArgs =
        com.pulumi.alicloud.cr.inputs.GetEndpointAclPoliciesPlainArgs.builder()
            .endpointType(endpointType.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointAclPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointAclPoliciesPlainArgsBuilder internal constructor() {
    private var endpointType: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    /**
     * @param value The type of endpoint. Valid values: `internet`.
     */
    @JvmName("ewfcjwsxxrqhdpwg")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointType = mapped
    }

    /**
     * @param value A list of Endpoint Acl Policy IDs.
     */
    @JvmName("mtspfctpxfaoxkfx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Endpoint Acl Policy IDs.
     */
    @JvmName("wsxryendmecywhka")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the CR Instance.
     */
    @JvmName("kshoasgtsbwrfxpd")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("getbmdaidmhaikrr")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetEndpointAclPoliciesPlainArgs = GetEndpointAclPoliciesPlainArgs(
        endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
    )
}
