@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.GetEndpointAclServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEndpointAclService.
 * @property enable Whether to enable Acl Service, Setting the value to `true` to enable the acl service. Valid values: `true` and `false`.
 * @property endpointType The type of endpoint. Valid values: `internet`.
 * @property instanceId The ID of the CR Instance.
 * @property moduleName The ModuleName. Valid values: `Registry`.
 * > **NOTE:** After You enable access over the Internet, the Classless Inter-Domain Routing (CIDR) block `127.0.0.1/32` is automatically added to the whitelist.
 * > **NOTE:** You may want to allow all ECS instances to access the Container Registry Enterprise Edition instance over the Internet. To achieve this purpose, you can enable access over the Internet and delete all IP addresses from the whitelist for Internet access. After you perform the preceding operation, the Container Registry Enterprise Edition instance is completely exposed to the Internet and may be attacked.
 */
public data class GetEndpointAclServicePlainArgs(
    public val enable: Boolean,
    public val endpointType: String,
    public val instanceId: String,
    public val moduleName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.GetEndpointAclServicePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.GetEndpointAclServicePlainArgs =
        com.pulumi.alicloud.cr.inputs.GetEndpointAclServicePlainArgs.builder()
            .enable(enable.let({ args0 -> args0 }))
            .endpointType(endpointType.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .moduleName(moduleName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointAclServicePlainArgs].
 */
@PulumiTagMarker
public class GetEndpointAclServicePlainArgsBuilder internal constructor() {
    private var enable: Boolean? = null

    private var endpointType: String? = null

    private var instanceId: String? = null

    private var moduleName: String? = null

    /**
     * @param value Whether to enable Acl Service, Setting the value to `true` to enable the acl service. Valid values: `true` and `false`.
     */
    @JvmName("ghmwoqywjivvjrvs")
    public suspend fun enable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.enable = mapped
    }

    /**
     * @param value The type of endpoint. Valid values: `internet`.
     */
    @JvmName("xprqmfutydcuitor")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointType = mapped
    }

    /**
     * @param value The ID of the CR Instance.
     */
    @JvmName("uwswnxitwcefbsum")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value The ModuleName. Valid values: `Registry`.
     * > **NOTE:** After You enable access over the Internet, the Classless Inter-Domain Routing (CIDR) block `127.0.0.1/32` is automatically added to the whitelist.
     * > **NOTE:** You may want to allow all ECS instances to access the Container Registry Enterprise Edition instance over the Internet. To achieve this purpose, you can enable access over the Internet and delete all IP addresses from the whitelist for Internet access. After you perform the preceding operation, the Container Registry Enterprise Edition instance is completely exposed to the Internet and may be attacked.
     */
    @JvmName("ixwskltfnsbijkep")
    public suspend fun moduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.moduleName = mapped
    }

    internal fun build(): GetEndpointAclServicePlainArgs = GetEndpointAclServicePlainArgs(
        enable = enable ?: throw PulumiNullFieldException("enable"),
        endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        moduleName = moduleName,
    )
}
