@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.GetNamespacesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNamespaces.
 * @property nameRegex A regex string to filter results by namespace name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetNamespacesPlainArgs(
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.GetNamespacesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.GetNamespacesPlainArgs =
        com.pulumi.alicloud.cr.inputs.GetNamespacesPlainArgs.builder()
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamespacesPlainArgs].
 */
@PulumiTagMarker
public class GetNamespacesPlainArgsBuilder internal constructor() {
    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A regex string to filter results by namespace name.
     */
    @JvmName("asgaaqksetbddyvo")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yvfhmjycvqjegghs")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetNamespacesPlainArgs = GetNamespacesPlainArgs(
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
