@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.GetReposPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRepos.
 * @property enableDetails Boolean, false by default, only repository attributes are exported. Set to true if domain list and tags belong to this repository are needed. See `tags` in attributes.
 * @property nameRegex A regex string to filter results by repository name.
 * @property namespace Name of container registry namespace where the repositories are located in.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetReposPlainArgs(
    public val enableDetails: Boolean? = null,
    public val nameRegex: String? = null,
    public val namespace: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.GetReposPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.GetReposPlainArgs =
        com.pulumi.alicloud.cr.inputs.GetReposPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .namespace(namespace?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReposPlainArgs].
 */
@PulumiTagMarker
public class GetReposPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var nameRegex: String? = null

    private var namespace: String? = null

    private var outputFile: String? = null

    /**
     * @param value Boolean, false by default, only repository attributes are exported. Set to true if domain list and tags belong to this repository are needed. See `tags` in attributes.
     */
    @JvmName("isyvpitoxthiiaos")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A regex string to filter results by repository name.
     */
    @JvmName("nllrbkmsnusypaav")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Name of container registry namespace where the repositories are located in.
     */
    @JvmName("otdstmswolrioafn")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespace = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("paybhndjrslqeble")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetReposPlainArgs = GetReposPlainArgs(
        enableDetails = enableDetails,
        nameRegex = nameRegex,
        namespace = namespace,
        outputFile = outputFile,
    )
}
