@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getService.
 * @property enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
 * @property password The user password. The password must be 8 to 32 characters in length, and must contain at least two of the following character types: letters, special characters, and digits.
 * > **NOTE:** Setting `enable = "On"` to open the Container Registry (CR) service that means you have read and agreed the [Container Registry (CR) Terms of Service](https://help.aliyun.com/document_detail/190602.html). The service can not closed once it is opened.
 */
public data class GetServicePlainArgs(
    public val enable: String? = null,
    public val password: String,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.GetServicePlainArgs =
        com.pulumi.alicloud.cr.inputs.GetServicePlainArgs.builder()
            .enable(enable?.let({ args0 -> args0 }))
            .password(password.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var enable: String? = null

    private var password: String? = null

    /**
     * @param value Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     */
    @JvmName("nelnofhxiildmsux")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enable = mapped
    }

    /**
     * @param value The user password. The password must be 8 to 32 characters in length, and must contain at least two of the following character types: letters, special characters, and digits.
     * > **NOTE:** Setting `enable = "On"` to open the Container Registry (CR) service that means you have read and agreed the [Container Registry (CR) Terms of Service](https://help.aliyun.com/document_detail/190602.html). The service can not closed once it is opened.
     */
    @JvmName("eveqhcuaxfongsbx")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.password = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        enable = enable,
        password = password ?: throw PulumiNullFieldException("password"),
    )
}
