@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.inputs

import com.pulumi.alicloud.cr.inputs.GetVpcEndpointLinkedVpcsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcEndpointLinkedVpcs.
 * @property ids A list of CR Vpc Endpoint Linked Vpc IDs.
 * @property instanceId The ID of the instance.
 * @property moduleName The name of the module that you want to access. Valid Values:
 * - `Registry`: the image repository.
 * - `Chart`: a Helm chart.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the Vpc Endpoint Linked Vpc. Valid Values: `CREATING`, `RUNNING`.
 */
public data class GetVpcEndpointLinkedVpcsPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val moduleName: String,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cr.inputs.GetVpcEndpointLinkedVpcsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cr.inputs.GetVpcEndpointLinkedVpcsPlainArgs =
        com.pulumi.alicloud.cr.inputs.GetVpcEndpointLinkedVpcsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .moduleName(moduleName.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcEndpointLinkedVpcsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcEndpointLinkedVpcsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var moduleName: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of CR Vpc Endpoint Linked Vpc IDs.
     */
    @JvmName("exkccptdgyqrdpim")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of CR Vpc Endpoint Linked Vpc IDs.
     */
    @JvmName("gblcywjmgfadpnuh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("ldphkapjtykjrjgy")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the module that you want to access. Valid Values:
     * - `Registry`: the image repository.
     * - `Chart`: a Helm chart.
     */
    @JvmName("jjffsvwytculepwy")
    public suspend fun moduleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.moduleName = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("aijsbtfdksmdglhy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the Vpc Endpoint Linked Vpc. Valid Values: `CREATING`, `RUNNING`.
     */
    @JvmName("yofwdkhrksvogqea")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetVpcEndpointLinkedVpcsPlainArgs = GetVpcEndpointLinkedVpcsPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        moduleName = moduleName ?: throw PulumiNullFieldException("moduleName"),
        outputFile = outputFile,
        status = status,
    )
}
