@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property nodes Each node in the delivery chain. See `nodes` below.
 * > **NOTE:** The `from` and `to` fields are all fixed, and their structure and the value of `node_name` are fixed. You can refer to the template given in the example for configuration.
 * @property routers Execution sequence relationship between delivery chain nodes. See `routers` below.
 */
public data class ChainChainConfig(
    public val nodes: List<ChainChainConfigNode>? = null,
    public val routers: List<ChainChainConfigRouter>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.ChainChainConfig): ChainChainConfig = ChainChainConfig(
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cr.kotlin.outputs.ChainChainConfigNode.Companion.toKotlin(args0)
                })
            }),
            routers = javaType.routers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cr.kotlin.outputs.ChainChainConfigRouter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
