@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enable Whether to enable the delivery chain node. Valid values: `true`, `false`.
 * @property nodeConfigs The configuration of delivery chain node. See `node_config` below.
 * @property nodeName The name of delivery chain node.
 */
public data class ChainChainConfigNode(
    public val enable: Boolean? = null,
    public val nodeConfigs: List<ChainChainConfigNodeNodeConfig>? = null,
    public val nodeName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.ChainChainConfigNode): ChainChainConfigNode = ChainChainConfigNode(
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            nodeConfigs = javaType.nodeConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cr.kotlin.outputs.ChainChainConfigNodeNodeConfig.Companion.toKotlin(args0)
                })
            }),
            nodeName = javaType.nodeName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
