@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action The action of trigger blocking. Valid values: `BLOCK`, `BLOCK_RETAG`, `BLOCK_DELETE_TAG`. While `Block` means block the delivery chain from continuing to execute, `BLOCK_RETAG` means block overwriting push image tag, `BLOCK_DELETE_TAG` means block deletion of mirror tags.
 * @property issueCount The count of scanning vulnerabilities that triggers blocking.
 * @property issueLevel The level of scanning vulnerability that triggers blocking. Valid values: `LOW`, `MEDIUM`, `HIGH`, `UNKNOWN`.
 * @property logic The logic of trigger blocking. Valid values: `AND`, `OR`.
 */
public data class ChainChainConfigNodeNodeConfigDenyPolicy(
    public val action: String? = null,
    public val issueCount: String? = null,
    public val issueLevel: String? = null,
    public val logic: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.ChainChainConfigNodeNodeConfigDenyPolicy): ChainChainConfigNodeNodeConfigDenyPolicy = ChainChainConfigNodeNodeConfigDenyPolicy(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            issueCount = javaType.issueCount().map({ args0 -> args0 }).orElse(null),
            issueLevel = javaType.issueLevel().map({ args0 -> args0 }).orElse(null),
            logic = javaType.logic().map({ args0 -> args0 }).orElse(null),
        )
    }
}
