@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property chainConfigs The configuration of delivery chain.
 * @property chainId The ID of delivery chain.
 * @property chainName The name of delivery chain.
 * @property createTime The creation time of delivery chain.
 * @property description The description of delivery chain.
 * @property id The resource ID of the delivery chain. The value formats as `<instance_id>:<chain_id>`.
 * @property instanceId The ID of CR Enterprise Edition instance.
 * @property modifiedTime The modification time of delivery chain description.
 * @property scopeId Delivery chain scope ID.
 * @property scopeType Delivery chain scope type.
 */
public data class GetChainsChain(
    public val chainConfigs: List<GetChainsChainChainConfig>,
    public val chainId: String,
    public val chainName: String,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val modifiedTime: String,
    public val scopeId: String,
    public val scopeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetChainsChain): GetChainsChain =
            GetChainsChain(
                chainConfigs = javaType.chainConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cr.kotlin.outputs.GetChainsChainChainConfig.Companion.toKotlin(args0)
                    })
                }),
                chainId = javaType.chainId(),
                chainName = javaType.chainName(),
                createTime = javaType.createTime(),
                description = javaType.description(),
                id = javaType.id(),
                instanceId = javaType.instanceId(),
                modifiedTime = javaType.modifiedTime(),
                scopeId = javaType.scopeId(),
                scopeType = javaType.scopeType(),
            )
    }
}
