@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property nodes Each node in the delivery chain.
 * @property routers Execution sequence relationship between delivery chain nodes.
 */
public data class GetChainsChainChainConfig(
    public val nodes: List<GetChainsChainChainConfigNode>,
    public val routers: List<GetChainsChainChainConfigRouter>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetChainsChainChainConfig): GetChainsChainChainConfig = GetChainsChainChainConfig(
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cr.kotlin.outputs.GetChainsChainChainConfigNode.Companion.toKotlin(args0)
                })
            }),
            routers = javaType.routers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cr.kotlin.outputs.GetChainsChainChainConfigRouter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
