@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enable Whether to enable the delivery chain node. Valid values: `true`, `false`.
 * @property nodeConfigs The configuration of delivery chain node.
 * @property nodeName The name of delivery chain node.
 */
public data class GetChainsChainChainConfigNode(
    public val enable: Boolean,
    public val nodeConfigs: List<GetChainsChainChainConfigNodeNodeConfig>,
    public val nodeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetChainsChainChainConfigNode): GetChainsChainChainConfigNode = GetChainsChainChainConfigNode(
            enable = javaType.enable(),
            nodeConfigs = javaType.nodeConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cr.kotlin.outputs.GetChainsChainChainConfigNodeNodeConfig.Companion.toKotlin(args0)
                })
            }),
            nodeName = javaType.nodeName(),
        )
    }
}
