@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getChains.
 * @property chains A list of Cr Chains. Each element contains the following attributes:
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Chain IDs.
 * @property instanceId The ID of CR Enterprise Edition instance.
 * @property nameRegex
 * @property names A list of Chain names.
 * @property outputFile
 * @property repoName
 * @property repoNamespaceName
 */
public data class GetChainsResult(
    public val chains: List<GetChainsChain>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val repoName: String? = null,
    public val repoNamespaceName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetChainsResult): GetChainsResult =
            GetChainsResult(
                chains = javaType.chains().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cr.kotlin.outputs.GetChainsChain.Companion.toKotlin(args0)
                    })
                }),
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                instanceId = javaType.instanceId(),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                repoName = javaType.repoName().map({ args0 -> args0 }).orElse(null),
                repoNamespaceName = javaType.repoNamespaceName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
