@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoCreateRepo Indicates whether a repository is automatically created when an image is pushed to the namespace.
 * @property chartNamespaceId The ID of the namespace.
 * @property defaultRepoType The default repository type. Valid values: `PUBLIC`,`PRIVATE`.
 * @property id The ID of the Chart Namespace.
 * @property instanceId The ID of the namespace.
 * @property namespaceName The name of the namespace.
 */
public data class GetChartNamespacesNamespace(
    public val autoCreateRepo: Boolean,
    public val chartNamespaceId: String,
    public val defaultRepoType: String,
    public val id: String,
    public val instanceId: String,
    public val namespaceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetChartNamespacesNamespace): GetChartNamespacesNamespace = GetChartNamespacesNamespace(
            autoCreateRepo = javaType.autoCreateRepo(),
            chartNamespaceId = javaType.chartNamespaceId(),
            defaultRepoType = javaType.defaultRepoType(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            namespaceName = javaType.namespaceName(),
        )
    }
}
