@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property chartRepositoryId The first ID of the resource.
 * @property createTime The creation time of the resource.
 * @property id The ID of the Chart Repository.
 * @property instanceId The ID of the Container Registry instance.
 * @property repoName The name of the repository.
 * @property repoNamespaceName The namespace to which the repository belongs.
 * @property repoType The type of the repository. Valid values: `PUBLIC`,`PRIVATE`.
 * @property summary The summary about the repository.
 */
public data class GetChartRepositoriesRepository(
    public val chartRepositoryId: String,
    public val createTime: String,
    public val id: String,
    public val instanceId: String,
    public val repoName: String,
    public val repoNamespaceName: String,
    public val repoType: String,
    public val summary: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetChartRepositoriesRepository): GetChartRepositoriesRepository = GetChartRepositoriesRepository(
            chartRepositoryId = javaType.chartRepositoryId(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            repoName = javaType.repoName(),
            repoNamespaceName = javaType.repoNamespaceName(),
            repoType = javaType.repoType(),
            summary = javaType.summary(),
        )
    }
}
