@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the entry.
 * @property endpointType The type of endpoint.
 * @property entry The IP segment that allowed to access.
 * @property id The ID of the Endpoint Acl Policy.
 * @property instanceId The ID of the CR Instance.
 */
public data class GetEndpointAclPoliciesPolicy(
    public val description: String,
    public val endpointType: String,
    public val entry: String,
    public val id: String,
    public val instanceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetEndpointAclPoliciesPolicy): GetEndpointAclPoliciesPolicy = GetEndpointAclPoliciesPolicy(
            description = javaType.description(),
            endpointType = javaType.endpointType(),
            entry = javaType.entry(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
        )
    }
}
