@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEndpointAclPolicies.
 * @property endpointType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property outputFile
 * @property policies
 */
public data class GetEndpointAclPoliciesResult(
    public val endpointType: String,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val policies: List<GetEndpointAclPoliciesPolicy>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetEndpointAclPoliciesResult): GetEndpointAclPoliciesResult = GetEndpointAclPoliciesResult(
            endpointType = javaType.endpointType(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cr.kotlin.outputs.GetEndpointAclPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
