@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getEndpointAclService.
 * @property enable
 * @property endpointType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property moduleName
 * @property status
 */
public data class GetEndpointAclServiceResult(
    public val enable: Boolean,
    public val endpointType: String,
    public val id: String,
    public val instanceId: String,
    public val moduleName: String? = null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetEndpointAclServiceResult): GetEndpointAclServiceResult = GetEndpointAclServiceResult(
            enable = javaType.enable(),
            endpointType = javaType.endpointType(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            moduleName = javaType.moduleName().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
        )
    }
}
