@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNamespaces.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of matched Container Registry namespaces. Its element is a namespace name.
 * @property nameRegex
 * @property names A list of namespace names.
 * @property namespaces A list of matched Container Registry namespaces. Each element contains the following attributes:
 * @property outputFile
 */
public data class GetNamespacesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val namespaces: List<GetNamespacesNamespace>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetNamespacesResult): GetNamespacesResult = GetNamespacesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            namespaces = javaType.namespaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cr.kotlin.outputs.GetNamespacesNamespace.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
