@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property domainList The repository domain list.
 * @property name Name of container registry namespace.
 * @property namespace Name of container registry namespace where the repositories are located in.
 * @property repoType `PUBLIC` or `PRIVATE`, repository's visibility.
 * @property summary The repository general information.
 * @property tags A list of image tags belong to this repository. Each contains several attributes, see `Block Tag`.
 */
public data class GetReposRepo(
    public val domainList: GetReposRepoDomainList,
    public val name: String,
    public val namespace: String,
    public val repoType: String,
    public val summary: String,
    public val tags: List<GetReposRepoTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetReposRepo): GetReposRepo =
            GetReposRepo(
                domainList = javaType.domainList().let({ args0 ->
                    com.pulumi.alicloud.cr.kotlin.outputs.GetReposRepoDomainList.Companion.toKotlin(args0)
                }),
                name = javaType.name(),
                namespace = javaType.namespace(),
                repoType = javaType.repoType(),
                summary = javaType.summary(),
                tags = javaType.tags().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cr.kotlin.outputs.GetReposRepoTag.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
