@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRepos.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of matched Container Registry Repositories. Its element is set to `names`.
 * @property nameRegex
 * @property names A list of repository names.
 * @property namespace Name of container registry namespace where repo is located.
 * @property outputFile
 * @property repos A list of matched Container Registry Namespaces. Each element contains the following attributes:
 */
public data class GetReposResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val namespace: String? = null,
    public val outputFile: String? = null,
    public val repos: List<GetReposRepo>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetReposResult): GetReposResult =
            GetReposResult(
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                repos = javaType.repos().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cr.kotlin.outputs.GetReposRepo.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
