@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getService.
 * @property enable
 * @property id The provider-assigned unique ID for this managed resource.
 * @property password
 * @property status The current service enable status.
 */
public data class GetServiceResult(
    public val enable: String? = null,
    public val id: String,
    public val password: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetServiceResult): GetServiceResult = GetServiceResult(
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            password = javaType.password(),
            status = javaType.status(),
        )
    }
}
