@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcEndpointLinkedVpcs.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId The ID of the instance.
 * @property moduleName The name of the module that you want to access.
 * @property outputFile
 * @property status The status of the Vpc Endpoint Linked Vpc.
 * @property vpcEndpointLinkedVpcs A list of CR Vpc Endpoint Linked Vpcs. Each element contains the following attributes:
 */
public data class GetVpcEndpointLinkedVpcsResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val moduleName: String,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vpcEndpointLinkedVpcs: List<GetVpcEndpointLinkedVpcsVpcEndpointLinkedVpc>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetVpcEndpointLinkedVpcsResult): GetVpcEndpointLinkedVpcsResult = GetVpcEndpointLinkedVpcsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            moduleName = javaType.moduleName(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpcEndpointLinkedVpcs = javaType.vpcEndpointLinkedVpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cr.kotlin.outputs.GetVpcEndpointLinkedVpcsVpcEndpointLinkedVpc.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
