@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultAccess Indicates whether the default policy is used to access the instance.
 * @property id The ID of the Vpc Endpoint Linked Vpc. It formats as `<instance_id>:<vpc_id>:<vswitch_id>:<module_name>`.
 * @property instanceId The ID of the instance.
 * @property ip IP address.
 * @property moduleName The name of the module that you want to access. Valid Values:
 * - `Registry`: the image repository.
 * - `Chart`: a Helm chart.
 * @property status The status of the Vpc Endpoint Linked Vpc. Valid Values: `CREATING`, `RUNNING`.
 * @property vpcId The ID of the VPC.
 * @property vswitchId The ID of the vSwitch.
 */
public data class GetVpcEndpointLinkedVpcsVpcEndpointLinkedVpc(
    public val defaultAccess: Boolean,
    public val id: String,
    public val instanceId: String,
    public val ip: String,
    public val moduleName: String,
    public val status: String,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cr.outputs.GetVpcEndpointLinkedVpcsVpcEndpointLinkedVpc): GetVpcEndpointLinkedVpcsVpcEndpointLinkedVpc = GetVpcEndpointLinkedVpcsVpcEndpointLinkedVpc(
            defaultAccess = javaType.defaultAccess(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            ip = javaType.ip(),
            moduleName = javaType.moduleName(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
