@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.kotlin.outputs.ApplicationService
import com.pulumi.alicloud.cs.kotlin.outputs.ApplicationService.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.alicloud.cs.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

public class Application internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    public val blueGreen: Output<Boolean>?
        get() = javaResource.blueGreen().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val blueGreenConfirm: Output<Boolean>?
        get() = javaResource.blueGreenConfirm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    public val defaultDomain: Output<String>
        get() = javaResource.defaultDomain().applyValue({ args0 -> args0 })

    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val environment: Output<Map<String, String>>?
        get() = javaResource.environment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val latestImage: Output<Boolean>?
        get() = javaResource.latestImage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val services: Output<List<ApplicationService>>
        get() = javaResource.services().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    public val template: Output<String>
        get() = javaResource.template().applyValue({ args0 -> args0 })

    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.alicloud.cs.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
