@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.ApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property blueGreen
 * @property blueGreenConfirm
 * @property clusterName
 * @property description
 * @property environment
 * @property latestImage
 * @property name
 * @property template
 * @property version
 */
public data class ApplicationArgs(
    public val blueGreen: Output<Boolean>? = null,
    public val blueGreenConfirm: Output<Boolean>? = null,
    public val clusterName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val environment: Output<Map<String, String>>? = null,
    public val latestImage: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val template: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.ApplicationArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.ApplicationArgs =
        com.pulumi.alicloud.cs.ApplicationArgs.builder()
            .blueGreen(blueGreen?.applyValue({ args0 -> args0 }))
            .blueGreenConfirm(blueGreenConfirm?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environment(
                environment?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .latestImage(latestImage?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .template(template?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var blueGreen: Output<Boolean>? = null

    private var blueGreenConfirm: Output<Boolean>? = null

    private var clusterName: Output<String>? = null

    private var description: Output<String>? = null

    private var environment: Output<Map<String, String>>? = null

    private var latestImage: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var template: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("sjqembnwnyruexvj")
    public suspend fun blueGreen(`value`: Output<Boolean>) {
        this.blueGreen = value
    }

    /**
     * @param value
     */
    @JvmName("vuvptahathbxndan")
    public suspend fun blueGreenConfirm(`value`: Output<Boolean>) {
        this.blueGreenConfirm = value
    }

    /**
     * @param value
     */
    @JvmName("aropchmxjwguqfbx")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value
     */
    @JvmName("ytfolunlksuogcue")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("rqfksvhddciwrxfx")
    public suspend fun environment(`value`: Output<Map<String, String>>) {
        this.environment = value
    }

    /**
     * @param value
     */
    @JvmName("qllcdiknstorikhy")
    public suspend fun latestImage(`value`: Output<Boolean>) {
        this.latestImage = value
    }

    /**
     * @param value
     */
    @JvmName("yvusrrfgybunixga")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("lyaevtovdumfwspn")
    public suspend fun template(`value`: Output<String>) {
        this.template = value
    }

    /**
     * @param value
     */
    @JvmName("oujlyvenetlodfpl")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value
     */
    @JvmName("wqxfkafcqnvxwvmk")
    public suspend fun blueGreen(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueGreen = mapped
    }

    /**
     * @param value
     */
    @JvmName("uevqqoihvmtsfnnl")
    public suspend fun blueGreenConfirm(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueGreenConfirm = mapped
    }

    /**
     * @param value
     */
    @JvmName("yubcujhqtnddsrvn")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value
     */
    @JvmName("vuefuxmsvcjppsmj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("qwmmjisguqheltmg")
    public suspend fun environment(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param values
     */
    @JvmName("yonbeurhttutfrxv")
    public fun environment(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param value
     */
    @JvmName("epipjwgubuudumvl")
    public suspend fun latestImage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latestImage = mapped
    }

    /**
     * @param value
     */
    @JvmName("xkwatmwyjnpkcbpr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("qdpvcuugabqhkivf")
    public suspend fun template(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.template = mapped
    }

    /**
     * @param value
     */
    @JvmName("jsdywlkopsfrnjps")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        blueGreen = blueGreen,
        blueGreenConfirm = blueGreenConfirm,
        clusterName = clusterName,
        description = description,
        environment = environment,
        latestImage = latestImage,
        name = name,
        template = template,
        version = version,
    )
}
