@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AutoscalingConfig].
 */
@PulumiTagMarker
public class AutoscalingConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutoscalingConfigArgs = AutoscalingConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutoscalingConfigArgsBuilder.() -> Unit) {
        val builder = AutoscalingConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AutoscalingConfig {
        val builtJavaResource = com.pulumi.alicloud.cs.AutoscalingConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AutoscalingConfig(builtJavaResource)
    }
}

/**
 * This resource will help you configure auto scaling for the kubernetes cluster, see [What is autoscaling config](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/api-configure-auto-scaling).
 * > **NOTE:** Available since v1.127.0.
 * > **NOTE:** From version 1.164.0, support for specifying whether to allow the scale-in of nodes by parameter `scale_down_enabled`.
 * > **NOTE:** From version 1.164.0, support for selecting the policy for selecting which node pool to scale by parameter `expander`.
 */
public class AutoscalingConfig internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.AutoscalingConfig,
) : KotlinCustomResource(javaResource, AutoscalingConfigMapper) {
    /**
     * The id of kubernetes cluster.
     */
    public val clusterId: Output<String>?
        get() = javaResource.clusterId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
     */
    public val coolDownDuration: Output<String>?
        get() = javaResource.coolDownDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true DaemonSet pods will be  terminated from nodes. Default is `false`.
     */
    public val daemonsetEvictionForNodes: Output<Boolean>?
        get() = javaResource.daemonsetEvictionForNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
     */
    public val expander: Output<String>?
        get() = javaResource.expander().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The scale-in threshold for GPU instance. Default is `0.5`.
     */
    public val gpuUtilizationThreshold: Output<String>?
        get() = javaResource.gpuUtilizationThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
     */
    public val maxGracefulTerminationSec: Output<Int>?
        get() = javaResource.maxGracefulTerminationSec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
     */
    public val minReplicaCount: Output<Int>?
        get() = javaResource.minReplicaCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
     */
    public val recycleNodeDeletionEnabled: Output<Boolean>?
        get() = javaResource.recycleNodeDeletionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify whether to allow the scale-in of nodes. Default is `true`.
     */
    public val scaleDownEnabled: Output<Boolean>?
        get() = javaResource.scaleDownEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Should CA scale up when there 0 ready nodes. Default is `true`.
     */
    public val scaleUpFromZero: Output<Boolean>?
        get() = javaResource.scaleUpFromZero().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The interval at which the cluster is reevaluated for scaling. Default is `30s`.
     */
    public val scanInterval: Output<String>?
        get() = javaResource.scanInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
     */
    public val skipNodesWithLocalStorage: Output<Boolean>?
        get() = javaResource.skipNodesWithLocalStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
     */
    public val skipNodesWithSystemPods: Output<Boolean>?
        get() = javaResource.skipNodesWithSystemPods().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unneeded duration. Default is `10m`.
     */
    public val unneededDuration: Output<String>?
        get() = javaResource.unneededDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The scale-in threshold. Default is `0.5`.
     */
    public val utilizationThreshold: Output<String>?
        get() = javaResource.utilizationThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AutoscalingConfigMapper : ResourceMapper<AutoscalingConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.AutoscalingConfig::class == javaResource::class

    override fun map(javaResource: Resource): AutoscalingConfig = AutoscalingConfig(
        javaResource as
            com.pulumi.alicloud.cs.AutoscalingConfig,
    )
}

/**
 * @see [AutoscalingConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutoscalingConfig].
 */
public suspend fun autoscalingConfig(
    name: String,
    block: suspend AutoscalingConfigResourceBuilder.() -> Unit,
): AutoscalingConfig {
    val builder = AutoscalingConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutoscalingConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun autoscalingConfig(name: String): AutoscalingConfig {
    val builder = AutoscalingConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
