@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.AutoscalingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This resource will help you configure auto scaling for the kubernetes cluster, see [What is autoscaling config](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/api-configure-auto-scaling).
 * > **NOTE:** Available since v1.127.0.
 * > **NOTE:** From version 1.164.0, support for specifying whether to allow the scale-in of nodes by parameter `scale_down_enabled`.
 * > **NOTE:** From version 1.164.0, support for selecting the policy for selecting which node pool to scale by parameter `expander`.
 * @property clusterId The id of kubernetes cluster.
 * @property coolDownDuration The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
 * @property daemonsetEvictionForNodes If true DaemonSet pods will be  terminated from nodes. Default is `false`.
 * @property expander The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
 * @property gpuUtilizationThreshold The scale-in threshold for GPU instance. Default is `0.5`.
 * @property maxGracefulTerminationSec Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
 * @property minReplicaCount Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
 * @property recycleNodeDeletionEnabled Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
 * @property scaleDownEnabled Specify whether to allow the scale-in of nodes. Default is `true`.
 * @property scaleUpFromZero Should CA scale up when there 0 ready nodes. Default is `true`.
 * @property scanInterval The interval at which the cluster is reevaluated for scaling. Default is `30s`.
 * @property skipNodesWithLocalStorage If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
 * @property skipNodesWithSystemPods If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
 * @property unneededDuration The unneeded duration. Default is `10m`.
 * @property utilizationThreshold The scale-in threshold. Default is `0.5`.
 */
public data class AutoscalingConfigArgs(
    public val clusterId: Output<String>? = null,
    public val coolDownDuration: Output<String>? = null,
    public val daemonsetEvictionForNodes: Output<Boolean>? = null,
    public val expander: Output<String>? = null,
    public val gpuUtilizationThreshold: Output<String>? = null,
    public val maxGracefulTerminationSec: Output<Int>? = null,
    public val minReplicaCount: Output<Int>? = null,
    public val recycleNodeDeletionEnabled: Output<Boolean>? = null,
    public val scaleDownEnabled: Output<Boolean>? = null,
    public val scaleUpFromZero: Output<Boolean>? = null,
    public val scanInterval: Output<String>? = null,
    public val skipNodesWithLocalStorage: Output<Boolean>? = null,
    public val skipNodesWithSystemPods: Output<Boolean>? = null,
    public val unneededDuration: Output<String>? = null,
    public val utilizationThreshold: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.AutoscalingConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.AutoscalingConfigArgs =
        com.pulumi.alicloud.cs.AutoscalingConfigArgs.builder()
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .coolDownDuration(coolDownDuration?.applyValue({ args0 -> args0 }))
            .daemonsetEvictionForNodes(daemonsetEvictionForNodes?.applyValue({ args0 -> args0 }))
            .expander(expander?.applyValue({ args0 -> args0 }))
            .gpuUtilizationThreshold(gpuUtilizationThreshold?.applyValue({ args0 -> args0 }))
            .maxGracefulTerminationSec(maxGracefulTerminationSec?.applyValue({ args0 -> args0 }))
            .minReplicaCount(minReplicaCount?.applyValue({ args0 -> args0 }))
            .recycleNodeDeletionEnabled(recycleNodeDeletionEnabled?.applyValue({ args0 -> args0 }))
            .scaleDownEnabled(scaleDownEnabled?.applyValue({ args0 -> args0 }))
            .scaleUpFromZero(scaleUpFromZero?.applyValue({ args0 -> args0 }))
            .scanInterval(scanInterval?.applyValue({ args0 -> args0 }))
            .skipNodesWithLocalStorage(skipNodesWithLocalStorage?.applyValue({ args0 -> args0 }))
            .skipNodesWithSystemPods(skipNodesWithSystemPods?.applyValue({ args0 -> args0 }))
            .unneededDuration(unneededDuration?.applyValue({ args0 -> args0 }))
            .utilizationThreshold(utilizationThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoscalingConfigArgs].
 */
@PulumiTagMarker
public class AutoscalingConfigArgsBuilder internal constructor() {
    private var clusterId: Output<String>? = null

    private var coolDownDuration: Output<String>? = null

    private var daemonsetEvictionForNodes: Output<Boolean>? = null

    private var expander: Output<String>? = null

    private var gpuUtilizationThreshold: Output<String>? = null

    private var maxGracefulTerminationSec: Output<Int>? = null

    private var minReplicaCount: Output<Int>? = null

    private var recycleNodeDeletionEnabled: Output<Boolean>? = null

    private var scaleDownEnabled: Output<Boolean>? = null

    private var scaleUpFromZero: Output<Boolean>? = null

    private var scanInterval: Output<String>? = null

    private var skipNodesWithLocalStorage: Output<Boolean>? = null

    private var skipNodesWithSystemPods: Output<Boolean>? = null

    private var unneededDuration: Output<String>? = null

    private var utilizationThreshold: Output<String>? = null

    /**
     * @param value The id of kubernetes cluster.
     */
    @JvmName("uqfxjlwvdljipjki")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
     */
    @JvmName("rechjgtljjnsdrgl")
    public suspend fun coolDownDuration(`value`: Output<String>) {
        this.coolDownDuration = value
    }

    /**
     * @param value If true DaemonSet pods will be  terminated from nodes. Default is `false`.
     */
    @JvmName("tygxcunadxmuignj")
    public suspend fun daemonsetEvictionForNodes(`value`: Output<Boolean>) {
        this.daemonsetEvictionForNodes = value
    }

    /**
     * @param value The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
     */
    @JvmName("dbakjmojrmpqxjuj")
    public suspend fun expander(`value`: Output<String>) {
        this.expander = value
    }

    /**
     * @param value The scale-in threshold for GPU instance. Default is `0.5`.
     */
    @JvmName("oqtvcrymklsrbbpk")
    public suspend fun gpuUtilizationThreshold(`value`: Output<String>) {
        this.gpuUtilizationThreshold = value
    }

    /**
     * @param value Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
     */
    @JvmName("ardiimyrukrbblmp")
    public suspend fun maxGracefulTerminationSec(`value`: Output<Int>) {
        this.maxGracefulTerminationSec = value
    }

    /**
     * @param value Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
     */
    @JvmName("ynoavxyfedrbrgeu")
    public suspend fun minReplicaCount(`value`: Output<Int>) {
        this.minReplicaCount = value
    }

    /**
     * @param value Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
     */
    @JvmName("qiphytxsaelpamoe")
    public suspend fun recycleNodeDeletionEnabled(`value`: Output<Boolean>) {
        this.recycleNodeDeletionEnabled = value
    }

    /**
     * @param value Specify whether to allow the scale-in of nodes. Default is `true`.
     */
    @JvmName("tymqrexvrwjkbkil")
    public suspend fun scaleDownEnabled(`value`: Output<Boolean>) {
        this.scaleDownEnabled = value
    }

    /**
     * @param value Should CA scale up when there 0 ready nodes. Default is `true`.
     */
    @JvmName("liwlwvklfyplyfmn")
    public suspend fun scaleUpFromZero(`value`: Output<Boolean>) {
        this.scaleUpFromZero = value
    }

    /**
     * @param value The interval at which the cluster is reevaluated for scaling. Default is `30s`.
     */
    @JvmName("amqonqyhenusyflt")
    public suspend fun scanInterval(`value`: Output<String>) {
        this.scanInterval = value
    }

    /**
     * @param value If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
     */
    @JvmName("twyadsiuslqmqvvw")
    public suspend fun skipNodesWithLocalStorage(`value`: Output<Boolean>) {
        this.skipNodesWithLocalStorage = value
    }

    /**
     * @param value If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
     */
    @JvmName("yrpwfhbtuovniayw")
    public suspend fun skipNodesWithSystemPods(`value`: Output<Boolean>) {
        this.skipNodesWithSystemPods = value
    }

    /**
     * @param value The unneeded duration. Default is `10m`.
     */
    @JvmName("tijcoyuntyqkfgwt")
    public suspend fun unneededDuration(`value`: Output<String>) {
        this.unneededDuration = value
    }

    /**
     * @param value The scale-in threshold. Default is `0.5`.
     */
    @JvmName("inqcjkofsxgowyiq")
    public suspend fun utilizationThreshold(`value`: Output<String>) {
        this.utilizationThreshold = value
    }

    /**
     * @param value The id of kubernetes cluster.
     */
    @JvmName("ltknasksjuwrrctf")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The cool down duration. Default is `10m`. If the delay (cooldown) value is set too long, there could be complaints that the Horizontal Pod Autoscaler is not responsive to workload changes. However, if the delay value is set too short, the scale of the replicas set may keep thrashing as usual.
     */
    @JvmName("kepvwnrfvqssusot")
    public suspend fun coolDownDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coolDownDuration = mapped
    }

    /**
     * @param value If true DaemonSet pods will be  terminated from nodes. Default is `false`.
     */
    @JvmName("gunhfnrdtwrnksie")
    public suspend fun daemonsetEvictionForNodes(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daemonsetEvictionForNodes = mapped
    }

    /**
     * @param value The policy for selecting which node pool to scale. Valid values: `least-waste`, `random`, `priority`. For more information on these policies, see [Configure auto scaling](https://www.alibabacloud.com/help/en/container-service-for-kubernetes/latest/auto-scaling-of-nodes#section-3bg-2ko-inl)
     */
    @JvmName("qwiuocwqeyaymyje")
    public suspend fun expander(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expander = mapped
    }

    /**
     * @param value The scale-in threshold for GPU instance. Default is `0.5`.
     */
    @JvmName("igpcpobvkwnrxyiv")
    public suspend fun gpuUtilizationThreshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpuUtilizationThreshold = mapped
    }

    /**
     * @param value Maximum number of seconds CA waits for pod termination when trying to scale down a node. Default is `14400`.
     */
    @JvmName("refwlgegjeuaogil")
    public suspend fun maxGracefulTerminationSec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxGracefulTerminationSec = mapped
    }

    /**
     * @param value Minimum number of replicas that a replica set or replication controller should have to allow their pods deletion in scale down. Default is `0`.
     */
    @JvmName("qngxvhxqrfujaeqg")
    public suspend fun minReplicaCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minReplicaCount = mapped
    }

    /**
     * @param value Should CA delete the K8s node object when recycle node has scaled down successfully. Default is `false`.
     */
    @JvmName("nfgkghopqicxhndf")
    public suspend fun recycleNodeDeletionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recycleNodeDeletionEnabled = mapped
    }

    /**
     * @param value Specify whether to allow the scale-in of nodes. Default is `true`.
     */
    @JvmName("jiruxbosblhnokjj")
    public suspend fun scaleDownEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleDownEnabled = mapped
    }

    /**
     * @param value Should CA scale up when there 0 ready nodes. Default is `true`.
     */
    @JvmName("uhqgvwuoehwhlxdv")
    public suspend fun scaleUpFromZero(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleUpFromZero = mapped
    }

    /**
     * @param value The interval at which the cluster is reevaluated for scaling. Default is `30s`.
     */
    @JvmName("aihjjgsrytpgwebq")
    public suspend fun scanInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanInterval = mapped
    }

    /**
     * @param value If true cluster autoscaler will never delete nodes with pods with local storage, e.g. EmptyDir or HostPath. Default is `false`.
     */
    @JvmName("natfwfyodpbbcbyd")
    public suspend fun skipNodesWithLocalStorage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipNodesWithLocalStorage = mapped
    }

    /**
     * @param value If true cluster autoscaler will never delete nodes with pods from kube-system (except for DaemonSet or mirror pods). Default is `true`.
     */
    @JvmName("rabgguvaecewpthd")
    public suspend fun skipNodesWithSystemPods(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipNodesWithSystemPods = mapped
    }

    /**
     * @param value The unneeded duration. Default is `10m`.
     */
    @JvmName("lisphdiyrdafxvam")
    public suspend fun unneededDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unneededDuration = mapped
    }

    /**
     * @param value The scale-in threshold. Default is `0.5`.
     */
    @JvmName("vktccgdmtikymyud")
    public suspend fun utilizationThreshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.utilizationThreshold = mapped
    }

    internal fun build(): AutoscalingConfigArgs = AutoscalingConfigArgs(
        clusterId = clusterId,
        coolDownDuration = coolDownDuration,
        daemonsetEvictionForNodes = daemonsetEvictionForNodes,
        expander = expander,
        gpuUtilizationThreshold = gpuUtilizationThreshold,
        maxGracefulTerminationSec = maxGracefulTerminationSec,
        minReplicaCount = minReplicaCount,
        recycleNodeDeletionEnabled = recycleNodeDeletionEnabled,
        scaleDownEnabled = scaleDownEnabled,
        scaleUpFromZero = scaleUpFromZero,
        scanInterval = scanInterval,
        skipNodesWithLocalStorage = skipNodesWithLocalStorage,
        skipNodesWithSystemPods = skipNodesWithSystemPods,
        unneededDuration = unneededDuration,
        utilizationThreshold = utilizationThreshold,
    )
}
