@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.kotlin.outputs.ClusterNode
import com.pulumi.alicloud.cs.kotlin.outputs.ClusterNode.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.alicloud.cs.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

public class Cluster internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    public val agentVersion: Output<String>
        get() = javaResource.agentVersion().applyValue({ args0 -> args0 })

    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    public val diskCategory: Output<String>?
        get() = javaResource.diskCategory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val diskSize: Output<Int>?
        get() = javaResource.diskSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val imageId: Output<String>?
        get() = javaResource.imageId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    public val isOutdated: Output<Boolean>?
        get() = javaResource.isOutdated().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val namePrefix: Output<String>?
        get() = javaResource.namePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val needSlb: Output<Boolean>?
        get() = javaResource.needSlb().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val nodeNumber: Output<Int>?
        get() = javaResource.nodeNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val nodes: Output<List<ClusterNode>>
        get() = javaResource.nodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    public val releaseEip: Output<Boolean>?
        get() = javaResource.releaseEip().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    @Deprecated(
        message = """
  Field 'size' has been deprecated from provider version 1.9.1. New field 'node_number' replaces it.
  """,
    )
    public val size: Output<Int>?
        get() = javaResource.size().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val slbId: Output<String>
        get() = javaResource.slbId().applyValue({ args0 -> args0 })

    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.alicloud.cs.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
