@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidrBlock
 * @property diskCategory
 * @property diskSize
 * @property imageId
 * @property instanceType
 * @property isOutdated
 * @property name
 * @property namePrefix
 * @property needSlb
 * @property nodeNumber
 * @property password
 * @property releaseEip
 * @property size
 * @property vswitchId
 */
public data class ClusterArgs(
    public val cidrBlock: Output<String>? = null,
    public val diskCategory: Output<String>? = null,
    public val diskSize: Output<Int>? = null,
    public val imageId: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val isOutdated: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val needSlb: Output<Boolean>? = null,
    public val nodeNumber: Output<Int>? = null,
    public val password: Output<String>? = null,
    public val releaseEip: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'size' has been deprecated from provider version 1.9.1. New field 'node_number' replaces it.
  """,
    )
    public val size: Output<Int>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.ClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.ClusterArgs =
        com.pulumi.alicloud.cs.ClusterArgs.builder()
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .diskCategory(diskCategory?.applyValue({ args0 -> args0 }))
            .diskSize(diskSize?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .isOutdated(isOutdated?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .needSlb(needSlb?.applyValue({ args0 -> args0 }))
            .nodeNumber(nodeNumber?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .releaseEip(releaseEip?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var diskCategory: Output<String>? = null

    private var diskSize: Output<Int>? = null

    private var imageId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var isOutdated: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var needSlb: Output<Boolean>? = null

    private var nodeNumber: Output<Int>? = null

    private var password: Output<String>? = null

    private var releaseEip: Output<Boolean>? = null

    private var size: Output<Int>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("iulenxxfadtjrhrg")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value
     */
    @JvmName("otwqfbnxgkrvkkur")
    public suspend fun diskCategory(`value`: Output<String>) {
        this.diskCategory = value
    }

    /**
     * @param value
     */
    @JvmName("eyyucotlaxamrjtb")
    public suspend fun diskSize(`value`: Output<Int>) {
        this.diskSize = value
    }

    /**
     * @param value
     */
    @JvmName("nfacmavbfwvkbuwe")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value
     */
    @JvmName("vhraolaiaspwdoma")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value
     */
    @JvmName("okmjgtfcusxahdlw")
    public suspend fun isOutdated(`value`: Output<Boolean>) {
        this.isOutdated = value
    }

    /**
     * @param value
     */
    @JvmName("myykmlmklreakfbe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("ysqvafmkresmmtmn")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value
     */
    @JvmName("bltelakgjwwrwxmf")
    public suspend fun needSlb(`value`: Output<Boolean>) {
        this.needSlb = value
    }

    /**
     * @param value
     */
    @JvmName("ykbwrrrnrxsipfjt")
    public suspend fun nodeNumber(`value`: Output<Int>) {
        this.nodeNumber = value
    }

    /**
     * @param value
     */
    @JvmName("ersxwytciejdgcpc")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value
     */
    @JvmName("tukpniqavkwrhvng")
    public suspend fun releaseEip(`value`: Output<Boolean>) {
        this.releaseEip = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'size' has been deprecated from provider version 1.9.1. New field 'node_number' replaces it.
  """,
    )
    @JvmName("qygtqbkdboogiysa")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value
     */
    @JvmName("cnhebruqqkxyqole")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value
     */
    @JvmName("sytgicpfubtetijc")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value
     */
    @JvmName("hhlqjwfptcqnnlsw")
    public suspend fun diskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCategory = mapped
    }

    /**
     * @param value
     */
    @JvmName("svuboymmndsqklvw")
    public suspend fun diskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("scixignbjusmmemy")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value
     */
    @JvmName("fjdespqgtwvjbyvl")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("muexammxstrfelfu")
    public suspend fun isOutdated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOutdated = mapped
    }

    /**
     * @param value
     */
    @JvmName("kxmbllaanrynsrlq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("pdhoyjipebwgbuvr")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("uvhkuiygfeqsyvnu")
    public suspend fun needSlb(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.needSlb = mapped
    }

    /**
     * @param value
     */
    @JvmName("ivhpnxhyprtanbad")
    public suspend fun nodeNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("uifijlgdpjphmccq")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value
     */
    @JvmName("wjjnqucteioekylt")
    public suspend fun releaseEip(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseEip = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'size' has been deprecated from provider version 1.9.1. New field 'node_number' replaces it.
  """,
    )
    @JvmName("emubeiytgpsyxxni")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value
     */
    @JvmName("sposhhcktpywhywn")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        cidrBlock = cidrBlock,
        diskCategory = diskCategory,
        diskSize = diskSize,
        imageId = imageId,
        instanceType = instanceType,
        isOutdated = isOutdated,
        name = name,
        namePrefix = namePrefix,
        needSlb = needSlb,
        nodeNumber = nodeNumber,
        password = password,
        releaseEip = releaseEip,
        size = size,
        vswitchId = vswitchId,
    )
}
