@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.CsFunctions.getAckServicePlain
import com.pulumi.alicloud.cs.CsFunctions.getClusterCredentialPlain
import com.pulumi.alicloud.cs.CsFunctions.getEdgeKubernetesClustersPlain
import com.pulumi.alicloud.cs.CsFunctions.getKubernetesAddonMetadataPlain
import com.pulumi.alicloud.cs.CsFunctions.getKubernetesAddonsPlain
import com.pulumi.alicloud.cs.CsFunctions.getKubernetesClustersPlain
import com.pulumi.alicloud.cs.CsFunctions.getKubernetesPermissionPlain
import com.pulumi.alicloud.cs.CsFunctions.getKubernetesVersionPlain
import com.pulumi.alicloud.cs.CsFunctions.getManagedKubernetesClustersPlain
import com.pulumi.alicloud.cs.CsFunctions.getRegistryEnterpriseInstancesPlain
import com.pulumi.alicloud.cs.CsFunctions.getRegistryEnterpriseNamespacesPlain
import com.pulumi.alicloud.cs.CsFunctions.getRegistryEnterpriseReposPlain
import com.pulumi.alicloud.cs.CsFunctions.getRegistryEnterpriseSyncRulesPlain
import com.pulumi.alicloud.cs.CsFunctions.getServerlessKubernetesClustersPlain
import com.pulumi.alicloud.cs.kotlin.inputs.GetAckServicePlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetAckServicePlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetClusterCredentialPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetClusterCredentialPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetEdgeKubernetesClustersPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetEdgeKubernetesClustersPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetKubernetesAddonMetadataPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetKubernetesAddonMetadataPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetKubernetesAddonsPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetKubernetesAddonsPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetKubernetesClustersPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetKubernetesClustersPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetKubernetesPermissionPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetKubernetesPermissionPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetKubernetesVersionPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetKubernetesVersionPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetManagedKubernetesClustersPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetManagedKubernetesClustersPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetRegistryEnterpriseInstancesPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetRegistryEnterpriseInstancesPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetRegistryEnterpriseNamespacesPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetRegistryEnterpriseNamespacesPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetRegistryEnterpriseReposPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetRegistryEnterpriseReposPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetRegistryEnterpriseSyncRulesPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetRegistryEnterpriseSyncRulesPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.GetServerlessKubernetesClustersPlainArgs
import com.pulumi.alicloud.cs.kotlin.inputs.GetServerlessKubernetesClustersPlainArgsBuilder
import com.pulumi.alicloud.cs.kotlin.outputs.GetAckServiceResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetClusterCredentialResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetEdgeKubernetesClustersResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesAddonMetadataResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesAddonsResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesClustersResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesPermissionResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesVersionResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetManagedKubernetesClustersResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseInstancesResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseNamespacesResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseReposResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseSyncRulesResult
import com.pulumi.alicloud.cs.kotlin.outputs.GetServerlessKubernetesClustersResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cs.kotlin.outputs.GetAckServiceResult.Companion.toKotlin as getAckServiceResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetClusterCredentialResult.Companion.toKotlin as getClusterCredentialResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetEdgeKubernetesClustersResult.Companion.toKotlin as getEdgeKubernetesClustersResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesAddonMetadataResult.Companion.toKotlin as getKubernetesAddonMetadataResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesAddonsResult.Companion.toKotlin as getKubernetesAddonsResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesClustersResult.Companion.toKotlin as getKubernetesClustersResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesPermissionResult.Companion.toKotlin as getKubernetesPermissionResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetKubernetesVersionResult.Companion.toKotlin as getKubernetesVersionResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetManagedKubernetesClustersResult.Companion.toKotlin as getManagedKubernetesClustersResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseInstancesResult.Companion.toKotlin as getRegistryEnterpriseInstancesResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseNamespacesResult.Companion.toKotlin as getRegistryEnterpriseNamespacesResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseReposResult.Companion.toKotlin as getRegistryEnterpriseReposResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetRegistryEnterpriseSyncRulesResult.Companion.toKotlin as getRegistryEnterpriseSyncRulesResultToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.GetServerlessKubernetesClustersResult.Companion.toKotlin as getServerlessKubernetesClustersResultToKotlin

public object CsFunctions {
    /**
     * Using this data source can open Container Service (CS) service automatically. If the service has been opened, it will return opened.
     * For information about Container Service (CS) and how to use it, see [What is Container Service (CS)](https://www.alibabacloud.com/help/en/product/85222.htm).
     * > **NOTE:** Available in v1.113.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.cs.getAckService({
     *     enable: "On",
     *     type: "propayasgo",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.cs.get_ack_service(enable="On",
     *     type="propayasgo")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.CS.GetAckService.Invoke(new()
     *     {
     *         Enable = "On",
     *         Type = "propayasgo",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cs.GetAckService(ctx, &cs.GetAckServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 			Type:   "propayasgo",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetAckServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = CsFunctions.getAckService(GetAckServiceArgs.builder()
     *             .enable("On")
     *             .type("propayasgo")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:cs:getAckService
     *       Arguments:
     *         enable: On
     *         type: propayasgo
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAckService.
     * @return A collection of values returned by getAckService.
     */
    public suspend fun getAckService(argument: GetAckServicePlainArgs): GetAckServiceResult =
        getAckServiceResultToKotlin(getAckServicePlain(argument.toJava()).await())

    /**
     * @see [getAckService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * @param type Types of services opened. Valid values: `propayasgo`: Container service ack Pro managed version, `edgepayasgo`: Edge container service, `gspayasgo`: Gene computing services.
     * > **NOTE:** Setting `enable = "On"` to open the Container Service (CS) service that means you have read and agreed the [Container Service (CS) Terms of Service](https://help.aliyun.com/document_detail/157971.html). The service can not closed once it is opened.
     * @return A collection of values returned by getAckService.
     */
    public suspend fun getAckService(enable: String? = null, type: String): GetAckServiceResult {
        val argument = GetAckServicePlainArgs(
            enable = enable,
            type = type,
        )
        return getAckServiceResultToKotlin(getAckServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getAckService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetAckServicePlainArgs].
     * @return A collection of values returned by getAckService.
     */
    public suspend fun getAckService(argument: suspend GetAckServicePlainArgsBuilder.() -> Unit): GetAckServiceResult {
        val builder = GetAckServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAckServiceResultToKotlin(getAckServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Container Service cluster credential on Alibaba Cloud.
     * > **NOTE:** Available since v1.187.0
     * > **NOTE:** This datasource can be used on all kinds of ACK clusters, including managed clusters, imported kubernetes clusters, serverless clusters and edge clusters. Please make sure that the target cluster is not in the failed state before using this datasource, since the api server of clusters in the failed state cannot be accessed.
     * @param argument A collection of arguments for invoking getClusterCredential.
     * @return A collection of values returned by getClusterCredential.
     */
    public suspend fun getClusterCredential(argument: GetClusterCredentialPlainArgs): GetClusterCredentialResult =
        getClusterCredentialResultToKotlin(getClusterCredentialPlain(argument.toJava()).await())

    /**
     * @see [getClusterCredential].
     * @param clusterId The id of target cluster.
     * @param outputFile File name where to save the returned KubeConfig (after running `pulumi preview`).
     * @param temporaryDurationMinutes Automatic expiration time of the returned credential. The valid value between `15` and `4320`, in minutes. When this field is omitted, the expiration time will be determined by the system automatically and the result will be in the attributed field `expiration`.
     * @return A collection of values returned by getClusterCredential.
     */
    public suspend fun getClusterCredential(
        clusterId: String,
        outputFile: String? = null,
        temporaryDurationMinutes: Int? = null,
    ): GetClusterCredentialResult {
        val argument = GetClusterCredentialPlainArgs(
            clusterId = clusterId,
            outputFile = outputFile,
            temporaryDurationMinutes = temporaryDurationMinutes,
        )
        return getClusterCredentialResultToKotlin(getClusterCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterCredential].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetClusterCredentialPlainArgs].
     * @return A collection of values returned by getClusterCredential.
     */
    public suspend fun getClusterCredential(argument: suspend GetClusterCredentialPlainArgsBuilder.() -> Unit): GetClusterCredentialResult {
        val builder = GetClusterCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterCredentialResultToKotlin(getClusterCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list Container Service Edge Kubernetes Clusters on Alibaba Cloud.
     * > **NOTE:** Available in v1.103.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const k8sClusters = alicloud.cs.getEdgeKubernetesClusters({
     *     nameRegex: "my-first-k8s",
     *     outputFile: "my-first-k8s-json",
     * });
     * export const output = k8sClusters.then(k8sClusters => k8sClusters.clusters);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * k8s_clusters = alicloud.cs.get_edge_kubernetes_clusters(name_regex="my-first-k8s",
     *     output_file="my-first-k8s-json")
     * pulumi.export("output", k8s_clusters.clusters)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var k8sClusters = AliCloud.CS.GetEdgeKubernetesClusters.Invoke(new()
     *     {
     *         NameRegex = "my-first-k8s",
     *         OutputFile = "my-first-k8s-json",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["output"] = k8sClusters.Apply(getEdgeKubernetesClustersResult => getEdgeKubernetesClustersResult.Clusters),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		k8sClusters, err := cs.GetEdgeKubernetesClusters(ctx, &cs.GetEdgeKubernetesClustersArgs{
     * 			NameRegex:  pulumi.StringRef("my-first-k8s"),
     * 			OutputFile: pulumi.StringRef("my-first-k8s-json"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("output", k8sClusters.Clusters)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetEdgeKubernetesClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var k8sClusters = CsFunctions.getEdgeKubernetesClusters(GetEdgeKubernetesClustersArgs.builder()
     *             .nameRegex("my-first-k8s")
     *             .outputFile("my-first-k8s-json")
     *             .build());
     *         ctx.export("output", k8sClusters.applyValue(getEdgeKubernetesClustersResult -> getEdgeKubernetesClustersResult.clusters()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   k8sClusters:
     *     fn::invoke:
     *       Function: alicloud:cs:getEdgeKubernetesClusters
     *       Arguments:
     *         nameRegex: my-first-k8s
     *         outputFile: my-first-k8s-json
     * outputs:
     *   output: ${k8sClusters.clusters}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEdgeKubernetesClusters.
     * @return A collection of values returned by getEdgeKubernetesClusters.
     */
    public suspend fun getEdgeKubernetesClusters(argument: GetEdgeKubernetesClustersPlainArgs): GetEdgeKubernetesClustersResult =
        getEdgeKubernetesClustersResultToKotlin(getEdgeKubernetesClustersPlain(argument.toJava()).await())

    /**
     * @see [getEdgeKubernetesClusters].
     * @param enableDetails
     * @param ids Cluster IDs to filter.
     * @param nameRegex A regex string to filter results by cluster name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getEdgeKubernetesClusters.
     */
    public suspend fun getEdgeKubernetesClusters(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetEdgeKubernetesClustersResult {
        val argument = GetEdgeKubernetesClustersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getEdgeKubernetesClustersResultToKotlin(getEdgeKubernetesClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getEdgeKubernetesClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetEdgeKubernetesClustersPlainArgs].
     * @return A collection of values returned by getEdgeKubernetesClusters.
     */
    public suspend fun getEdgeKubernetesClusters(argument: suspend GetEdgeKubernetesClustersPlainArgsBuilder.() -> Unit): GetEdgeKubernetesClustersResult {
        val builder = GetEdgeKubernetesClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEdgeKubernetesClustersResultToKotlin(getEdgeKubernetesClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides metadata of kubernetes cluster addons.
     * > **NOTE:** Available in 1.166.0+.
     * @param argument A collection of arguments for invoking getKubernetesAddonMetadata.
     * @return A collection of values returned by getKubernetesAddonMetadata.
     */
    public suspend fun getKubernetesAddonMetadata(argument: GetKubernetesAddonMetadataPlainArgs): GetKubernetesAddonMetadataResult =
        getKubernetesAddonMetadataResultToKotlin(getKubernetesAddonMetadataPlain(argument.toJava()).await())

    /**
     * @see [getKubernetesAddonMetadata].
     * @param clusterId The id of kubernetes cluster.
     * @param name The name of the cluster addon. You can get a list of available addons that the cluster can install by using data source `alicloud.cs.getKubernetesAddons`.
     * @param version The version of the cluster addon.
     * @return A collection of values returned by getKubernetesAddonMetadata.
     */
    public suspend fun getKubernetesAddonMetadata(
        clusterId: String,
        name: String,
        version: String,
    ): GetKubernetesAddonMetadataResult {
        val argument = GetKubernetesAddonMetadataPlainArgs(
            clusterId = clusterId,
            name = name,
            version = version,
        )
        return getKubernetesAddonMetadataResultToKotlin(getKubernetesAddonMetadataPlain(argument.toJava()).await())
    }

    /**
     * @see [getKubernetesAddonMetadata].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetKubernetesAddonMetadataPlainArgs].
     * @return A collection of values returned by getKubernetesAddonMetadata.
     */
    public suspend fun getKubernetesAddonMetadata(argument: suspend GetKubernetesAddonMetadataPlainArgsBuilder.() -> Unit): GetKubernetesAddonMetadataResult {
        val builder = GetKubernetesAddonMetadataPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKubernetesAddonMetadataResultToKotlin(getKubernetesAddonMetadataPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of available addons that the cluster can install.
     * > **NOTE:** Available since v1.150.0.
     * > **NOTE:** From version v1.166.0, support for returning custom configuration of kubernetes cluster addon.
     * @param argument A collection of arguments for invoking getKubernetesAddons.
     * @return A collection of values returned by getKubernetesAddons.
     */
    public suspend fun getKubernetesAddons(argument: GetKubernetesAddonsPlainArgs): GetKubernetesAddonsResult =
        getKubernetesAddonsResultToKotlin(getKubernetesAddonsPlain(argument.toJava()).await())

    /**
     * @see [getKubernetesAddons].
     * @param clusterId The id of kubernetes cluster.
     * @param ids A list of addon IDs. The id of addon consists of the cluster id and the addon name, with the structure <cluster_ud>:<addon_name>.
     * @param nameRegex A regex string to filter results by addon name.
     * @return A collection of values returned by getKubernetesAddons.
     */
    public suspend fun getKubernetesAddons(
        clusterId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
    ): GetKubernetesAddonsResult {
        val argument = GetKubernetesAddonsPlainArgs(
            clusterId = clusterId,
            ids = ids,
            nameRegex = nameRegex,
        )
        return getKubernetesAddonsResultToKotlin(getKubernetesAddonsPlain(argument.toJava()).await())
    }

    /**
     * @see [getKubernetesAddons].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetKubernetesAddonsPlainArgs].
     * @return A collection of values returned by getKubernetesAddons.
     */
    public suspend fun getKubernetesAddons(argument: suspend GetKubernetesAddonsPlainArgsBuilder.() -> Unit): GetKubernetesAddonsResult {
        val builder = GetKubernetesAddonsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKubernetesAddonsResultToKotlin(getKubernetesAddonsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list Container Service Kubernetes Clusters on Alibaba Cloud.
     * > **NOTE:** Available since v1.34.0+.
     * > **NOTE:** From version 1.177.0+, We supported batch export of clusters' kube config information by `kube_config_file_prefix`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const k8sClusters = alicloud.cs.getKubernetesClusters({
     *     nameRegex: "my-first-k8s",
     *     outputFile: "my-first-k8s-json",
     *     kubeConfigFilePrefix: "~/.kube/k8s",
     * });
     * export const output = k8sClusters.then(k8sClusters => k8sClusters.clusters);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * k8s_clusters = alicloud.cs.get_kubernetes_clusters(name_regex="my-first-k8s",
     *     output_file="my-first-k8s-json",
     *     kube_config_file_prefix="~/.kube/k8s")
     * pulumi.export("output", k8s_clusters.clusters)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var k8sClusters = AliCloud.CS.GetKubernetesClusters.Invoke(new()
     *     {
     *         NameRegex = "my-first-k8s",
     *         OutputFile = "my-first-k8s-json",
     *         KubeConfigFilePrefix = "~/.kube/k8s",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["output"] = k8sClusters.Apply(getKubernetesClustersResult => getKubernetesClustersResult.Clusters),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		k8sClusters, err := cs.GetKubernetesClusters(ctx, &cs.GetKubernetesClustersArgs{
     * 			NameRegex:            pulumi.StringRef("my-first-k8s"),
     * 			OutputFile:           pulumi.StringRef("my-first-k8s-json"),
     * 			KubeConfigFilePrefix: pulumi.StringRef("~/.kube/k8s"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("output", k8sClusters.Clusters)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetKubernetesClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var k8sClusters = CsFunctions.getKubernetesClusters(GetKubernetesClustersArgs.builder()
     *             .nameRegex("my-first-k8s")
     *             .outputFile("my-first-k8s-json")
     *             .kubeConfigFilePrefix("~/.kube/k8s")
     *             .build());
     *         ctx.export("output", k8sClusters.applyValue(getKubernetesClustersResult -> getKubernetesClustersResult.clusters()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   k8sClusters:
     *     fn::invoke:
     *       Function: alicloud:cs:getKubernetesClusters
     *       Arguments:
     *         nameRegex: my-first-k8s
     *         outputFile: my-first-k8s-json
     *         kubeConfigFilePrefix: ~/.kube/k8s
     * outputs:
     *   output: ${k8sClusters.clusters}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKubernetesClusters.
     * @return A collection of values returned by getKubernetesClusters.
     */
    public suspend fun getKubernetesClusters(argument: GetKubernetesClustersPlainArgs): GetKubernetesClustersResult =
        getKubernetesClustersResultToKotlin(getKubernetesClustersPlain(argument.toJava()).await())

    /**
     * @see [getKubernetesClusters].
     * @param enableDetails Boolean, false by default, only `id` and `name` are exported. Set to true if more details are needed, e.g., `master_disk_category`, `slb_internet_enabled`, `connections`. See full list in attributes.
     * @param ids Cluster IDs to filter.
     * @param kubeConfigFilePrefix The path prefix of kube config. You could store kube config in a specified directory by specifying this field, like `~/.kube/k8s`, then it will be named with `~/.kube/k8s-clusterID-kubeconfig`. From version 1.187.0+, kube_config will not export kube_config if this field is not set.
     * @param nameRegex A regex string to filter results by cluster name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getKubernetesClusters.
     */
    public suspend fun getKubernetesClusters(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        kubeConfigFilePrefix: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetKubernetesClustersResult {
        val argument = GetKubernetesClustersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            kubeConfigFilePrefix = kubeConfigFilePrefix,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getKubernetesClustersResultToKotlin(getKubernetesClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getKubernetesClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetKubernetesClustersPlainArgs].
     * @return A collection of values returned by getKubernetesClusters.
     */
    public suspend fun getKubernetesClusters(argument: suspend GetKubernetesClustersPlainArgsBuilder.() -> Unit): GetKubernetesClustersResult {
        val builder = GetKubernetesClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKubernetesClustersResultToKotlin(getKubernetesClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Ram user permissions.
     * > **NOTE:** Available since v1.122.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const default = alicloud.ram.getUsers({});
     * // permissions
     * const defaultGetKubernetesPermission = _default.then(_default => alicloud.cs.getKubernetesPermission({
     *     uid: _default.users?.[0]?.id,
     * }));
     * export const permissions = defaultGetKubernetesPermission.then(defaultGetKubernetesPermission => defaultGetKubernetesPermission.permissions);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * default = alicloud.ram.get_users()
     * # permissions
     * default_get_kubernetes_permission = alicloud.cs.get_kubernetes_permission(uid=default.users[0].id)
     * pulumi.export("permissions", default_get_kubernetes_permission.permissions)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var @default = AliCloud.Ram.GetUsers.Invoke();
     *     // permissions
     *     var defaultGetKubernetesPermission = AliCloud.CS.GetKubernetesPermission.Invoke(new()
     *     {
     *         Uid = @default.Apply(getUsersResult => getUsersResult.Users[0]?.Id),
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["permissions"] = defaultGetKubernetesPermission.Apply(getKubernetesPermissionResult => getKubernetesPermissionResult.Permissions),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		_default, err := ram.GetUsers(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// permissions
     * 		defaultGetKubernetesPermission, err := cs.LookupKubernetesPermission(ctx, &cs.LookupKubernetesPermissionArgs{
     * 			Uid: _default.Users[0].Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("permissions", defaultGetKubernetesPermission.Permissions)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ram.RamFunctions;
     * import com.pulumi.alicloud.ram.inputs.GetUsersArgs;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetKubernetesPermissionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var default = RamFunctions.getUsers();
     *         // permissions
     *         final var defaultGetKubernetesPermission = CsFunctions.getKubernetesPermission(GetKubernetesPermissionArgs.builder()
     *             .uid(default_.users()[0].id())
     *             .build());
     *         ctx.export("permissions", defaultGetKubernetesPermission.applyValue(getKubernetesPermissionResult -> getKubernetesPermissionResult.permissions()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ram:getUsers
     *       Arguments: {}
     *   # permissions
     *   defaultGetKubernetesPermission:
     *     fn::invoke:
     *       Function: alicloud:cs:getKubernetesPermission
     *       Arguments:
     *         uid: ${default.users[0].id}
     * outputs:
     *   permissions: ${defaultGetKubernetesPermission.permissions}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKubernetesPermission.
     * @return A collection of values returned by getKubernetesPermission.
     */
    public suspend fun getKubernetesPermission(argument: GetKubernetesPermissionPlainArgs): GetKubernetesPermissionResult =
        getKubernetesPermissionResultToKotlin(getKubernetesPermissionPlain(argument.toJava()).await())

    /**
     * @see [getKubernetesPermission].
     * @param uid The ID of the RAM user. If you want to query the permissions of a RAM role, specify the ID of the RAM role.
     * @return A collection of values returned by getKubernetesPermission.
     */
    public suspend fun getKubernetesPermission(uid: String): GetKubernetesPermissionResult {
        val argument = GetKubernetesPermissionPlainArgs(
            uid = uid,
        )
        return getKubernetesPermissionResultToKotlin(getKubernetesPermissionPlain(argument.toJava()).await())
    }

    /**
     * @see [getKubernetesPermission].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetKubernetesPermissionPlainArgs].
     * @return A collection of values returned by getKubernetesPermission.
     */
    public suspend fun getKubernetesPermission(argument: suspend GetKubernetesPermissionPlainArgsBuilder.() -> Unit): GetKubernetesPermissionResult {
        val builder = GetKubernetesPermissionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKubernetesPermissionResultToKotlin(getKubernetesPermissionPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the details of the Kubernetes version supported by ACK.
     * > **NOTE:** Available in 1.170.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Query the managed kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     * const default = alicloud.cs.getKubernetesVersion({
     *     clusterType: "ManagedKubernetes",
     *     kubernetesVersion: "1.22.3-aliyun.1",
     *     profile: "Default",
     * });
     * export const metadata = _default.then(_default => _default.metadatas);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Query the managed kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     * default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
     *     kubernetes_version="1.22.3-aliyun.1",
     *     profile="Default")
     * pulumi.export("metadata", default.metadatas)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Query the managed kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     *     var @default = AliCloud.CS.GetKubernetesVersion.Invoke(new()
     *     {
     *         ClusterType = "ManagedKubernetes",
     *         KubernetesVersion = "1.22.3-aliyun.1",
     *         Profile = "Default",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["metadata"] = @default.Apply(@default => @default.Apply(getKubernetesVersionResult => getKubernetesVersionResult.Metadatas)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Query the managed kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     * 		_default, err := cs.GetKubernetesVersion(ctx, &cs.GetKubernetesVersionArgs{
     * 			ClusterType:       "ManagedKubernetes",
     * 			KubernetesVersion: pulumi.StringRef("1.22.3-aliyun.1"),
     * 			Profile:           pulumi.StringRef("Default"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("metadata", _default.Metadatas)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetKubernetesVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Query the managed kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     *         final var default = CsFunctions.getKubernetesVersion(GetKubernetesVersionArgs.builder()
     *             .clusterType("ManagedKubernetes")
     *             .kubernetesVersion("1.22.3-aliyun.1")
     *             .profile("Default")
     *             .build());
     *         ctx.export("metadata", default_.metadatas());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Query the managed kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cs:getKubernetesVersion
     *       Arguments:
     *         clusterType: ManagedKubernetes
     *         kubernetesVersion: 1.22.3-aliyun.1
     *         profile: Default
     * outputs:
     *   metadata: ${default.metadatas}
     * ```
     * <!--End PulumiCodeChooser -->
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Query the kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     * const default = alicloud.cs.getKubernetesVersion({
     *     clusterType: "Kubernetes",
     *     kubernetesVersion: "1.22.3-aliyun.1",
     *     profile: "Default",
     * });
     * export const metadata = _default.then(_default => _default.metadatas);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Query the kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     * default = alicloud.cs.get_kubernetes_version(cluster_type="Kubernetes",
     *     kubernetes_version="1.22.3-aliyun.1",
     *     profile="Default")
     * pulumi.export("metadata", default.metadatas)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Query the kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     *     var @default = AliCloud.CS.GetKubernetesVersion.Invoke(new()
     *     {
     *         ClusterType = "Kubernetes",
     *         KubernetesVersion = "1.22.3-aliyun.1",
     *         Profile = "Default",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["metadata"] = @default.Apply(@default => @default.Apply(getKubernetesVersionResult => getKubernetesVersionResult.Metadatas)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Query the kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     * 		_default, err := cs.GetKubernetesVersion(ctx, &cs.GetKubernetesVersionArgs{
     * 			ClusterType:       "Kubernetes",
     * 			KubernetesVersion: pulumi.StringRef("1.22.3-aliyun.1"),
     * 			Profile:           pulumi.StringRef("Default"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("metadata", _default.Metadatas)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetKubernetesVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Query the kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     *         final var default = CsFunctions.getKubernetesVersion(GetKubernetesVersionArgs.builder()
     *             .clusterType("Kubernetes")
     *             .kubernetesVersion("1.22.3-aliyun.1")
     *             .profile("Default")
     *             .build());
     *         ctx.export("metadata", default_.metadatas());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Query the kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cs:getKubernetesVersion
     *       Arguments:
     *         clusterType: Kubernetes
     *         kubernetesVersion: 1.22.3-aliyun.1
     *         profile: Default
     * outputs:
     *   metadata: ${default.metadatas}
     * ```
     * <!--End PulumiCodeChooser -->
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Query the serverless kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     * const default = alicloud.cs.getKubernetesVersion({
     *     clusterType: "ManagedKubernetes",
     *     kubernetesVersion: "1.22.3-aliyun.1",
     *     profile: "Serverless",
     * });
     * export const metadata = _default.then(_default => _default.metadatas);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Query the serverless kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     * default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
     *     kubernetes_version="1.22.3-aliyun.1",
     *     profile="Serverless")
     * pulumi.export("metadata", default.metadatas)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Query the serverless kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     *     var @default = AliCloud.CS.GetKubernetesVersion.Invoke(new()
     *     {
     *         ClusterType = "ManagedKubernetes",
     *         KubernetesVersion = "1.22.3-aliyun.1",
     *         Profile = "Serverless",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["metadata"] = @default.Apply(@default => @default.Apply(getKubernetesVersionResult => getKubernetesVersionResult.Metadatas)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Query the serverless kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     * 		_default, err := cs.GetKubernetesVersion(ctx, &cs.GetKubernetesVersionArgs{
     * 			ClusterType:       "ManagedKubernetes",
     * 			KubernetesVersion: pulumi.StringRef("1.22.3-aliyun.1"),
     * 			Profile:           pulumi.StringRef("Serverless"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("metadata", _default.Metadatas)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetKubernetesVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Query the serverless kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     *         final var default = CsFunctions.getKubernetesVersion(GetKubernetesVersionArgs.builder()
     *             .clusterType("ManagedKubernetes")
     *             .kubernetesVersion("1.22.3-aliyun.1")
     *             .profile("Serverless")
     *             .build());
     *         ctx.export("metadata", default_.metadatas());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Query the serverless kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cs:getKubernetesVersion
     *       Arguments:
     *         clusterType: ManagedKubernetes
     *         kubernetesVersion: 1.22.3-aliyun.1
     *         profile: Serverless
     * outputs:
     *   metadata: ${default.metadatas}
     * ```
     * <!--End PulumiCodeChooser -->
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Query the edge kubernetes cluster metadata of version 1.20.11-aliyunedge.1 in the region specified by the client.
     * const default = alicloud.cs.getKubernetesVersion({
     *     clusterType: "ManagedKubernetes",
     *     kubernetesVersion: "1.20.11-aliyunedge.1",
     *     profile: "Edge",
     * });
     * export const metadata = _default.then(_default => _default.metadatas);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Query the edge kubernetes cluster metadata of version 1.20.11-aliyunedge.1 in the region specified by the client.
     * default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
     *     kubernetes_version="1.20.11-aliyunedge.1",
     *     profile="Edge")
     * pulumi.export("metadata", default.metadatas)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Query the edge kubernetes cluster metadata of version 1.20.11-aliyunedge.1 in the region specified by the client.
     *     var @default = AliCloud.CS.GetKubernetesVersion.Invoke(new()
     *     {
     *         ClusterType = "ManagedKubernetes",
     *         KubernetesVersion = "1.20.11-aliyunedge.1",
     *         Profile = "Edge",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["metadata"] = @default.Apply(@default => @default.Apply(getKubernetesVersionResult => getKubernetesVersionResult.Metadatas)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Query the edge kubernetes cluster metadata of version 1.20.11-aliyunedge.1 in the region specified by the client.
     * 		_default, err := cs.GetKubernetesVersion(ctx, &cs.GetKubernetesVersionArgs{
     * 			ClusterType:       "ManagedKubernetes",
     * 			KubernetesVersion: pulumi.StringRef("1.20.11-aliyunedge.1"),
     * 			Profile:           pulumi.StringRef("Edge"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("metadata", _default.Metadatas)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetKubernetesVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Query the edge kubernetes cluster metadata of version 1.20.11-aliyunedge.1 in the region specified by the client.
     *         final var default = CsFunctions.getKubernetesVersion(GetKubernetesVersionArgs.builder()
     *             .clusterType("ManagedKubernetes")
     *             .kubernetesVersion("1.20.11-aliyunedge.1")
     *             .profile("Edge")
     *             .build());
     *         ctx.export("metadata", default_.metadatas());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Query the edge kubernetes cluster metadata of version 1.20.11-aliyunedge.1 in the region specified by the client.
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cs:getKubernetesVersion
     *       Arguments:
     *         clusterType: ManagedKubernetes
     *         kubernetesVersion: 1.20.11-aliyunedge.1
     *         profile: Edge
     * outputs:
     *   metadata: ${default.metadatas}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKubernetesVersion.
     * @return A collection of values returned by getKubernetesVersion.
     */
    public suspend fun getKubernetesVersion(argument: GetKubernetesVersionPlainArgs): GetKubernetesVersionResult =
        getKubernetesVersionResultToKotlin(getKubernetesVersionPlain(argument.toJava()).await())

    /**
     * @see [getKubernetesVersion].
     * @param clusterType The type of cluster. Its valid value are `Kubernetes` and `ManagedKubernetes`.
     * @param kubernetesVersion The ACK released kubernetes version.
     * @param profile The profile of cluster. Its valid value are `Default`, `Serverless` and `Edge`.
     * @return A collection of values returned by getKubernetesVersion.
     */
    public suspend fun getKubernetesVersion(
        clusterType: String,
        kubernetesVersion: String? = null,
        profile: String? = null,
    ): GetKubernetesVersionResult {
        val argument = GetKubernetesVersionPlainArgs(
            clusterType = clusterType,
            kubernetesVersion = kubernetesVersion,
            profile = profile,
        )
        return getKubernetesVersionResultToKotlin(getKubernetesVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getKubernetesVersion].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetKubernetesVersionPlainArgs].
     * @return A collection of values returned by getKubernetesVersion.
     */
    public suspend fun getKubernetesVersion(argument: suspend GetKubernetesVersionPlainArgsBuilder.() -> Unit): GetKubernetesVersionResult {
        val builder = GetKubernetesVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKubernetesVersionResultToKotlin(getKubernetesVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list Container Service Managed Kubernetes Clusters on Alibaba Cloud.
     * > **NOTE:** Available in v1.35.0+
     * > **NOTE:** From version 1.177.0+, We supported batch export of clusters' kube config information by `kube_config_file_prefix`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const k8sClusters = alicloud.cs.getManagedKubernetesClusters({
     *     nameRegex: "my-first-k8s",
     *     outputFile: "my-first-k8s-json",
     *     kubeConfigFilePrefix: "~/.kube/managed",
     * });
     * export const output = k8sClusters.then(k8sClusters => k8sClusters.clusters);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * k8s_clusters = alicloud.cs.get_managed_kubernetes_clusters(name_regex="my-first-k8s",
     *     output_file="my-first-k8s-json",
     *     kube_config_file_prefix="~/.kube/managed")
     * pulumi.export("output", k8s_clusters.clusters)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var k8sClusters = AliCloud.CS.GetManagedKubernetesClusters.Invoke(new()
     *     {
     *         NameRegex = "my-first-k8s",
     *         OutputFile = "my-first-k8s-json",
     *         KubeConfigFilePrefix = "~/.kube/managed",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["output"] = k8sClusters.Apply(getManagedKubernetesClustersResult => getManagedKubernetesClustersResult.Clusters),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		k8sClusters, err := cs.GetManagedKubernetesClusters(ctx, &cs.GetManagedKubernetesClustersArgs{
     * 			NameRegex:            pulumi.StringRef("my-first-k8s"),
     * 			OutputFile:           pulumi.StringRef("my-first-k8s-json"),
     * 			KubeConfigFilePrefix: pulumi.StringRef("~/.kube/managed"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("output", k8sClusters.Clusters)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetManagedKubernetesClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var k8sClusters = CsFunctions.getManagedKubernetesClusters(GetManagedKubernetesClustersArgs.builder()
     *             .nameRegex("my-first-k8s")
     *             .outputFile("my-first-k8s-json")
     *             .kubeConfigFilePrefix("~/.kube/managed")
     *             .build());
     *         ctx.export("output", k8sClusters.applyValue(getManagedKubernetesClustersResult -> getManagedKubernetesClustersResult.clusters()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   k8sClusters:
     *     fn::invoke:
     *       Function: alicloud:cs:getManagedKubernetesClusters
     *       Arguments:
     *         nameRegex: my-first-k8s
     *         outputFile: my-first-k8s-json
     *         kubeConfigFilePrefix: ~/.kube/managed
     * outputs:
     *   output: ${k8sClusters.clusters}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getManagedKubernetesClusters.
     * @return A collection of values returned by getManagedKubernetesClusters.
     */
    public suspend fun getManagedKubernetesClusters(argument: GetManagedKubernetesClustersPlainArgs): GetManagedKubernetesClustersResult =
        getManagedKubernetesClustersResultToKotlin(getManagedKubernetesClustersPlain(argument.toJava()).await())

    /**
     * @see [getManagedKubernetesClusters].
     * @param enableDetails
     * @param ids Cluster IDs to filter.
     * @param kubeConfigFilePrefix The path prefix of kube config. You could store kube config in a specified directory by specifying this field, like `~/.kube/managed`, then it will be named with `~/.kube/managed-clusterID-kubeconfig`. From version 1.187.0+, kube_config will not export kube_config if this field is not set.
     * @param nameRegex A regex string to filter results by cluster name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getManagedKubernetesClusters.
     */
    public suspend fun getManagedKubernetesClusters(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        kubeConfigFilePrefix: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetManagedKubernetesClustersResult {
        val argument = GetManagedKubernetesClustersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            kubeConfigFilePrefix = kubeConfigFilePrefix,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getManagedKubernetesClustersResultToKotlin(getManagedKubernetesClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedKubernetesClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetManagedKubernetesClustersPlainArgs].
     * @return A collection of values returned by getManagedKubernetesClusters.
     */
    public suspend fun getManagedKubernetesClusters(argument: suspend GetManagedKubernetesClustersPlainArgsBuilder.() -> Unit): GetManagedKubernetesClustersResult {
        val builder = GetManagedKubernetesClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedKubernetesClustersResultToKotlin(getManagedKubernetesClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list Container Registry Enterprise Edition instances on Alibaba Cloud.
     * > **NOTE:** Available in v1.86.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const myInstances = alicloud.cs.getRegistryEnterpriseInstances({
     *     nameRegex: "my-instances",
     *     outputFile: "my-instances-json",
     * });
     * export const output = myInstances.then(myInstances => myInstances.instances);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * my_instances = alicloud.cs.get_registry_enterprise_instances(name_regex="my-instances",
     *     output_file="my-instances-json")
     * pulumi.export("output", my_instances.instances)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var myInstances = AliCloud.CS.GetRegistryEnterpriseInstances.Invoke(new()
     *     {
     *         NameRegex = "my-instances",
     *         OutputFile = "my-instances-json",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["output"] = myInstances.Apply(getRegistryEnterpriseInstancesResult => getRegistryEnterpriseInstancesResult.Instances),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		myInstances, err := cs.GetRegistryEnterpriseInstances(ctx, &cs.GetRegistryEnterpriseInstancesArgs{
     * 			NameRegex:  pulumi.StringRef("my-instances"),
     * 			OutputFile: pulumi.StringRef("my-instances-json"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("output", myInstances.Instances)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var myInstances = CsFunctions.getRegistryEnterpriseInstances(GetRegistryEnterpriseInstancesArgs.builder()
     *             .nameRegex("my-instances")
     *             .outputFile("my-instances-json")
     *             .build());
     *         ctx.export("output", myInstances.applyValue(getRegistryEnterpriseInstancesResult -> getRegistryEnterpriseInstancesResult.instances()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   myInstances:
     *     fn::invoke:
     *       Function: alicloud:cs:getRegistryEnterpriseInstances
     *       Arguments:
     *         nameRegex: my-instances
     *         outputFile: my-instances-json
     * outputs:
     *   output: ${myInstances.instances}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRegistryEnterpriseInstances.
     * @return A collection of values returned by getRegistryEnterpriseInstances.
     */
    public suspend fun getRegistryEnterpriseInstances(argument: GetRegistryEnterpriseInstancesPlainArgs): GetRegistryEnterpriseInstancesResult =
        getRegistryEnterpriseInstancesResultToKotlin(getRegistryEnterpriseInstancesPlain(argument.toJava()).await())

    /**
     * @see [getRegistryEnterpriseInstances].
     * @param enableDetails Default to `true`. Set it to true can output instance authorization token.
     * @param ids A list of ids to filter results by instance id.
     * @param nameRegex A regex string to filter results by instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getRegistryEnterpriseInstances.
     */
    public suspend fun getRegistryEnterpriseInstances(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetRegistryEnterpriseInstancesResult {
        val argument = GetRegistryEnterpriseInstancesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getRegistryEnterpriseInstancesResultToKotlin(getRegistryEnterpriseInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryEnterpriseInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetRegistryEnterpriseInstancesPlainArgs].
     * @return A collection of values returned by getRegistryEnterpriseInstances.
     */
    public suspend fun getRegistryEnterpriseInstances(argument: suspend GetRegistryEnterpriseInstancesPlainArgsBuilder.() -> Unit): GetRegistryEnterpriseInstancesResult {
        val builder = GetRegistryEnterpriseInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryEnterpriseInstancesResultToKotlin(getRegistryEnterpriseInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list Container Registry Enterprise Edition namespaces on Alibaba Cloud.
     * > **NOTE:** Available in v1.86.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const myNamespaces = alicloud.cs.getRegistryEnterpriseNamespaces({
     *     instanceId: "cri-xxx",
     *     nameRegex: "my-namespace",
     *     outputFile: "my-namespace-json",
     * });
     * export const output = myNamespaces.then(myNamespaces => myNamespaces.namespaces);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * my_namespaces = alicloud.cs.get_registry_enterprise_namespaces(instance_id="cri-xxx",
     *     name_regex="my-namespace",
     *     output_file="my-namespace-json")
     * pulumi.export("output", my_namespaces.namespaces)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var myNamespaces = AliCloud.CS.GetRegistryEnterpriseNamespaces.Invoke(new()
     *     {
     *         InstanceId = "cri-xxx",
     *         NameRegex = "my-namespace",
     *         OutputFile = "my-namespace-json",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["output"] = myNamespaces.Apply(getRegistryEnterpriseNamespacesResult => getRegistryEnterpriseNamespacesResult.Namespaces),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		myNamespaces, err := cs.GetRegistryEnterpriseNamespaces(ctx, &cs.GetRegistryEnterpriseNamespacesArgs{
     * 			InstanceId: "cri-xxx",
     * 			NameRegex:  pulumi.StringRef("my-namespace"),
     * 			OutputFile: pulumi.StringRef("my-namespace-json"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("output", myNamespaces.Namespaces)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseNamespacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var myNamespaces = CsFunctions.getRegistryEnterpriseNamespaces(GetRegistryEnterpriseNamespacesArgs.builder()
     *             .instanceId("cri-xxx")
     *             .nameRegex("my-namespace")
     *             .outputFile("my-namespace-json")
     *             .build());
     *         ctx.export("output", myNamespaces.applyValue(getRegistryEnterpriseNamespacesResult -> getRegistryEnterpriseNamespacesResult.namespaces()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   myNamespaces:
     *     fn::invoke:
     *       Function: alicloud:cs:getRegistryEnterpriseNamespaces
     *       Arguments:
     *         instanceId: cri-xxx
     *         nameRegex: my-namespace
     *         outputFile: my-namespace-json
     * outputs:
     *   output: ${myNamespaces.namespaces}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRegistryEnterpriseNamespaces.
     * @return A collection of values returned by getRegistryEnterpriseNamespaces.
     */
    public suspend fun getRegistryEnterpriseNamespaces(argument: GetRegistryEnterpriseNamespacesPlainArgs): GetRegistryEnterpriseNamespacesResult =
        getRegistryEnterpriseNamespacesResultToKotlin(getRegistryEnterpriseNamespacesPlain(argument.toJava()).await())

    /**
     * @see [getRegistryEnterpriseNamespaces].
     * @param ids A list of ids to filter results by namespace id. Each item formats as `<instance_id>:<namespace_name>`.
     * @param instanceId ID of Container Registry Enterprise Edition instance.
     * @param nameRegex A regex string to filter results by namespace name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getRegistryEnterpriseNamespaces.
     */
    public suspend fun getRegistryEnterpriseNamespaces(
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetRegistryEnterpriseNamespacesResult {
        val argument = GetRegistryEnterpriseNamespacesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getRegistryEnterpriseNamespacesResultToKotlin(getRegistryEnterpriseNamespacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryEnterpriseNamespaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetRegistryEnterpriseNamespacesPlainArgs].
     * @return A collection of values returned by getRegistryEnterpriseNamespaces.
     */
    public suspend fun getRegistryEnterpriseNamespaces(argument: suspend GetRegistryEnterpriseNamespacesPlainArgsBuilder.() -> Unit): GetRegistryEnterpriseNamespacesResult {
        val builder = GetRegistryEnterpriseNamespacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryEnterpriseNamespacesResultToKotlin(getRegistryEnterpriseNamespacesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list Container Registry Enterprise Edition repositories on Alibaba Cloud.
     * > **NOTE:** Available in v1.87.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const myRepos = alicloud.cs.getRegistryEnterpriseRepos({
     *     instanceId: "cri-xx",
     *     nameRegex: "my-repos",
     *     outputFile: "my-repo-json",
     * });
     * export const output = myRepos.then(myRepos => myRepos.repos);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * my_repos = alicloud.cs.get_registry_enterprise_repos(instance_id="cri-xx",
     *     name_regex="my-repos",
     *     output_file="my-repo-json")
     * pulumi.export("output", my_repos.repos)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var myRepos = AliCloud.CS.GetRegistryEnterpriseRepos.Invoke(new()
     *     {
     *         InstanceId = "cri-xx",
     *         NameRegex = "my-repos",
     *         OutputFile = "my-repo-json",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["output"] = myRepos.Apply(getRegistryEnterpriseReposResult => getRegistryEnterpriseReposResult.Repos),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		myRepos, err := cs.GetRegistryEnterpriseRepos(ctx, &cs.GetRegistryEnterpriseReposArgs{
     * 			InstanceId: "cri-xx",
     * 			NameRegex:  pulumi.StringRef("my-repos"),
     * 			OutputFile: pulumi.StringRef("my-repo-json"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("output", myRepos.Repos)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseReposArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var myRepos = CsFunctions.getRegistryEnterpriseRepos(GetRegistryEnterpriseReposArgs.builder()
     *             .instanceId("cri-xx")
     *             .nameRegex("my-repos")
     *             .outputFile("my-repo-json")
     *             .build());
     *         ctx.export("output", myRepos.applyValue(getRegistryEnterpriseReposResult -> getRegistryEnterpriseReposResult.repos()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   myRepos:
     *     fn::invoke:
     *       Function: alicloud:cs:getRegistryEnterpriseRepos
     *       Arguments:
     *         instanceId: cri-xx
     *         nameRegex: my-repos
     *         outputFile: my-repo-json
     * outputs:
     *   output: ${myRepos.repos}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRegistryEnterpriseRepos.
     * @return A collection of values returned by getRegistryEnterpriseRepos.
     */
    public suspend fun getRegistryEnterpriseRepos(argument: GetRegistryEnterpriseReposPlainArgs): GetRegistryEnterpriseReposResult =
        getRegistryEnterpriseReposResultToKotlin(getRegistryEnterpriseReposPlain(argument.toJava()).await())

    /**
     * @see [getRegistryEnterpriseRepos].
     * @param enableDetails Boolean, false by default, only repository attributes are exported. Set to true if tags belong to this repository are needed. See `tags` in attributes.
     * @param ids A list of ids to filter results by repository id.
     * @param instanceId ID of Container Registry Enterprise Edition instance.
     * @param nameRegex A regex string to filter results by repository name.
     * @param namespace Name of Container Registry Enterprise Edition namespace where the repositories are located in.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getRegistryEnterpriseRepos.
     */
    public suspend fun getRegistryEnterpriseRepos(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        namespace: String? = null,
        outputFile: String? = null,
    ): GetRegistryEnterpriseReposResult {
        val argument = GetRegistryEnterpriseReposPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            namespace = namespace,
            outputFile = outputFile,
        )
        return getRegistryEnterpriseReposResultToKotlin(getRegistryEnterpriseReposPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryEnterpriseRepos].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetRegistryEnterpriseReposPlainArgs].
     * @return A collection of values returned by getRegistryEnterpriseRepos.
     */
    public suspend fun getRegistryEnterpriseRepos(argument: suspend GetRegistryEnterpriseReposPlainArgsBuilder.() -> Unit): GetRegistryEnterpriseReposResult {
        val builder = GetRegistryEnterpriseReposPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryEnterpriseReposResultToKotlin(getRegistryEnterpriseReposPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list Container Registry Enterprise Edition sync rules on Alibaba Cloud.
     * > **NOTE:** Available in v1.90.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const mySyncRules = alicloud.cs.getRegistryEnterpriseSyncRules({
     *     instanceId: "cri-xxx",
     *     namespaceName: "test-namespace",
     *     repoName: "test-repo",
     *     targetInstanceId: "cri-yyy",
     *     nameRegex: "test-rule",
     * });
     * export const output = mySyncRules.then(mySyncRules => mySyncRules.rules.map(__item => __item.id));
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * my_sync_rules = alicloud.cs.get_registry_enterprise_sync_rules(instance_id="cri-xxx",
     *     namespace_name="test-namespace",
     *     repo_name="test-repo",
     *     target_instance_id="cri-yyy",
     *     name_regex="test-rule")
     * pulumi.export("output", [__item&#46;id for __item in my_sync_rules&#46;rules])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var mySyncRules = AliCloud.CS.GetRegistryEnterpriseSyncRules.Invoke(new()
     *     {
     *         InstanceId = "cri-xxx",
     *         NamespaceName = "test-namespace",
     *         RepoName = "test-repo",
     *         TargetInstanceId = "cri-yyy",
     *         NameRegex = "test-rule",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["output"] = mySyncRules.Apply(getRegistryEnterpriseSyncRulesResult => getRegistryEnterpriseSyncRulesResult.Rules).Select(__item => __item.Id).ToList(),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * // Declare the data source
     * mySyncRules, err := cs.GetRegistryEnterpriseSyncRules(ctx, &cs.GetRegistryEnterpriseSyncRulesArgs{
     * InstanceId: "cri-xxx",
     * NamespaceName: pulumi.StringRef("test-namespace"),
     * RepoName: pulumi.StringRef("test-repo"),
     * TargetInstanceId: pulumi.StringRef("cri-yyy"),
     * NameRegex: pulumi.StringRef("test-rule"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("output", pulumi.StringArray(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:10,11-34)))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetRegistryEnterpriseSyncRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var mySyncRules = CsFunctions.getRegistryEnterpriseSyncRules(GetRegistryEnterpriseSyncRulesArgs.builder()
     *             .instanceId("cri-xxx")
     *             .namespaceName("test-namespace")
     *             .repoName("test-repo")
     *             .targetInstanceId("cri-yyy")
     *             .nameRegex("test-rule")
     *             .build());
     *         ctx.export("output", mySyncRules.applyValue(getRegistryEnterpriseSyncRulesResult -> getRegistryEnterpriseSyncRulesResult.rules()).stream().map(element -> element.id()).collect(toList()));
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRegistryEnterpriseSyncRules.
     * @return A collection of values returned by getRegistryEnterpriseSyncRules.
     */
    public suspend fun getRegistryEnterpriseSyncRules(argument: GetRegistryEnterpriseSyncRulesPlainArgs): GetRegistryEnterpriseSyncRulesResult =
        getRegistryEnterpriseSyncRulesResultToKotlin(getRegistryEnterpriseSyncRulesPlain(argument.toJava()).await())

    /**
     * @see [getRegistryEnterpriseSyncRules].
     * @param ids A list of ids to filter results by sync rule id.
     * @param instanceId ID of Container Registry Enterprise Edition local instance.
     * @param nameRegex A regex string to filter results by sync rule name.
     * @param namespaceName Name of Container Registry Enterprise Edition local namespace.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param repoName Name of Container Registry Enterprise Edition local repo.
     * @param targetInstanceId ID of Container Registry Enterprise Edition target instance.
     * @return A collection of values returned by getRegistryEnterpriseSyncRules.
     */
    public suspend fun getRegistryEnterpriseSyncRules(
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        namespaceName: String? = null,
        outputFile: String? = null,
        repoName: String? = null,
        targetInstanceId: String? = null,
    ): GetRegistryEnterpriseSyncRulesResult {
        val argument = GetRegistryEnterpriseSyncRulesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            namespaceName = namespaceName,
            outputFile = outputFile,
            repoName = repoName,
            targetInstanceId = targetInstanceId,
        )
        return getRegistryEnterpriseSyncRulesResultToKotlin(getRegistryEnterpriseSyncRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryEnterpriseSyncRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetRegistryEnterpriseSyncRulesPlainArgs].
     * @return A collection of values returned by getRegistryEnterpriseSyncRules.
     */
    public suspend fun getRegistryEnterpriseSyncRules(argument: suspend GetRegistryEnterpriseSyncRulesPlainArgsBuilder.() -> Unit): GetRegistryEnterpriseSyncRulesResult {
        val builder = GetRegistryEnterpriseSyncRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryEnterpriseSyncRulesResultToKotlin(getRegistryEnterpriseSyncRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list Container Service Serverless Kubernetes Clusters on Alibaba Cloud.
     * > **NOTE:** Available in 1.58.0+
     * > **NOTE:** From version 1.177.0+, We supported batch export of clusters' kube config information by `kube_config_file_prefix`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const k8sClusters = alicloud.cs.getServerlessKubernetesClusters({
     *     nameRegex: "my-first-k8s",
     *     outputFile: "my-first-k8s-json",
     *     kubeConfigFilePrefix: "~/.kube/serverless",
     * });
     * export const output = k8sClusters.then(k8sClusters => k8sClusters.clusters);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * k8s_clusters = alicloud.cs.get_serverless_kubernetes_clusters(name_regex="my-first-k8s",
     *     output_file="my-first-k8s-json",
     *     kube_config_file_prefix="~/.kube/serverless")
     * pulumi.export("output", k8s_clusters.clusters)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var k8sClusters = AliCloud.CS.GetServerlessKubernetesClusters.Invoke(new()
     *     {
     *         NameRegex = "my-first-k8s",
     *         OutputFile = "my-first-k8s-json",
     *         KubeConfigFilePrefix = "~/.kube/serverless",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["output"] = k8sClusters.Apply(getServerlessKubernetesClustersResult => getServerlessKubernetesClustersResult.Clusters),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		k8sClusters, err := cs.GetServerlessKubernetesClusters(ctx, &cs.GetServerlessKubernetesClustersArgs{
     * 			NameRegex:            pulumi.StringRef("my-first-k8s"),
     * 			OutputFile:           pulumi.StringRef("my-first-k8s-json"),
     * 			KubeConfigFilePrefix: pulumi.StringRef("~/.kube/serverless"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("output", k8sClusters.Clusters)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cs.CsFunctions;
     * import com.pulumi.alicloud.cs.inputs.GetServerlessKubernetesClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var k8sClusters = CsFunctions.getServerlessKubernetesClusters(GetServerlessKubernetesClustersArgs.builder()
     *             .nameRegex("my-first-k8s")
     *             .outputFile("my-first-k8s-json")
     *             .kubeConfigFilePrefix("~/.kube/serverless")
     *             .build());
     *         ctx.export("output", k8sClusters.applyValue(getServerlessKubernetesClustersResult -> getServerlessKubernetesClustersResult.clusters()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   k8sClusters:
     *     fn::invoke:
     *       Function: alicloud:cs:getServerlessKubernetesClusters
     *       Arguments:
     *         nameRegex: my-first-k8s
     *         outputFile: my-first-k8s-json
     *         kubeConfigFilePrefix: ~/.kube/serverless
     * outputs:
     *   output: ${k8sClusters.clusters}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerlessKubernetesClusters.
     * @return A collection of values returned by getServerlessKubernetesClusters.
     */
    public suspend fun getServerlessKubernetesClusters(argument: GetServerlessKubernetesClustersPlainArgs): GetServerlessKubernetesClustersResult =
        getServerlessKubernetesClustersResultToKotlin(getServerlessKubernetesClustersPlain(argument.toJava()).await())

    /**
     * @see [getServerlessKubernetesClusters].
     * @param enableDetails
     * @param ids Cluster IDs to filter.
     * @param kubeConfigFilePrefix The path prefix of kube config. You could store kube config in a specified directory by specifying this field, like `~/.kube/serverless`, then it will be named with `~/.kube/serverless-clusterID-kubeconfig`. From version 1.187.0+, kube_config will not export kube_config if this field is not set.
     * @param nameRegex A regex string to filter results by cluster name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getServerlessKubernetesClusters.
     */
    public suspend fun getServerlessKubernetesClusters(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        kubeConfigFilePrefix: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetServerlessKubernetesClustersResult {
        val argument = GetServerlessKubernetesClustersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            kubeConfigFilePrefix = kubeConfigFilePrefix,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getServerlessKubernetesClustersResultToKotlin(getServerlessKubernetesClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerlessKubernetesClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cs&#46;kotlin&#46;inputs&#46;GetServerlessKubernetesClustersPlainArgs].
     * @return A collection of values returned by getServerlessKubernetesClusters.
     */
    public suspend fun getServerlessKubernetesClusters(argument: suspend GetServerlessKubernetesClustersPlainArgsBuilder.() -> Unit): GetServerlessKubernetesClustersResult {
        val builder = GetServerlessKubernetesClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerlessKubernetesClustersResultToKotlin(getServerlessKubernetesClustersPlain(builtArgument.toJava()).await())
    }
}
