@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesAddon
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesCertificateAuthority
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesConnections
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesLogConfig
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesRuntime
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesWorkerDataDisk
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesWorkerNode
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesAddon.Companion.toKotlin as edgeKubernetesAddonToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesCertificateAuthority.Companion.toKotlin as edgeKubernetesCertificateAuthorityToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesConnections.Companion.toKotlin as edgeKubernetesConnectionsToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesLogConfig.Companion.toKotlin as edgeKubernetesLogConfigToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesRuntime.Companion.toKotlin as edgeKubernetesRuntimeToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesWorkerDataDisk.Companion.toKotlin as edgeKubernetesWorkerDataDiskToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.EdgeKubernetesWorkerNode.Companion.toKotlin as edgeKubernetesWorkerNodeToKotlin

/**
 * Builder for [EdgeKubernetes].
 */
@PulumiTagMarker
public class EdgeKubernetesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EdgeKubernetesArgs = EdgeKubernetesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EdgeKubernetesArgsBuilder.() -> Unit) {
        val builder = EdgeKubernetesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EdgeKubernetes {
        val builtJavaResource = com.pulumi.alicloud.cs.EdgeKubernetes(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EdgeKubernetes(builtJavaResource)
    }
}

/**
 * This resource will help you to manage a Edge Kubernetes Cluster in Alibaba Cloud Kubernetes Service, see [What is edge kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-an-ack-edge-cluster).
 * > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
 * A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
 * VPC, you can set `new_nat_gateway` to "true" to create one automatically.
 * > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.
 * > **NOTE:** The provider supports to download kube config, client certificate, client key and cluster ca certificate
 * after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.
 * > **NOTE:** The provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.
 * > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.
 * > **NOTE:** Available since v1.103.0.
 * > **NOTE:** From version 1.185.0+, support new fields `cluster_spec`, `runtime` and `load_balancer_spec`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 4,
 *     memorySize: 8,
 *     kubernetesNodeRole: "Master",
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultEdgeKubernetes = new alicloud.cs.EdgeKubernetes("default", {
 *     namePrefix: name,
 *     workerVswitchIds: [defaultSwitch&#46;id],
 *     workerInstanceTypes: [defaultGetInstanceTypes&#46;then(defaultGetInstanceTypes => defaultGetInstanceTypes&#46;instanceTypes?&#46;[0]?&#46;id)],
 *     version: "1.26.3-aliyun.1",
 *     workerNumber: 1,
 *     password: "Test12345",
 *     podCidr: "10.99.0.0/16",
 *     serviceCidr: "172.16.0.0/16",
 *     workerInstanceChargeType: "PostPaid",
 *     newNatGateway: true,
 *     nodeCidrMask: 24,
 *     installCloudMonitor: true,
 *     slbInternetEnabled: true,
 *     isEnterpriseSecurityGroup: true,
 *     workerDataDisks: [{
 *         category: "cloud_ssd",
 *         size: "200",
 *         encrypted: "false",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=4,
 *     memory_size=8,
 *     kubernetes_node_role="Master")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_edge_kubernetes = alicloud.cs.EdgeKubernetes("default",
 *     name_prefix=name,
 *     worker_vswitch_ids=[default_switch&#46;id],
 *     worker_instance_types=[default_get_instance_types&#46;instance_types[0]&#46;id],
 *     version="1.26.3-aliyun.1",
 *     worker_number=1,
 *     password="Test12345",
 *     pod_cidr="10.99.0.0/16",
 *     service_cidr="172.16.0.0/16",
 *     worker_instance_charge_type="PostPaid",
 *     new_nat_gateway=True,
 *     node_cidr_mask=24,
 *     install_cloud_monitor=True,
 *     slb_internet_enabled=True,
 *     is_enterprise_security_group=True,
 *     worker_data_disks=[{
 *         "category": "cloud_ssd",
 *         "size": "200",
 *         "encrypted": "false",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 4,
 *         MemorySize = 8,
 *         KubernetesNodeRole = "Master",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultEdgeKubernetes = new AliCloud.CS.EdgeKubernetes("default", new()
 *     {
 *         NamePrefix = name,
 *         WorkerVswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *         WorkerInstanceTypes = new[]
 *         {
 *             defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         },
 *         Version = "1.26.3-aliyun.1",
 *         WorkerNumber = 1,
 *         Password = "Test12345",
 *         PodCidr = "10.99.0.0/16",
 *         ServiceCidr = "172.16.0.0/16",
 *         WorkerInstanceChargeType = "PostPaid",
 *         NewNatGateway = true,
 *         NodeCidrMask = 24,
 *         InstallCloudMonitor = true,
 *         SlbInternetEnabled = true,
 *         IsEnterpriseSecurityGroup = true,
 *         WorkerDataDisks = new[]
 *         {
 *             new AliCloud.CS.Inputs.EdgeKubernetesWorkerDataDiskArgs
 *             {
 *                 Category = "cloud_ssd",
 *                 Size = "200",
 *                 Encrypted = "false",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone:   pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:       pulumi.IntRef(4),
 * 			MemorySize:         pulumi.Float64Ref(8),
 * 			KubernetesNodeRole: pulumi.StringRef("Master"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewEdgeKubernetes(ctx, "default", &cs.EdgeKubernetesArgs{
 * 			NamePrefix: pulumi.String(name),
 * 			WorkerVswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 			WorkerInstanceTypes: pulumi.StringArray{
 * 				pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			},
 * 			Version:                   pulumi.String("1.26.3-aliyun.1"),
 * 			WorkerNumber:              pulumi.Int(1),
 * 			Password:                  pulumi.String("Test12345"),
 * 			PodCidr:                   pulumi.String("10.99.0.0/16"),
 * 			ServiceCidr:               pulumi.String("172.16.0.0/16"),
 * 			WorkerInstanceChargeType:  pulumi.String("PostPaid"),
 * 			NewNatGateway:             pulumi.Bool(true),
 * 			NodeCidrMask:              pulumi.Int(24),
 * 			InstallCloudMonitor:       pulumi.Bool(true),
 * 			SlbInternetEnabled:        pulumi.Bool(true),
 * 			IsEnterpriseSecurityGroup: pulumi.Bool(true),
 * 			WorkerDataDisks: cs.EdgeKubernetesWorkerDataDiskArray{
 * 				&cs.EdgeKubernetesWorkerDataDiskArgs{
 * 					Category:  pulumi.String("cloud_ssd"),
 * 					Size:      pulumi.String("200"),
 * 					Encrypted: pulumi.String("false"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.cs.EdgeKubernetes;
 * import com.pulumi.alicloud.cs.EdgeKubernetesArgs;
 * import com.pulumi.alicloud.cs.inputs.EdgeKubernetesWorkerDataDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(4)
 *             .memorySize(8)
 *             .kubernetesNodeRole("Master")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultEdgeKubernetes = new EdgeKubernetes("defaultEdgeKubernetes", EdgeKubernetesArgs.builder()
 *             .namePrefix(name)
 *             .workerVswitchIds(defaultSwitch.id())
 *             .workerInstanceTypes(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .version("1.26.3-aliyun.1")
 *             .workerNumber("1")
 *             .password("Test12345")
 *             .podCidr("10.99.0.0/16")
 *             .serviceCidr("172.16.0.0/16")
 *             .workerInstanceChargeType("PostPaid")
 *             .newNatGateway("true")
 *             .nodeCidrMask("24")
 *             .installCloudMonitor("true")
 *             .slbInternetEnabled("true")
 *             .isEnterpriseSecurityGroup("true")
 *             .workerDataDisks(EdgeKubernetesWorkerDataDiskArgs.builder()
 *                 .category("cloud_ssd")
 *                 .size("200")
 *                 .encrypted("false")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultEdgeKubernetes:
 *     type: alicloud:cs:EdgeKubernetes
 *     name: default
 *     properties:
 *       namePrefix: ${name}
 *       workerVswitchIds:
 *         - ${defaultSwitch.id}
 *       workerInstanceTypes:
 *         - ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       version: 1.26.3-aliyun.1
 *       workerNumber: '1'
 *       password: Test12345
 *       podCidr: 10.99.0.0/16
 *       serviceCidr: 172.16.0.0/16
 *       workerInstanceChargeType: PostPaid
 *       newNatGateway: 'true'
 *       nodeCidrMask: '24'
 *       installCloudMonitor: 'true'
 *       slbInternetEnabled: 'true'
 *       isEnterpriseSecurityGroup: 'true'
 *       workerDataDisks:
 *         - category: cloud_ssd
 *           size: '200'
 *           encrypted: 'false'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 4
 *         memorySize: 8
 *         kubernetesNodeRole: Master
 * ```
 * <!--End PulumiCodeChooser -->
 * You could create a professional kubernetes edge cluster now.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 4,
 *     memorySize: 8,
 *     kubernetesNodeRole: "Master",
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultEdgeKubernetes = new alicloud.cs.EdgeKubernetes("default", {
 *     namePrefix: name,
 *     workerVswitchIds: [defaultSwitch&#46;id],
 *     workerInstanceTypes: [defaultGetInstanceTypes&#46;then(defaultGetInstanceTypes => defaultGetInstanceTypes&#46;instanceTypes?&#46;[0]?&#46;id)],
 *     clusterSpec: "ack.pro.small",
 *     workerNumber: 1,
 *     password: "Test12345",
 *     podCidr: "10.99.0.0/16",
 *     serviceCidr: "172.16.0.0/16",
 *     workerInstanceChargeType: "PostPaid",
 *     newNatGateway: true,
 *     nodeCidrMask: 24,
 *     loadBalancerSpec: "slb.s2.small",
 *     installCloudMonitor: true,
 *     slbInternetEnabled: true,
 *     isEnterpriseSecurityGroup: true,
 *     workerDataDisks: [{
 *         category: "cloud_ssd",
 *         size: "200",
 *         encrypted: "false",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=4,
 *     memory_size=8,
 *     kubernetes_node_role="Master")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_edge_kubernetes = alicloud.cs.EdgeKubernetes("default",
 *     name_prefix=name,
 *     worker_vswitch_ids=[default_switch&#46;id],
 *     worker_instance_types=[default_get_instance_types&#46;instance_types[0]&#46;id],
 *     cluster_spec="ack.pro.small",
 *     worker_number=1,
 *     password="Test12345",
 *     pod_cidr="10.99.0.0/16",
 *     service_cidr="172.16.0.0/16",
 *     worker_instance_charge_type="PostPaid",
 *     new_nat_gateway=True,
 *     node_cidr_mask=24,
 *     load_balancer_spec="slb.s2.small",
 *     install_cloud_monitor=True,
 *     slb_internet_enabled=True,
 *     is_enterprise_security_group=True,
 *     worker_data_disks=[{
 *         "category": "cloud_ssd",
 *         "size": "200",
 *         "encrypted": "false",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 4,
 *         MemorySize = 8,
 *         KubernetesNodeRole = "Master",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultEdgeKubernetes = new AliCloud.CS.EdgeKubernetes("default", new()
 *     {
 *         NamePrefix = name,
 *         WorkerVswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *         WorkerInstanceTypes = new[]
 *         {
 *             defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         },
 *         ClusterSpec = "ack.pro.small",
 *         WorkerNumber = 1,
 *         Password = "Test12345",
 *         PodCidr = "10.99.0.0/16",
 *         ServiceCidr = "172.16.0.0/16",
 *         WorkerInstanceChargeType = "PostPaid",
 *         NewNatGateway = true,
 *         NodeCidrMask = 24,
 *         LoadBalancerSpec = "slb.s2.small",
 *         InstallCloudMonitor = true,
 *         SlbInternetEnabled = true,
 *         IsEnterpriseSecurityGroup = true,
 *         WorkerDataDisks = new[]
 *         {
 *             new AliCloud.CS.Inputs.EdgeKubernetesWorkerDataDiskArgs
 *             {
 *                 Category = "cloud_ssd",
 *                 Size = "200",
 *                 Encrypted = "false",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone:   pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:       pulumi.IntRef(4),
 * 			MemorySize:         pulumi.Float64Ref(8),
 * 			KubernetesNodeRole: pulumi.StringRef("Master"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewEdgeKubernetes(ctx, "default", &cs.EdgeKubernetesArgs{
 * 			NamePrefix: pulumi.String(name),
 * 			WorkerVswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 			WorkerInstanceTypes: pulumi.StringArray{
 * 				pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			},
 * 			ClusterSpec:               pulumi.String("ack.pro.small"),
 * 			WorkerNumber:              pulumi.Int(1),
 * 			Password:                  pulumi.String("Test12345"),
 * 			PodCidr:                   pulumi.String("10.99.0.0/16"),
 * 			ServiceCidr:               pulumi.String("172.16.0.0/16"),
 * 			WorkerInstanceChargeType:  pulumi.String("PostPaid"),
 * 			NewNatGateway:             pulumi.Bool(true),
 * 			NodeCidrMask:              pulumi.Int(24),
 * 			LoadBalancerSpec:          pulumi.String("slb.s2.small"),
 * 			InstallCloudMonitor:       pulumi.Bool(true),
 * 			SlbInternetEnabled:        pulumi.Bool(true),
 * 			IsEnterpriseSecurityGroup: pulumi.Bool(true),
 * 			WorkerDataDisks: cs.EdgeKubernetesWorkerDataDiskArray{
 * 				&cs.EdgeKubernetesWorkerDataDiskArgs{
 * 					Category:  pulumi.String("cloud_ssd"),
 * 					Size:      pulumi.String("200"),
 * 					Encrypted: pulumi.String("false"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.cs.EdgeKubernetes;
 * import com.pulumi.alicloud.cs.EdgeKubernetesArgs;
 * import com.pulumi.alicloud.cs.inputs.EdgeKubernetesWorkerDataDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(4)
 *             .memorySize(8)
 *             .kubernetesNodeRole("Master")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultEdgeKubernetes = new EdgeKubernetes("defaultEdgeKubernetes", EdgeKubernetesArgs.builder()
 *             .namePrefix(name)
 *             .workerVswitchIds(defaultSwitch.id())
 *             .workerInstanceTypes(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .clusterSpec("ack.pro.small")
 *             .workerNumber("1")
 *             .password("Test12345")
 *             .podCidr("10.99.0.0/16")
 *             .serviceCidr("172.16.0.0/16")
 *             .workerInstanceChargeType("PostPaid")
 *             .newNatGateway("true")
 *             .nodeCidrMask("24")
 *             .loadBalancerSpec("slb.s2.small")
 *             .installCloudMonitor("true")
 *             .slbInternetEnabled("true")
 *             .isEnterpriseSecurityGroup("true")
 *             .workerDataDisks(EdgeKubernetesWorkerDataDiskArgs.builder()
 *                 .category("cloud_ssd")
 *                 .size("200")
 *                 .encrypted("false")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultEdgeKubernetes:
 *     type: alicloud:cs:EdgeKubernetes
 *     name: default
 *     properties:
 *       namePrefix: ${name}
 *       workerVswitchIds:
 *         - ${defaultSwitch.id}
 *       workerInstanceTypes:
 *         - ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       clusterSpec: ack.pro.small
 *       workerNumber: '1'
 *       password: Test12345
 *       podCidr: 10.99.0.0/16
 *       serviceCidr: 172.16.0.0/16
 *       workerInstanceChargeType: PostPaid
 *       newNatGateway: 'true'
 *       nodeCidrMask: '24'
 *       loadBalancerSpec: slb.s2.small
 *       installCloudMonitor: 'true'
 *       slbInternetEnabled: 'true'
 *       isEnterpriseSecurityGroup: 'true'
 *       workerDataDisks:
 *         - category: cloud_ssd
 *           size: '200'
 *           encrypted: 'false'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 4
 *         memorySize: 8
 *         kubernetesNodeRole: Master
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Kubernetes edge cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.
 * ```sh
 * $ pulumi import alicloud:cs/edgeKubernetes:EdgeKubernetes main cluster-id
 * ```
 */
public class EdgeKubernetes internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.EdgeKubernetes,
) : KotlinCustomResource(javaResource, EdgeKubernetesMapper) {
    /**
     * The addon you want to install in cluster. See `addons` below.
     */
    public val addons: Output<List<EdgeKubernetesAddon>>?
        get() = javaResource.addons().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> edgeKubernetesAddonToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The ID of availability zone.
     * *Network params*
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * (Map, Available since v1.105.0) Nested attribute containing certificate authority data for your cluster.
     */
    public val certificateAuthority: Output<EdgeKubernetesCertificateAuthority>
        get() = javaResource.certificateAuthority().applyValue({ args0 ->
            args0.let({ args0 ->
                edgeKubernetesCertificateAuthorityToKotlin(args0)
            })
        })

    /**
     * The path of client certificate, like `~/.kube/client-cert.pem`.
     */
    public val clientCert: Output<String>?
        get() = javaResource.clientCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path of client key, like `~/.kube/client-key.pem`.
     */
    public val clientKey: Output<String>?
        get() = javaResource.clientKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
     * *Removed params*
     */
    public val clusterCaCert: Output<String>?
        get() = javaResource.clusterCaCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The cluster specifications of kubernetes cluster,which can be empty. Valid values:
     * * ack.standard : Standard edge clusters.
     * * ack.pro.small : Professional edge clusters.
     */
    public val clusterSpec: Output<String>
        get() = javaResource.clusterSpec().applyValue({ args0 -> args0 })

    /**
     * (Map) Map of kubernetes cluster connection information.
     */
    public val connections: Output<EdgeKubernetesConnections>
        get() = javaResource.connections().applyValue({ args0 ->
            args0.let({ args0 ->
                edgeKubernetesConnectionsToKotlin(args0)
            })
        })

    /**
     * Whether to enable cluster deletion protection.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
     */
    public val forceUpdate: Output<Boolean>?
        get() = javaResource.forceUpdate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Install cloud monitor agent on ECS. default: `true`.
     */
    public val installCloudMonitor: Output<Boolean>?
        get() = javaResource.installCloudMonitor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
     */
    public val isEnterpriseSecurityGroup: Output<Boolean>
        get() = javaResource.isEnterpriseSecurityGroup().applyValue({ args0 -> args0 })

    /**
     * The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    public val keyName: Output<String>?
        get() = javaResource.keyName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The path of kube config, like `~/.kube/config`.
     */
    @Deprecated(
        message = """
  Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource
      'alicloud_cs_cluster_credential' manage your cluster's kube config.
  """,
    )
    public val kubeConfig: Output<String>?
        get() = javaResource.kubeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
     * ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
     * *Worker params*
     */
    public val loadBalancerSpec: Output<String>
        get() = javaResource.loadBalancerSpec().applyValue({ args0 -> args0 })

    /**
     * A list of one element containing information about the associated log store. See `log_config` below.
     */
    @Deprecated(
        message = """
  Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.
  """,
    )
    public val logConfig: Output<EdgeKubernetesLogConfig>?
        get() = javaResource.logConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    edgeKubernetesLogConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kubernetes cluster's name. It is unique in one Alicloud account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val namePrefix: Output<String>?
        get() = javaResource.namePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of nat gateway used to launch kubernetes cluster.
     */
    public val natGatewayId: Output<String>
        get() = javaResource.natGatewayId().applyValue({ args0 -> args0 })

    /**
     * Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
     */
    public val newNatGateway: Output<Boolean>?
        get() = javaResource.newNatGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
     */
    public val nodeCidrMask: Output<Int>?
        get() = javaResource.nodeCidrMask().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * [Flannel Specific] The CIDR block for the pod network when using Flannel.
     */
    public val podCidr: Output<String>?
        get() = javaResource.podCidr().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
     */
    public val proxyMode: Output<String>?
        get() = javaResource.proxyMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * RDS instance list, You can choose which RDS instances whitelist to add instances to.
     */
    public val rdsInstances: Output<List<String>>?
        get() = javaResource.rdsInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    public val retainResources: Output<List<String>>?
        get() = javaResource.retainResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
     */
    public val runtime: Output<EdgeKubernetesRuntime>?
        get() = javaResource.runtime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    edgeKubernetesRuntimeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
     */
    public val serviceCidr: Output<String>?
        get() = javaResource.serviceCidr().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The public ip of load balancer.
     */
    public val slbInternet: Output<String>
        get() = javaResource.slbInternet().applyValue({ args0 -> args0 })

    /**
     * Whether to create internet load balancer for API Server. Default to true.
     */
    public val slbInternetEnabled: Output<Boolean>?
        get() = javaResource.slbInternetEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of private load balancer where the current cluster master node is located.
     */
    public val slbIntranet: Output<String>
        get() = javaResource.slbIntranet().applyValue({ args0 -> args0 })

    /**
     * Default nil, A map of tags assigned to the kubernetes cluster and work node.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * The ID of VPC where the current cluster is located.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
     */
    public val workerDataDisks: Output<List<EdgeKubernetesWorkerDataDisk>>?
        get() = javaResource.workerDataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        edgeKubernetesWorkerDataDiskToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
     */
    public val workerDiskCategory: Output<String>?
        get() = javaResource.workerDiskCategory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
     */
    public val workerDiskPerformanceLevel: Output<String>?
        get() = javaResource.workerDiskPerformanceLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
     */
    public val workerDiskSize: Output<Int>?
        get() = javaResource.workerDiskSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Worker node system disk auto snapshot policy.
     * *Computed params*
     * You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `alicloud.cs.getClusterCredential` is recommended to manage cluster's kube_config.
     */
    public val workerDiskSnapshotPolicyId: Output<String>?
        get() = javaResource.workerDiskSnapshotPolicyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
     */
    public val workerInstanceChargeType: Output<String>?
        get() = javaResource.workerInstanceChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
     */
    public val workerInstanceTypes: Output<List<String>>
        get() = javaResource.workerInstanceTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of cluster worker nodes.
     */
    public val workerNodes: Output<List<EdgeKubernetesWorkerNode>>
        get() = javaResource.workerNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    edgeKubernetesWorkerNodeToKotlin(args0)
                })
            })
        })

    /**
     * The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
     */
    public val workerNumber: Output<Int>
        get() = javaResource.workerNumber().applyValue({ args0 -> args0 })

    /**
     * The RamRole Name attached to worker node.
     */
    public val workerRamRoleName: Output<String>
        get() = javaResource.workerRamRoleName().applyValue({ args0 -> args0 })

    /**
     * The vswitches used by workers.
     */
    public val workerVswitchIds: Output<List<String>>
        get() = javaResource.workerVswitchIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object EdgeKubernetesMapper : ResourceMapper<EdgeKubernetes> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.EdgeKubernetes::class == javaResource::class

    override fun map(javaResource: Resource): EdgeKubernetes = EdgeKubernetes(
        javaResource as
            com.pulumi.alicloud.cs.EdgeKubernetes,
    )
}

/**
 * @see [EdgeKubernetes].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EdgeKubernetes].
 */
public suspend fun edgeKubernetes(
    name: String,
    block: suspend EdgeKubernetesResourceBuilder.() -> Unit,
): EdgeKubernetes {
    val builder = EdgeKubernetesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EdgeKubernetes].
 * @param name The _unique_ name of the resulting resource.
 */
public fun edgeKubernetes(name: String): EdgeKubernetes {
    val builder = EdgeKubernetesResourceBuilder()
    builder.name(name)
    return builder.build()
}
