@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.EdgeKubernetesArgs.builder
import com.pulumi.alicloud.cs.kotlin.inputs.EdgeKubernetesAddonArgs
import com.pulumi.alicloud.cs.kotlin.inputs.EdgeKubernetesAddonArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.EdgeKubernetesLogConfigArgs
import com.pulumi.alicloud.cs.kotlin.inputs.EdgeKubernetesLogConfigArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.EdgeKubernetesRuntimeArgs
import com.pulumi.alicloud.cs.kotlin.inputs.EdgeKubernetesRuntimeArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.EdgeKubernetesWorkerDataDiskArgs
import com.pulumi.alicloud.cs.kotlin.inputs.EdgeKubernetesWorkerDataDiskArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This resource will help you to manage a Edge Kubernetes Cluster in Alibaba Cloud Kubernetes Service, see [What is edge kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-an-ack-edge-cluster).
 * > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
 * A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
 * VPC, you can set `new_nat_gateway` to "true" to create one automatically.
 * > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.
 * > **NOTE:** The provider supports to download kube config, client certificate, client key and cluster ca certificate
 * after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.
 * > **NOTE:** The provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.
 * > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.
 * > **NOTE:** Available since v1.103.0.
 * > **NOTE:** From version 1.185.0+, support new fields `cluster_spec`, `runtime` and `load_balancer_spec`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 4,
 *     memorySize: 8,
 *     kubernetesNodeRole: "Master",
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultEdgeKubernetes = new alicloud.cs.EdgeKubernetes("default", {
 *     namePrefix: name,
 *     workerVswitchIds: [defaultSwitch&#46;id],
 *     workerInstanceTypes: [defaultGetInstanceTypes&#46;then(defaultGetInstanceTypes => defaultGetInstanceTypes&#46;instanceTypes?&#46;[0]?&#46;id)],
 *     version: "1.26.3-aliyun.1",
 *     workerNumber: 1,
 *     password: "Test12345",
 *     podCidr: "10.99.0.0/16",
 *     serviceCidr: "172.16.0.0/16",
 *     workerInstanceChargeType: "PostPaid",
 *     newNatGateway: true,
 *     nodeCidrMask: 24,
 *     installCloudMonitor: true,
 *     slbInternetEnabled: true,
 *     isEnterpriseSecurityGroup: true,
 *     workerDataDisks: [{
 *         category: "cloud_ssd",
 *         size: "200",
 *         encrypted: "false",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=4,
 *     memory_size=8,
 *     kubernetes_node_role="Master")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_edge_kubernetes = alicloud.cs.EdgeKubernetes("default",
 *     name_prefix=name,
 *     worker_vswitch_ids=[default_switch&#46;id],
 *     worker_instance_types=[default_get_instance_types&#46;instance_types[0]&#46;id],
 *     version="1.26.3-aliyun.1",
 *     worker_number=1,
 *     password="Test12345",
 *     pod_cidr="10.99.0.0/16",
 *     service_cidr="172.16.0.0/16",
 *     worker_instance_charge_type="PostPaid",
 *     new_nat_gateway=True,
 *     node_cidr_mask=24,
 *     install_cloud_monitor=True,
 *     slb_internet_enabled=True,
 *     is_enterprise_security_group=True,
 *     worker_data_disks=[{
 *         "category": "cloud_ssd",
 *         "size": "200",
 *         "encrypted": "false",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 4,
 *         MemorySize = 8,
 *         KubernetesNodeRole = "Master",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultEdgeKubernetes = new AliCloud.CS.EdgeKubernetes("default", new()
 *     {
 *         NamePrefix = name,
 *         WorkerVswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *         WorkerInstanceTypes = new[]
 *         {
 *             defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         },
 *         Version = "1.26.3-aliyun.1",
 *         WorkerNumber = 1,
 *         Password = "Test12345",
 *         PodCidr = "10.99.0.0/16",
 *         ServiceCidr = "172.16.0.0/16",
 *         WorkerInstanceChargeType = "PostPaid",
 *         NewNatGateway = true,
 *         NodeCidrMask = 24,
 *         InstallCloudMonitor = true,
 *         SlbInternetEnabled = true,
 *         IsEnterpriseSecurityGroup = true,
 *         WorkerDataDisks = new[]
 *         {
 *             new AliCloud.CS.Inputs.EdgeKubernetesWorkerDataDiskArgs
 *             {
 *                 Category = "cloud_ssd",
 *                 Size = "200",
 *                 Encrypted = "false",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone:   pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:       pulumi.IntRef(4),
 * 			MemorySize:         pulumi.Float64Ref(8),
 * 			KubernetesNodeRole: pulumi.StringRef("Master"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewEdgeKubernetes(ctx, "default", &cs.EdgeKubernetesArgs{
 * 			NamePrefix: pulumi.String(name),
 * 			WorkerVswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 			WorkerInstanceTypes: pulumi.StringArray{
 * 				pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			},
 * 			Version:                   pulumi.String("1.26.3-aliyun.1"),
 * 			WorkerNumber:              pulumi.Int(1),
 * 			Password:                  pulumi.String("Test12345"),
 * 			PodCidr:                   pulumi.String("10.99.0.0/16"),
 * 			ServiceCidr:               pulumi.String("172.16.0.0/16"),
 * 			WorkerInstanceChargeType:  pulumi.String("PostPaid"),
 * 			NewNatGateway:             pulumi.Bool(true),
 * 			NodeCidrMask:              pulumi.Int(24),
 * 			InstallCloudMonitor:       pulumi.Bool(true),
 * 			SlbInternetEnabled:        pulumi.Bool(true),
 * 			IsEnterpriseSecurityGroup: pulumi.Bool(true),
 * 			WorkerDataDisks: cs.EdgeKubernetesWorkerDataDiskArray{
 * 				&cs.EdgeKubernetesWorkerDataDiskArgs{
 * 					Category:  pulumi.String("cloud_ssd"),
 * 					Size:      pulumi.String("200"),
 * 					Encrypted: pulumi.String("false"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.cs.EdgeKubernetes;
 * import com.pulumi.alicloud.cs.EdgeKubernetesArgs;
 * import com.pulumi.alicloud.cs.inputs.EdgeKubernetesWorkerDataDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(4)
 *             .memorySize(8)
 *             .kubernetesNodeRole("Master")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultEdgeKubernetes = new EdgeKubernetes("defaultEdgeKubernetes", EdgeKubernetesArgs.builder()
 *             .namePrefix(name)
 *             .workerVswitchIds(defaultSwitch.id())
 *             .workerInstanceTypes(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .version("1.26.3-aliyun.1")
 *             .workerNumber("1")
 *             .password("Test12345")
 *             .podCidr("10.99.0.0/16")
 *             .serviceCidr("172.16.0.0/16")
 *             .workerInstanceChargeType("PostPaid")
 *             .newNatGateway("true")
 *             .nodeCidrMask("24")
 *             .installCloudMonitor("true")
 *             .slbInternetEnabled("true")
 *             .isEnterpriseSecurityGroup("true")
 *             .workerDataDisks(EdgeKubernetesWorkerDataDiskArgs.builder()
 *                 .category("cloud_ssd")
 *                 .size("200")
 *                 .encrypted("false")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultEdgeKubernetes:
 *     type: alicloud:cs:EdgeKubernetes
 *     name: default
 *     properties:
 *       namePrefix: ${name}
 *       workerVswitchIds:
 *         - ${defaultSwitch.id}
 *       workerInstanceTypes:
 *         - ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       version: 1.26.3-aliyun.1
 *       workerNumber: '1'
 *       password: Test12345
 *       podCidr: 10.99.0.0/16
 *       serviceCidr: 172.16.0.0/16
 *       workerInstanceChargeType: PostPaid
 *       newNatGateway: 'true'
 *       nodeCidrMask: '24'
 *       installCloudMonitor: 'true'
 *       slbInternetEnabled: 'true'
 *       isEnterpriseSecurityGroup: 'true'
 *       workerDataDisks:
 *         - category: cloud_ssd
 *           size: '200'
 *           encrypted: 'false'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 4
 *         memorySize: 8
 *         kubernetesNodeRole: Master
 * ```
 * <!--End PulumiCodeChooser -->
 * You could create a professional kubernetes edge cluster now.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 4,
 *     memorySize: 8,
 *     kubernetesNodeRole: "Master",
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultEdgeKubernetes = new alicloud.cs.EdgeKubernetes("default", {
 *     namePrefix: name,
 *     workerVswitchIds: [defaultSwitch&#46;id],
 *     workerInstanceTypes: [defaultGetInstanceTypes&#46;then(defaultGetInstanceTypes => defaultGetInstanceTypes&#46;instanceTypes?&#46;[0]?&#46;id)],
 *     clusterSpec: "ack.pro.small",
 *     workerNumber: 1,
 *     password: "Test12345",
 *     podCidr: "10.99.0.0/16",
 *     serviceCidr: "172.16.0.0/16",
 *     workerInstanceChargeType: "PostPaid",
 *     newNatGateway: true,
 *     nodeCidrMask: 24,
 *     loadBalancerSpec: "slb.s2.small",
 *     installCloudMonitor: true,
 *     slbInternetEnabled: true,
 *     isEnterpriseSecurityGroup: true,
 *     workerDataDisks: [{
 *         category: "cloud_ssd",
 *         size: "200",
 *         encrypted: "false",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=4,
 *     memory_size=8,
 *     kubernetes_node_role="Master")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_edge_kubernetes = alicloud.cs.EdgeKubernetes("default",
 *     name_prefix=name,
 *     worker_vswitch_ids=[default_switch&#46;id],
 *     worker_instance_types=[default_get_instance_types&#46;instance_types[0]&#46;id],
 *     cluster_spec="ack.pro.small",
 *     worker_number=1,
 *     password="Test12345",
 *     pod_cidr="10.99.0.0/16",
 *     service_cidr="172.16.0.0/16",
 *     worker_instance_charge_type="PostPaid",
 *     new_nat_gateway=True,
 *     node_cidr_mask=24,
 *     load_balancer_spec="slb.s2.small",
 *     install_cloud_monitor=True,
 *     slb_internet_enabled=True,
 *     is_enterprise_security_group=True,
 *     worker_data_disks=[{
 *         "category": "cloud_ssd",
 *         "size": "200",
 *         "encrypted": "false",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 4,
 *         MemorySize = 8,
 *         KubernetesNodeRole = "Master",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultEdgeKubernetes = new AliCloud.CS.EdgeKubernetes("default", new()
 *     {
 *         NamePrefix = name,
 *         WorkerVswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *         WorkerInstanceTypes = new[]
 *         {
 *             defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         },
 *         ClusterSpec = "ack.pro.small",
 *         WorkerNumber = 1,
 *         Password = "Test12345",
 *         PodCidr = "10.99.0.0/16",
 *         ServiceCidr = "172.16.0.0/16",
 *         WorkerInstanceChargeType = "PostPaid",
 *         NewNatGateway = true,
 *         NodeCidrMask = 24,
 *         LoadBalancerSpec = "slb.s2.small",
 *         InstallCloudMonitor = true,
 *         SlbInternetEnabled = true,
 *         IsEnterpriseSecurityGroup = true,
 *         WorkerDataDisks = new[]
 *         {
 *             new AliCloud.CS.Inputs.EdgeKubernetesWorkerDataDiskArgs
 *             {
 *                 Category = "cloud_ssd",
 *                 Size = "200",
 *                 Encrypted = "false",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone:   pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:       pulumi.IntRef(4),
 * 			MemorySize:         pulumi.Float64Ref(8),
 * 			KubernetesNodeRole: pulumi.StringRef("Master"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cs.NewEdgeKubernetes(ctx, "default", &cs.EdgeKubernetesArgs{
 * 			NamePrefix: pulumi.String(name),
 * 			WorkerVswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 			WorkerInstanceTypes: pulumi.StringArray{
 * 				pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			},
 * 			ClusterSpec:               pulumi.String("ack.pro.small"),
 * 			WorkerNumber:              pulumi.Int(1),
 * 			Password:                  pulumi.String("Test12345"),
 * 			PodCidr:                   pulumi.String("10.99.0.0/16"),
 * 			ServiceCidr:               pulumi.String("172.16.0.0/16"),
 * 			WorkerInstanceChargeType:  pulumi.String("PostPaid"),
 * 			NewNatGateway:             pulumi.Bool(true),
 * 			NodeCidrMask:              pulumi.Int(24),
 * 			LoadBalancerSpec:          pulumi.String("slb.s2.small"),
 * 			InstallCloudMonitor:       pulumi.Bool(true),
 * 			SlbInternetEnabled:        pulumi.Bool(true),
 * 			IsEnterpriseSecurityGroup: pulumi.Bool(true),
 * 			WorkerDataDisks: cs.EdgeKubernetesWorkerDataDiskArray{
 * 				&cs.EdgeKubernetesWorkerDataDiskArgs{
 * 					Category:  pulumi.String("cloud_ssd"),
 * 					Size:      pulumi.String("200"),
 * 					Encrypted: pulumi.String("false"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.cs.EdgeKubernetes;
 * import com.pulumi.alicloud.cs.EdgeKubernetesArgs;
 * import com.pulumi.alicloud.cs.inputs.EdgeKubernetesWorkerDataDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(4)
 *             .memorySize(8)
 *             .kubernetesNodeRole("Master")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultEdgeKubernetes = new EdgeKubernetes("defaultEdgeKubernetes", EdgeKubernetesArgs.builder()
 *             .namePrefix(name)
 *             .workerVswitchIds(defaultSwitch.id())
 *             .workerInstanceTypes(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .clusterSpec("ack.pro.small")
 *             .workerNumber("1")
 *             .password("Test12345")
 *             .podCidr("10.99.0.0/16")
 *             .serviceCidr("172.16.0.0/16")
 *             .workerInstanceChargeType("PostPaid")
 *             .newNatGateway("true")
 *             .nodeCidrMask("24")
 *             .loadBalancerSpec("slb.s2.small")
 *             .installCloudMonitor("true")
 *             .slbInternetEnabled("true")
 *             .isEnterpriseSecurityGroup("true")
 *             .workerDataDisks(EdgeKubernetesWorkerDataDiskArgs.builder()
 *                 .category("cloud_ssd")
 *                 .size("200")
 *                 .encrypted("false")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultEdgeKubernetes:
 *     type: alicloud:cs:EdgeKubernetes
 *     name: default
 *     properties:
 *       namePrefix: ${name}
 *       workerVswitchIds:
 *         - ${defaultSwitch.id}
 *       workerInstanceTypes:
 *         - ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       clusterSpec: ack.pro.small
 *       workerNumber: '1'
 *       password: Test12345
 *       podCidr: 10.99.0.0/16
 *       serviceCidr: 172.16.0.0/16
 *       workerInstanceChargeType: PostPaid
 *       newNatGateway: 'true'
 *       nodeCidrMask: '24'
 *       loadBalancerSpec: slb.s2.small
 *       installCloudMonitor: 'true'
 *       slbInternetEnabled: 'true'
 *       isEnterpriseSecurityGroup: 'true'
 *       workerDataDisks:
 *         - category: cloud_ssd
 *           size: '200'
 *           encrypted: 'false'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 4
 *         memorySize: 8
 *         kubernetesNodeRole: Master
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Kubernetes edge cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.
 * ```sh
 * $ pulumi import alicloud:cs/edgeKubernetes:EdgeKubernetes main cluster-id
 * ```
 * @property addons The addon you want to install in cluster. See `addons` below.
 * @property availabilityZone The ID of availability zone.
 * *Network params*
 * @property clientCert The path of client certificate, like `~/.kube/client-cert.pem`.
 * @property clientKey The path of client key, like `~/.kube/client-key.pem`.
 * @property clusterCaCert The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
 * *Removed params*
 * @property clusterSpec The cluster specifications of kubernetes cluster,which can be empty. Valid values:
 * * ack.standard : Standard edge clusters.
 * * ack.pro.small : Professional edge clusters.
 * @property deletionProtection Whether to enable cluster deletion protection.
 * @property forceUpdate Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
 * @property installCloudMonitor Install cloud monitor agent on ECS. default: `true`.
 * @property isEnterpriseSecurityGroup Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
 * @property keyName The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
 * @property kubeConfig The path of kube config, like `~/.kube/config`.
 * @property loadBalancerSpec The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
 * ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
 * *Worker params*
 * @property logConfig A list of one element containing information about the associated log store. See `log_config` below.
 * @property name The kubernetes cluster's name. It is unique in one Alicloud account.
 * @property namePrefix
 * @property newNatGateway Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
 * @property nodeCidrMask The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
 * @property password The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
 * @property podCidr [Flannel Specific] The CIDR block for the pod network when using Flannel.
 * @property proxyMode Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
 * @property rdsInstances RDS instance list, You can choose which RDS instances whitelist to add instances to.
 * @property resourceGroupId The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
 * @property retainResources
 * @property runtime The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
 * @property securityGroupId The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
 * @property serviceCidr The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
 * @property slbInternetEnabled Whether to create internet load balancer for API Server. Default to true.
 * @property tags Default nil, A map of tags assigned to the kubernetes cluster and work node.
 * @property userData Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
 * @property version Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
 * @property workerDataDisks The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
 * @property workerDiskCategory The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
 * @property workerDiskPerformanceLevel Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
 * @property workerDiskSize The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
 * @property workerDiskSnapshotPolicyId Worker node system disk auto snapshot policy.
 * *Computed params*
 * You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `alicloud.cs.getClusterCredential` is recommended to manage cluster's kube_config.
 * @property workerInstanceChargeType Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
 * @property workerInstanceTypes The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
 * @property workerNumber The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
 * @property workerVswitchIds The vswitches used by workers.
 */
public data class EdgeKubernetesArgs(
    public val addons: Output<List<EdgeKubernetesAddonArgs>>? = null,
    public val availabilityZone: Output<String>? = null,
    public val clientCert: Output<String>? = null,
    public val clientKey: Output<String>? = null,
    public val clusterCaCert: Output<String>? = null,
    public val clusterSpec: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val forceUpdate: Output<Boolean>? = null,
    public val installCloudMonitor: Output<Boolean>? = null,
    public val isEnterpriseSecurityGroup: Output<Boolean>? = null,
    public val keyName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource
      'alicloud_cs_cluster_credential' manage your cluster's kube config.
  """,
    )
    public val kubeConfig: Output<String>? = null,
    public val loadBalancerSpec: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.
  """,
    )
    public val logConfig: Output<EdgeKubernetesLogConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val newNatGateway: Output<Boolean>? = null,
    public val nodeCidrMask: Output<Int>? = null,
    public val password: Output<String>? = null,
    public val podCidr: Output<String>? = null,
    public val proxyMode: Output<String>? = null,
    public val rdsInstances: Output<List<String>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val retainResources: Output<List<String>>? = null,
    public val runtime: Output<EdgeKubernetesRuntimeArgs>? = null,
    public val securityGroupId: Output<String>? = null,
    public val serviceCidr: Output<String>? = null,
    public val slbInternetEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
    public val version: Output<String>? = null,
    public val workerDataDisks: Output<List<EdgeKubernetesWorkerDataDiskArgs>>? = null,
    public val workerDiskCategory: Output<String>? = null,
    public val workerDiskPerformanceLevel: Output<String>? = null,
    public val workerDiskSize: Output<Int>? = null,
    public val workerDiskSnapshotPolicyId: Output<String>? = null,
    public val workerInstanceChargeType: Output<String>? = null,
    public val workerInstanceTypes: Output<List<String>>? = null,
    public val workerNumber: Output<Int>? = null,
    public val workerVswitchIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.EdgeKubernetesArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.EdgeKubernetesArgs =
        com.pulumi.alicloud.cs.EdgeKubernetesArgs.builder()
            .addons(addons?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .clientCert(clientCert?.applyValue({ args0 -> args0 }))
            .clientKey(clientKey?.applyValue({ args0 -> args0 }))
            .clusterCaCert(clusterCaCert?.applyValue({ args0 -> args0 }))
            .clusterSpec(clusterSpec?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .forceUpdate(forceUpdate?.applyValue({ args0 -> args0 }))
            .installCloudMonitor(installCloudMonitor?.applyValue({ args0 -> args0 }))
            .isEnterpriseSecurityGroup(isEnterpriseSecurityGroup?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .kubeConfig(kubeConfig?.applyValue({ args0 -> args0 }))
            .loadBalancerSpec(loadBalancerSpec?.applyValue({ args0 -> args0 }))
            .logConfig(logConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .newNatGateway(newNatGateway?.applyValue({ args0 -> args0 }))
            .nodeCidrMask(nodeCidrMask?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .podCidr(podCidr?.applyValue({ args0 -> args0 }))
            .proxyMode(proxyMode?.applyValue({ args0 -> args0 }))
            .rdsInstances(rdsInstances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .retainResources(retainResources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .runtime(runtime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .serviceCidr(serviceCidr?.applyValue({ args0 -> args0 }))
            .slbInternetEnabled(slbInternetEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workerDataDisks(
                workerDataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .workerDiskCategory(workerDiskCategory?.applyValue({ args0 -> args0 }))
            .workerDiskPerformanceLevel(workerDiskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .workerDiskSize(workerDiskSize?.applyValue({ args0 -> args0 }))
            .workerDiskSnapshotPolicyId(workerDiskSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .workerInstanceChargeType(workerInstanceChargeType?.applyValue({ args0 -> args0 }))
            .workerInstanceTypes(workerInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .workerNumber(workerNumber?.applyValue({ args0 -> args0 }))
            .workerVswitchIds(workerVswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EdgeKubernetesArgs].
 */
@PulumiTagMarker
public class EdgeKubernetesArgsBuilder internal constructor() {
    private var addons: Output<List<EdgeKubernetesAddonArgs>>? = null

    private var availabilityZone: Output<String>? = null

    private var clientCert: Output<String>? = null

    private var clientKey: Output<String>? = null

    private var clusterCaCert: Output<String>? = null

    private var clusterSpec: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var forceUpdate: Output<Boolean>? = null

    private var installCloudMonitor: Output<Boolean>? = null

    private var isEnterpriseSecurityGroup: Output<Boolean>? = null

    private var keyName: Output<String>? = null

    private var kubeConfig: Output<String>? = null

    private var loadBalancerSpec: Output<String>? = null

    private var logConfig: Output<EdgeKubernetesLogConfigArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var newNatGateway: Output<Boolean>? = null

    private var nodeCidrMask: Output<Int>? = null

    private var password: Output<String>? = null

    private var podCidr: Output<String>? = null

    private var proxyMode: Output<String>? = null

    private var rdsInstances: Output<List<String>>? = null

    private var resourceGroupId: Output<String>? = null

    private var retainResources: Output<List<String>>? = null

    private var runtime: Output<EdgeKubernetesRuntimeArgs>? = null

    private var securityGroupId: Output<String>? = null

    private var serviceCidr: Output<String>? = null

    private var slbInternetEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    private var version: Output<String>? = null

    private var workerDataDisks: Output<List<EdgeKubernetesWorkerDataDiskArgs>>? = null

    private var workerDiskCategory: Output<String>? = null

    private var workerDiskPerformanceLevel: Output<String>? = null

    private var workerDiskSize: Output<Int>? = null

    private var workerDiskSnapshotPolicyId: Output<String>? = null

    private var workerInstanceChargeType: Output<String>? = null

    private var workerInstanceTypes: Output<List<String>>? = null

    private var workerNumber: Output<Int>? = null

    private var workerVswitchIds: Output<List<String>>? = null

    /**
     * @param value The addon you want to install in cluster. See `addons` below.
     */
    @JvmName("cofrwjtydqjnjuxo")
    public suspend fun addons(`value`: Output<List<EdgeKubernetesAddonArgs>>) {
        this.addons = value
    }

    @JvmName("tuaxmjygmiwgbxgo")
    public suspend fun addons(vararg values: Output<EdgeKubernetesAddonArgs>) {
        this.addons = Output.all(values.asList())
    }

    /**
     * @param values The addon you want to install in cluster. See `addons` below.
     */
    @JvmName("arojltvnbgcdmllj")
    public suspend fun addons(values: List<Output<EdgeKubernetesAddonArgs>>) {
        this.addons = Output.all(values)
    }

    /**
     * @param value The ID of availability zone.
     * *Network params*
     */
    @JvmName("urqnkydlqtabjhpd")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The path of client certificate, like `~/.kube/client-cert.pem`.
     */
    @JvmName("bdmlibqklarbejpc")
    public suspend fun clientCert(`value`: Output<String>) {
        this.clientCert = value
    }

    /**
     * @param value The path of client key, like `~/.kube/client-key.pem`.
     */
    @JvmName("hfwipmqujydnbpcl")
    public suspend fun clientKey(`value`: Output<String>) {
        this.clientKey = value
    }

    /**
     * @param value The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
     * *Removed params*
     */
    @JvmName("xhdeecqloudmiblc")
    public suspend fun clusterCaCert(`value`: Output<String>) {
        this.clusterCaCert = value
    }

    /**
     * @param value The cluster specifications of kubernetes cluster,which can be empty. Valid values:
     * * ack.standard : Standard edge clusters.
     * * ack.pro.small : Professional edge clusters.
     */
    @JvmName("hwfvdsvlsffaubeu")
    public suspend fun clusterSpec(`value`: Output<String>) {
        this.clusterSpec = value
    }

    /**
     * @param value Whether to enable cluster deletion protection.
     */
    @JvmName("fklskurelofyppgw")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
     */
    @JvmName("qravdmocnjllfsed")
    public suspend fun forceUpdate(`value`: Output<Boolean>) {
        this.forceUpdate = value
    }

    /**
     * @param value Install cloud monitor agent on ECS. default: `true`.
     */
    @JvmName("dguimekhcuwdfyvu")
    public suspend fun installCloudMonitor(`value`: Output<Boolean>) {
        this.installCloudMonitor = value
    }

    /**
     * @param value Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
     */
    @JvmName("dqijtdyfxxbaubkm")
    public suspend fun isEnterpriseSecurityGroup(`value`: Output<Boolean>) {
        this.isEnterpriseSecurityGroup = value
    }

    /**
     * @param value The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("wfqrpyjonabbkbee")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The path of kube config, like `~/.kube/config`.
     */
    @Deprecated(
        message = """
  Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource
      'alicloud_cs_cluster_credential' manage your cluster's kube config.
  """,
    )
    @JvmName("irhyyivedcmrbbrc")
    public suspend fun kubeConfig(`value`: Output<String>) {
        this.kubeConfig = value
    }

    /**
     * @param value The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
     * ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
     * *Worker params*
     */
    @JvmName("bbepmqjbhesnpjkk")
    public suspend fun loadBalancerSpec(`value`: Output<String>) {
        this.loadBalancerSpec = value
    }

    /**
     * @param value A list of one element containing information about the associated log store. See `log_config` below.
     */
    @Deprecated(
        message = """
  Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.
  """,
    )
    @JvmName("viknudkxrnlpkhck")
    public suspend fun logConfig(`value`: Output<EdgeKubernetesLogConfigArgs>) {
        this.logConfig = value
    }

    /**
     * @param value The kubernetes cluster's name. It is unique in one Alicloud account.
     */
    @JvmName("gbvvnohsaftkpnfp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("ervwwplpohswqfsc")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
     */
    @JvmName("vxgnijtuqaixejbs")
    public suspend fun newNatGateway(`value`: Output<Boolean>) {
        this.newNatGateway = value
    }

    /**
     * @param value The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
     */
    @JvmName("keqhxhriivmtopnv")
    public suspend fun nodeCidrMask(`value`: Output<Int>) {
        this.nodeCidrMask = value
    }

    /**
     * @param value The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("xpjauadgdwvrrxsj")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value [Flannel Specific] The CIDR block for the pod network when using Flannel.
     */
    @JvmName("fjafexsklkioysff")
    public suspend fun podCidr(`value`: Output<String>) {
        this.podCidr = value
    }

    /**
     * @param value Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
     */
    @JvmName("cxqhooubrwmjpchi")
    public suspend fun proxyMode(`value`: Output<String>) {
        this.proxyMode = value
    }

    /**
     * @param value RDS instance list, You can choose which RDS instances whitelist to add instances to.
     */
    @JvmName("hhgsrqrqfburahto")
    public suspend fun rdsInstances(`value`: Output<List<String>>) {
        this.rdsInstances = value
    }

    @JvmName("ufbfbjxbkrxqawqb")
    public suspend fun rdsInstances(vararg values: Output<String>) {
        this.rdsInstances = Output.all(values.asList())
    }

    /**
     * @param values RDS instance list, You can choose which RDS instances whitelist to add instances to.
     */
    @JvmName("ngdcfglxxecbujii")
    public suspend fun rdsInstances(values: List<Output<String>>) {
        this.rdsInstances = Output.all(values)
    }

    /**
     * @param value The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
     */
    @JvmName("ykwavpvtmsndqufp")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("mrgsxcsdrnxqkpma")
    public suspend fun retainResources(`value`: Output<List<String>>) {
        this.retainResources = value
    }

    @JvmName("uactjewyxbvupndu")
    public suspend fun retainResources(vararg values: Output<String>) {
        this.retainResources = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("gwjunaekaqtrwufv")
    public suspend fun retainResources(values: List<Output<String>>) {
        this.retainResources = Output.all(values)
    }

    /**
     * @param value The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
     */
    @JvmName("pwsvwgyilgpcyocg")
    public suspend fun runtime(`value`: Output<EdgeKubernetesRuntimeArgs>) {
        this.runtime = value
    }

    /**
     * @param value The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
     */
    @JvmName("ovvnxicjqajkuayn")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
     */
    @JvmName("fwtkxxslsyfptrbt")
    public suspend fun serviceCidr(`value`: Output<String>) {
        this.serviceCidr = value
    }

    /**
     * @param value Whether to create internet load balancer for API Server. Default to true.
     */
    @JvmName("cfajljlxsdujxlyg")
    public suspend fun slbInternetEnabled(`value`: Output<Boolean>) {
        this.slbInternetEnabled = value
    }

    /**
     * @param value Default nil, A map of tags assigned to the kubernetes cluster and work node.
     */
    @JvmName("hysaijeatxewvlfm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
     */
    @JvmName("ijfhqmlidtyuytws")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
     */
    @JvmName("riopvyuipcfxneic")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
     */
    @JvmName("jrkdegaumixrvvff")
    public suspend fun workerDataDisks(`value`: Output<List<EdgeKubernetesWorkerDataDiskArgs>>) {
        this.workerDataDisks = value
    }

    @JvmName("ilrpltugqwwdawaq")
    public suspend fun workerDataDisks(vararg values: Output<EdgeKubernetesWorkerDataDiskArgs>) {
        this.workerDataDisks = Output.all(values.asList())
    }

    /**
     * @param values The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
     */
    @JvmName("irgxyoalnnjumhec")
    public suspend fun workerDataDisks(values: List<Output<EdgeKubernetesWorkerDataDiskArgs>>) {
        this.workerDataDisks = Output.all(values)
    }

    /**
     * @param value The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
     */
    @JvmName("squtvdonvnmjrwwb")
    public suspend fun workerDiskCategory(`value`: Output<String>) {
        this.workerDiskCategory = value
    }

    /**
     * @param value Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
     */
    @JvmName("hpbamqhbjbyhoexk")
    public suspend fun workerDiskPerformanceLevel(`value`: Output<String>) {
        this.workerDiskPerformanceLevel = value
    }

    /**
     * @param value The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
     */
    @JvmName("djqlukonehilyrmb")
    public suspend fun workerDiskSize(`value`: Output<Int>) {
        this.workerDiskSize = value
    }

    /**
     * @param value Worker node system disk auto snapshot policy.
     * *Computed params*
     * You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `alicloud.cs.getClusterCredential` is recommended to manage cluster's kube_config.
     */
    @JvmName("cuhqaswbssjmdunx")
    public suspend fun workerDiskSnapshotPolicyId(`value`: Output<String>) {
        this.workerDiskSnapshotPolicyId = value
    }

    /**
     * @param value Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
     */
    @JvmName("hnbdflgsvfxfnbhm")
    public suspend fun workerInstanceChargeType(`value`: Output<String>) {
        this.workerInstanceChargeType = value
    }

    /**
     * @param value The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
     */
    @JvmName("iseaftlfpysrwgys")
    public suspend fun workerInstanceTypes(`value`: Output<List<String>>) {
        this.workerInstanceTypes = value
    }

    @JvmName("nbgrwoofdyewwhul")
    public suspend fun workerInstanceTypes(vararg values: Output<String>) {
        this.workerInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
     */
    @JvmName("jxmpjujhwuwigxim")
    public suspend fun workerInstanceTypes(values: List<Output<String>>) {
        this.workerInstanceTypes = Output.all(values)
    }

    /**
     * @param value The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
     */
    @JvmName("npqdlfccldbshkgy")
    public suspend fun workerNumber(`value`: Output<Int>) {
        this.workerNumber = value
    }

    /**
     * @param value The vswitches used by workers.
     */
    @JvmName("hlyyaynmqptgqyra")
    public suspend fun workerVswitchIds(`value`: Output<List<String>>) {
        this.workerVswitchIds = value
    }

    @JvmName("mbpbwilehmxvtlsw")
    public suspend fun workerVswitchIds(vararg values: Output<String>) {
        this.workerVswitchIds = Output.all(values.asList())
    }

    /**
     * @param values The vswitches used by workers.
     */
    @JvmName("jujambfcqbteeqqm")
    public suspend fun workerVswitchIds(values: List<Output<String>>) {
        this.workerVswitchIds = Output.all(values)
    }

    /**
     * @param value The addon you want to install in cluster. See `addons` below.
     */
    @JvmName("ejmjgnlbldcnodek")
    public suspend fun addons(`value`: List<EdgeKubernetesAddonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addons = mapped
    }

    /**
     * @param argument The addon you want to install in cluster. See `addons` below.
     */
    @JvmName("niekgevbktwvwilw")
    public suspend fun addons(argument: List<suspend EdgeKubernetesAddonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdgeKubernetesAddonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param argument The addon you want to install in cluster. See `addons` below.
     */
    @JvmName("ogvoculmyuyommow")
    public suspend fun addons(vararg argument: suspend EdgeKubernetesAddonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EdgeKubernetesAddonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param argument The addon you want to install in cluster. See `addons` below.
     */
    @JvmName("pjkyxihfskroxwbv")
    public suspend fun addons(argument: suspend EdgeKubernetesAddonArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EdgeKubernetesAddonArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param values The addon you want to install in cluster. See `addons` below.
     */
    @JvmName("xvspkedjctvomsry")
    public suspend fun addons(vararg values: EdgeKubernetesAddonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addons = mapped
    }

    /**
     * @param value The ID of availability zone.
     * *Network params*
     */
    @JvmName("dixheqiuitlqetae")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The path of client certificate, like `~/.kube/client-cert.pem`.
     */
    @JvmName("pobmdjovyexwgqmg")
    public suspend fun clientCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCert = mapped
    }

    /**
     * @param value The path of client key, like `~/.kube/client-key.pem`.
     */
    @JvmName("dsinrmnvvocqwkbl")
    public suspend fun clientKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientKey = mapped
    }

    /**
     * @param value The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
     * *Removed params*
     */
    @JvmName("fdrwbiosskdrplxp")
    public suspend fun clusterCaCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterCaCert = mapped
    }

    /**
     * @param value The cluster specifications of kubernetes cluster,which can be empty. Valid values:
     * * ack.standard : Standard edge clusters.
     * * ack.pro.small : Professional edge clusters.
     */
    @JvmName("rulsthilximqlcae")
    public suspend fun clusterSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSpec = mapped
    }

    /**
     * @param value Whether to enable cluster deletion protection.
     */
    @JvmName("sioustudqiorniia")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value Default false, when you want to change `vpc_id`, you have to set this field to true, then the cluster will be recreated.
     */
    @JvmName("hhkkgoorborbnogo")
    public suspend fun forceUpdate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdate = mapped
    }

    /**
     * @param value Install cloud monitor agent on ECS. default: `true`.
     */
    @JvmName("ibbgjhdmjjhvjmoe")
    public suspend fun installCloudMonitor(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installCloudMonitor = mapped
    }

    /**
     * @param value Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
     */
    @JvmName("umvchbcgrjelicfr")
    public suspend fun isEnterpriseSecurityGroup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnterpriseSecurityGroup = mapped
    }

    /**
     * @param value The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("hqaqiuvilglwvhbu")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The path of kube config, like `~/.kube/config`.
     */
    @Deprecated(
        message = """
  Field 'kube_config' has been deprecated from provider version 1.187.0. New DataSource
      'alicloud_cs_cluster_credential' manage your cluster's kube config.
  """,
    )
    @JvmName("gvbkofsqyflsqbta")
    public suspend fun kubeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeConfig = mapped
    }

    /**
     * @param value The cluster api server load balance instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
     * ->NOTE: If you want to use `Flannel` as CNI network plugin, You need to specific the `pod_cidr` field and addons with `flannel`.
     * *Worker params*
     */
    @JvmName("jsqgyvnesutatyja")
    public suspend fun loadBalancerSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerSpec = mapped
    }

    /**
     * @param value A list of one element containing information about the associated log store. See `log_config` below.
     */
    @Deprecated(
        message = """
  Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.
  """,
    )
    @JvmName("vatjtafxrhsyykta")
    public suspend fun logConfig(`value`: EdgeKubernetesLogConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfig = mapped
    }

    /**
     * @param argument A list of one element containing information about the associated log store. See `log_config` below.
     */
    @Deprecated(
        message = """
  Field 'log_config' has been removed from provider version 1.103.0. New field 'addons' replaces it.
  """,
    )
    @JvmName("wsvwtgfnmoreoejq")
    public suspend fun logConfig(argument: suspend EdgeKubernetesLogConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EdgeKubernetesLogConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logConfig = mapped
    }

    /**
     * @param value The kubernetes cluster's name. It is unique in one Alicloud account.
     */
    @JvmName("wqetadqowstnagpg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("dvxomoqxruuqlsgr")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice.
     */
    @JvmName("pekbrmpiplvdpvyj")
    public suspend fun newNatGateway(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newNatGateway = mapped
    }

    /**
     * @param value The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
     */
    @JvmName("fgaurmgvmwfjxcbs")
    public suspend fun nodeCidrMask(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCidrMask = mapped
    }

    /**
     * @param value The password of ssh login cluster node. You have to specify one of `password`, `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("cdcpbarxrcovbajd")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value [Flannel Specific] The CIDR block for the pod network when using Flannel.
     */
    @JvmName("aqaxmntxdmxxcaty")
    public suspend fun podCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podCidr = mapped
    }

    /**
     * @param value Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
     */
    @JvmName("agxpadebdqcvxgip")
    public suspend fun proxyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyMode = mapped
    }

    /**
     * @param value RDS instance list, You can choose which RDS instances whitelist to add instances to.
     */
    @JvmName("bgpcprcfnkqyvtge")
    public suspend fun rdsInstances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdsInstances = mapped
    }

    /**
     * @param values RDS instance list, You can choose which RDS instances whitelist to add instances to.
     */
    @JvmName("xxymncvgmwqiygxl")
    public suspend fun rdsInstances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rdsInstances = mapped
    }

    /**
     * @param value The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
     */
    @JvmName("qhcbcpoyluclmwwu")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("qfxxnntnmctunnov")
    public suspend fun retainResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainResources = mapped
    }

    /**
     * @param values
     */
    @JvmName("msbmxxjyuyxikccj")
    public suspend fun retainResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retainResources = mapped
    }

    /**
     * @param value The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
     */
    @JvmName("qlxkuoxfvcqlmwdr")
    public suspend fun runtime(`value`: EdgeKubernetesRuntimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param argument The runtime of containers. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm). See `runtime` below.
     */
    @JvmName("lfqnswbobkadaljr")
    public suspend fun runtime(argument: suspend EdgeKubernetesRuntimeArgsBuilder.() -> Unit) {
        val toBeMapped = EdgeKubernetesRuntimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runtime = mapped
    }

    /**
     * @param value The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
     */
    @JvmName("xigrxeomivwoevtq")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
     */
    @JvmName("hhlqlbmuarpkotox")
    public suspend fun serviceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidr = mapped
    }

    /**
     * @param value Whether to create internet load balancer for API Server. Default to true.
     */
    @JvmName("lusgigqcpsrymwvq")
    public suspend fun slbInternetEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slbInternetEnabled = mapped
    }

    /**
     * @param value Default nil, A map of tags assigned to the kubernetes cluster and work node.
     */
    @JvmName("hwpiwaeuluxbfplw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Default nil, A map of tags assigned to the kubernetes cluster and work node.
     */
    @JvmName("oflhpbhkbjvpcqtk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Windows instances support batch and PowerShell scripts. If your script file is larger than 1 KB, we recommend that you upload the script to Object Storage Service (OSS) and pull it through the internal endpoint of your OSS bucket.
     */
    @JvmName("gnoryuvxoutjabpw")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
     */
    @JvmName("lgvrqubsonbysnqg")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
     */
    @JvmName("xobjusdkevyskrgf")
    public suspend fun workerDataDisks(`value`: List<EdgeKubernetesWorkerDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerDataDisks = mapped
    }

    /**
     * @param argument The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
     */
    @JvmName("ogtpblmevlhhqgbn")
    public suspend fun workerDataDisks(argument: List<suspend EdgeKubernetesWorkerDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdgeKubernetesWorkerDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workerDataDisks = mapped
    }

    /**
     * @param argument The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
     */
    @JvmName("orcnvncarvkrqegk")
    public suspend fun workerDataDisks(vararg argument: suspend EdgeKubernetesWorkerDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EdgeKubernetesWorkerDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workerDataDisks = mapped
    }

    /**
     * @param argument The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
     */
    @JvmName("kaxbyoqtpierwxdb")
    public suspend fun workerDataDisks(argument: suspend EdgeKubernetesWorkerDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EdgeKubernetesWorkerDataDiskArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.workerDataDisks = mapped
    }

    /**
     * @param values The data disk configurations of worker nodes, such as the disk type and disk size. See `worker_data_disks` below.
     */
    @JvmName("bsbhuwkypcoaflwa")
    public suspend fun workerDataDisks(vararg values: EdgeKubernetesWorkerDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workerDataDisks = mapped
    }

    /**
     * @param value The system disk category of worker node. Its valid value are `cloud_efficiency`, `cloud_ssd` and `cloud_essd` and . Default to `cloud_efficiency`.
     */
    @JvmName("qeiabbudbrkdoceo")
    public suspend fun workerDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerDiskCategory = mapped
    }

    /**
     * @param value Worker node system disk performance level, when `worker_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
     */
    @JvmName("sipxiqyhbgtbbfdt")
    public suspend fun workerDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerDiskPerformanceLevel = mapped
    }

    /**
     * @param value The system disk size of worker node. Its valid value range [20~32768] in GB. Default to 40.
     */
    @JvmName("mevumaghyrmxiqiq")
    public suspend fun workerDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerDiskSize = mapped
    }

    /**
     * @param value Worker node system disk auto snapshot policy.
     * *Computed params*
     * You can set some file paths to save kube_config information, but this way is cumbersome. Since version 1.105.0, we've written it to tf state file. About its use，see export attribute certificate_authority. From version 1.187.0+, new DataSource `alicloud.cs.getClusterCredential` is recommended to manage cluster's kube_config.
     */
    @JvmName("afuxryhlnpylxnqx")
    public suspend fun workerDiskSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerDiskSnapshotPolicyId = mapped
    }

    /**
     * @param value Worker payment type, its valid value is `PostPaid`. Defaults to `PostPaid`. More charge details in [ACK@edge charge](https://help.aliyun.com/document_detail/178718.html).
     */
    @JvmName("fqsfxkcjdvlesbit")
    public suspend fun workerInstanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerInstanceChargeType = mapped
    }

    /**
     * @param value The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
     */
    @JvmName("tiohsstjbjnldxvd")
    public suspend fun workerInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerInstanceTypes = mapped
    }

    /**
     * @param values The instance types of worker node, you can set multiple types to avoid NoStock of a certain type.
     */
    @JvmName("frudhjcckyvaovcp")
    public suspend fun workerInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workerInstanceTypes = mapped
    }

    /**
     * @param value The cloud worker node number of the edge kubernetes cluster. Default to 1. It is limited up to 50 and if you want to enlarge it, please apply white list or contact with us.
     */
    @JvmName("sxqccatgfplkhcfy")
    public suspend fun workerNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerNumber = mapped
    }

    /**
     * @param value The vswitches used by workers.
     */
    @JvmName("iykmhhfjmggnnwtf")
    public suspend fun workerVswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerVswitchIds = mapped
    }

    /**
     * @param values The vswitches used by workers.
     */
    @JvmName("yxlwbchtsxuosihf")
    public suspend fun workerVswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workerVswitchIds = mapped
    }

    internal fun build(): EdgeKubernetesArgs = EdgeKubernetesArgs(
        addons = addons,
        availabilityZone = availabilityZone,
        clientCert = clientCert,
        clientKey = clientKey,
        clusterCaCert = clusterCaCert,
        clusterSpec = clusterSpec,
        deletionProtection = deletionProtection,
        forceUpdate = forceUpdate,
        installCloudMonitor = installCloudMonitor,
        isEnterpriseSecurityGroup = isEnterpriseSecurityGroup,
        keyName = keyName,
        kubeConfig = kubeConfig,
        loadBalancerSpec = loadBalancerSpec,
        logConfig = logConfig,
        name = name,
        namePrefix = namePrefix,
        newNatGateway = newNatGateway,
        nodeCidrMask = nodeCidrMask,
        password = password,
        podCidr = podCidr,
        proxyMode = proxyMode,
        rdsInstances = rdsInstances,
        resourceGroupId = resourceGroupId,
        retainResources = retainResources,
        runtime = runtime,
        securityGroupId = securityGroupId,
        serviceCidr = serviceCidr,
        slbInternetEnabled = slbInternetEnabled,
        tags = tags,
        userData = userData,
        version = version,
        workerDataDisks = workerDataDisks,
        workerDiskCategory = workerDiskCategory,
        workerDiskPerformanceLevel = workerDiskPerformanceLevel,
        workerDiskSize = workerDiskSize,
        workerDiskSnapshotPolicyId = workerDiskSnapshotPolicyId,
        workerInstanceChargeType = workerInstanceChargeType,
        workerInstanceTypes = workerInstanceTypes,
        workerNumber = workerNumber,
        workerVswitchIds = workerVswitchIds,
    )
}
