@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesAddon
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesCertificateAuthority
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesConnections
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesDeleteOption
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesMasterNode
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesRuntime
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesAddon.Companion.toKotlin as kubernetesAddonToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesCertificateAuthority.Companion.toKotlin as kubernetesCertificateAuthorityToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesConnections.Companion.toKotlin as kubernetesConnectionsToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesDeleteOption.Companion.toKotlin as kubernetesDeleteOptionToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesMasterNode.Companion.toKotlin as kubernetesMasterNodeToKotlin
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesRuntime.Companion.toKotlin as kubernetesRuntimeToKotlin

/**
 * Builder for [Kubernetes].
 */
@PulumiTagMarker
public class KubernetesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KubernetesArgs = KubernetesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KubernetesArgsBuilder.() -> Unit) {
        val builder = KubernetesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Kubernetes {
        val builtJavaResource = com.pulumi.alicloud.cs.Kubernetes(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Kubernetes(builtJavaResource)
    }
}

/**
 * This resource will help you to manage a Kubernetes Cluster in Alibaba Cloud Kubernetes Service, see [What is kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-an-ask-cluster-1).
 * > **NOTE:** Available since v1.9.0.
 * > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
 * A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
 * VPC, you can set `new_nat_gateway` to "true" to create one automatically.
 * > **NOTE:** Each kubernetes cluster contains 3 master nodes and those number cannot be changed at now.
 * > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.
 * > **NOTE:** From version 1.9.4, the provider supports to download kube config, client certificate, client key and cluster ca certificate
 * after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.
 * > **NOTE:** From version 1.16.0, the provider supports Multiple Availability Zones Kubernetes Cluster. To create a cluster of this kind, you must specify 3 or 5 items in `master_vswitch_ids` and `master_instance_types`.
 * > **NOTE:** From version 1.20.0, the provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.
 * > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.
 * > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
 * Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).
 * > **NOTE:** From version 1.75.0, Some parameters have been removed from resource,You can check them below and re-import the cluster if necessary.
 * > **NOTE:** From version 1.101.0+, We supported the `professional managed clusters(ack-pro)`, You can create a pro cluster by setting the the value of `cluster_spec`.
 * > **NOTE:** From version 1.177.0+, `exclude_autoscaler_nodes`,`worker_number`,`worker_vswitch_ids`,`worker_instance_types`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_port_range`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id` are deprecated.
 * We Suggest you using resource **`alicloud.cs.NodePool`** to manage your cluster worker nodes.
 * > **NOTE:** From version 1.212.0, `exclude_autoscaler_nodes`,`worker_number`,`worker_vswitch_ids`,`worker_instance_types`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_port_range`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`kube_config`,`availability_zone` are removed.
 * Please use resource **`alicloud.cs.NodePool`** to manage your cluster worker nodes.
 * ## Import
 * Kubernetes cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.
 * ```sh
 * $ pulumi import alicloud:cs/kubernetes:Kubernetes main cluster-id
 * ```
 */
public class Kubernetes internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.Kubernetes,
) : KotlinCustomResource(javaResource, KubernetesMapper) {
    /**
     * The addon you want to install in cluster. See `addons` below.
     * *Network params*
     */
    public val addons: Output<List<KubernetesAddon>>?
        get() = javaResource.addons().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> kubernetesAddonToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A list of API audiences for [Service Account Token Volume Projection](https://www&#46;alibabacloud&#46;com/help/doc-detail/160384&#46;htm)&#46; Set this to `["https://kubernetes&#46;default&#46;svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
     */
    public val apiAudiences: Output<List<String>>?
        get() = javaResource.apiAudiences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * (Map, Available since v1.105.0) Nested attribute containing certificate authority data for your cluster.
     */
    public val certificateAuthority: Output<KubernetesCertificateAuthority>
        get() = javaResource.certificateAuthority().applyValue({ args0 ->
            args0.let({ args0 ->
                kubernetesCertificateAuthorityToKotlin(args0)
            })
        })

    /**
     * The path of client certificate, like `~/.kube/client-cert.pem`.
     */
    public val clientCert: Output<String>?
        get() = javaResource.clientCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path of client key, like `~/.kube/client-key.pem`.
     */
    public val clientKey: Output<String>?
        get() = javaResource.clientKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
     * *Removed params*
     */
    public val clusterCaCert: Output<String>?
        get() = javaResource.clusterCaCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
     */
    public val clusterDomain: Output<String>?
        get() = javaResource.clusterDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * (Map) Map of kubernetes cluster connection information.
     */
    public val connections: Output<KubernetesConnections>
        get() = javaResource.connections().applyValue({ args0 ->
            args0.let({ args0 ->
                kubernetesConnectionsToKotlin(args0)
            })
        })

    /**
     * Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
     */
    public val customSan: Output<String>?
        get() = javaResource.customSan().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
     */
    public val deleteOptions: Output<List<KubernetesDeleteOption>>?
        get() = javaResource.deleteOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        kubernetesDeleteOptionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Whether to enable cluster deletion protection.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable login to the node through SSH. Default to `false`.
     */
    public val enableSsh: Output<Boolean>?
        get() = javaResource.enableSsh().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Custom Image support. Must based on CentOS7 or AliyunLinux2.
     */
    public val imageId: Output<String>
        get() = javaResource.imageId().applyValue({ args0 -> args0 })

    /**
     * Install cloud monitor agent on ECS. Default to `true`.
     */
    public val installCloudMonitor: Output<Boolean>?
        get() = javaResource.installCloudMonitor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
     */
    public val isEnterpriseSecurityGroup: Output<Boolean>
        get() = javaResource.isEnterpriseSecurityGroup().applyValue({ args0 -> args0 })

    /**
     * The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    public val keyName: Output<String>?
        get() = javaResource.keyName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
     */
    public val loadBalancerSpec: Output<String>?
        get() = javaResource.loadBalancerSpec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable master payment auto-renew, defaults to false.
     */
    public val masterAutoRenew: Output<Boolean>?
        get() = javaResource.masterAutoRenew().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
     */
    public val masterAutoRenewPeriod: Output<Int>?
        get() = javaResource.masterAutoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
     */
    public val masterDiskCategory: Output<String>?
        get() = javaResource.masterDiskCategory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
     */
    public val masterDiskPerformanceLevel: Output<String>?
        get() = javaResource.masterDiskPerformanceLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
     */
    public val masterDiskSize: Output<Int>?
        get() = javaResource.masterDiskSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Master node system disk auto snapshot policy.
     * *Computed params*
     */
    public val masterDiskSnapshotPolicyId: Output<String>?
        get() = javaResource.masterDiskSnapshotPolicyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
     */
    public val masterInstanceChargeType: Output<String>?
        get() = javaResource.masterInstanceChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
     */
    public val masterInstanceTypes: Output<List<String>>
        get() = javaResource.masterInstanceTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * (Optional) The master nodes. See `master_nodes` below.
     */
    public val masterNodes: Output<List<KubernetesMasterNode>>
        get() = javaResource.masterNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    kubernetesMasterNodeToKotlin(args0)
                })
            })
        })

    /**
     * Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
     */
    public val masterPeriod: Output<Int>?
        get() = javaResource.masterPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Master payment period unit, the valid value is `Month`.
     */
    public val masterPeriodUnit: Output<String>?
        get() = javaResource.masterPeriodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
     */
    public val masterVswitchIds: Output<List<String>>
        get() = javaResource.masterVswitchIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The kubernetes cluster's name. It is unique in one Alicloud account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    @Deprecated(
        message = """
  Field 'name_prefix' has been deprecated from provider version 1.75.0.
  """,
    )
    public val namePrefix: Output<String>?
        get() = javaResource.namePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of nat gateway used to launch kubernetes cluster.
     */
    public val natGatewayId: Output<String>
        get() = javaResource.natGatewayId().applyValue({ args0 -> args0 })

    /**
     * Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
     */
    public val newNatGateway: Output<Boolean>?
        get() = javaResource.newNatGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
     */
    public val nodeCidrMask: Output<Int>?
        get() = javaResource.nodeCidrMask().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
     */
    public val nodeNameMode: Output<String>
        get() = javaResource.nodeNameMode().applyValue({ args0 -> args0 })

    /**
     * The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
     */
    public val osType: Output<String>?
        get() = javaResource.osType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
     */
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * [Flannel Specific] The CIDR block for the pod network when using Flannel.
     */
    public val podCidr: Output<String>?
        get() = javaResource.podCidr().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `worker_vswitch_ids` and `master_vswitch_ids` but must be in same availability zones.
     */
    public val podVswitchIds: Output<List<String>>?
        get() = javaResource.podVswitchIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
     */
    public val proxyMode: Output<String>?
        get() = javaResource.proxyMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * RDS instance list, You can choose which RDS instances whitelist to add instances to.
     */
    public val rdsInstances: Output<List<String>>?
        get() = javaResource.rdsInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    public val retainResources: Output<List<String>>?
        get() = javaResource.retainResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). See `runtime` below.
     */
    public val runtime: Output<KubernetesRuntime>?
        get() = javaResource.runtime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    kubernetesRuntimeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
     */
    public val serviceAccountIssuer: Output<String>?
        get() = javaResource.serviceAccountIssuer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
     */
    public val serviceCidr: Output<String>?
        get() = javaResource.serviceCidr().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of APIServer load balancer.
     */
    public val slbId: Output<String>
        get() = javaResource.slbId().applyValue({ args0 -> args0 })

    /**
     * The public ip of load balancer.
     */
    public val slbInternet: Output<String>
        get() = javaResource.slbInternet().applyValue({ args0 -> args0 })

    /**
     * Whether to create internet load balancer for API Server. Default to true.
     * > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specify the `pod_vswitch_ids` field and addons with `terway-eniip`.
     * If you want to use `Flannel` as CNI network plugin, You need to specify the `pod_cidr` field and addons with `flannel`.
     * *Master params*
     */
    public val slbInternetEnabled: Output<Boolean>?
        get() = javaResource.slbInternetEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of private load balancer where the current cluster master node is located.
     */
    public val slbIntranet: Output<String>
        get() = javaResource.slbIntranet().applyValue({ args0 -> args0 })

    /**
     * Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
     */
    public val timezone: Output<String>?
        get() = javaResource.timezone().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
     */
    public val userCa: Output<String>?
        get() = javaResource.userCa().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * The ID of VPC where the current cluster is located.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The RamRole Name attached to worker node.
     */
    public val workerRamRoleName: Output<String>
        get() = javaResource.workerRamRoleName().applyValue({ args0 -> args0 })
}

public object KubernetesMapper : ResourceMapper<Kubernetes> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.Kubernetes::class == javaResource::class

    override fun map(javaResource: Resource): Kubernetes = Kubernetes(
        javaResource as
            com.pulumi.alicloud.cs.Kubernetes,
    )
}

/**
 * @see [Kubernetes].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Kubernetes].
 */
public suspend fun kubernetes(name: String, block: suspend KubernetesResourceBuilder.() -> Unit): Kubernetes {
    val builder = KubernetesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Kubernetes].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kubernetes(name: String): Kubernetes {
    val builder = KubernetesResourceBuilder()
    builder.name(name)
    return builder.build()
}
