@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [KubernetesAddon].
 */
@PulumiTagMarker
public class KubernetesAddonResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KubernetesAddonArgs = KubernetesAddonArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KubernetesAddonArgsBuilder.() -> Unit) {
        val builder = KubernetesAddonArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KubernetesAddon {
        val builtJavaResource = com.pulumi.alicloud.cs.KubernetesAddon(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KubernetesAddon(builtJavaResource)
    }
}

/**
 * This resource will help you to manage addon in Kubernetes Cluster, see What is kubernetes addon.
 * > **NOTE:** Available since v1.150.0.
 * > **NOTE:** From version 1.166.0, support specifying addon customizable configuration.
 * ## Import
 * Cluster addon can be imported by cluster id and addon name. Then write the addon.tf file according to the result of `pulumi preview`.
 * ```sh
 * $ pulumi import alicloud:cs/kubernetesAddon:KubernetesAddon my_addon <cluster_id>:<addon_name>
 * ```
 */
public class KubernetesAddon internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.KubernetesAddon,
) : KotlinCustomResource(javaResource, KubernetesAddonMapper) {
    /**
     * Is the addon ready for upgrade.
     */
    public val canUpgrade: Output<Boolean>
        get() = javaResource.canUpgrade().applyValue({ args0 -> args0 })

    /**
     * Whether to clean up cloud resources when deleting. Currently only works for addon `ack-virtual-node` and you must specify it when uninstall addon `ack-virtual-node`. Valid values: `true`: clean up, `false`: do not clean up.
     */
    public val cleanupCloudResources: Output<Boolean>?
        get() = javaResource.cleanupCloudResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of kubernetes cluster.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The customized configuration of addon. Your customized configuration will be merged to existed configuration stored in server. If you want to clean one configuration, you must set the configuration to empty value, removing from code cannot make effect. You can checkout the customized configuration of the addon through datasource `alicloud.cs.getKubernetesAddonMetadata`, the returned format is the standard json schema. If return empty, it means that the addon does not support custom configuration yet. You can also checkout the current custom configuration through the data source `alicloud.cs.getKubernetesAddons`.
     */
    public val config: Output<String>
        get() = javaResource.config().applyValue({ args0 -> args0 })

    /**
     * The name of addon.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The version which addon can be upgraded to.
     */
    public val nextVersion: Output<String>
        get() = javaResource.nextVersion().applyValue({ args0 -> args0 })

    /**
     * Is it a mandatory addon to be installed.
     */
    public val required: Output<Boolean>
        get() = javaResource.required().applyValue({ args0 -> args0 })

    /**
     * The current version of addon.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object KubernetesAddonMapper : ResourceMapper<KubernetesAddon> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.KubernetesAddon::class == javaResource::class

    override fun map(javaResource: Resource): KubernetesAddon = KubernetesAddon(
        javaResource as
            com.pulumi.alicloud.cs.KubernetesAddon,
    )
}

/**
 * @see [KubernetesAddon].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KubernetesAddon].
 */
public suspend fun kubernetesAddon(
    name: String,
    block: suspend KubernetesAddonResourceBuilder.() -> Unit,
): KubernetesAddon {
    val builder = KubernetesAddonResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KubernetesAddon].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kubernetesAddon(name: String): KubernetesAddon {
    val builder = KubernetesAddonResourceBuilder()
    builder.name(name)
    return builder.build()
}
