@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.KubernetesAddonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This resource will help you to manage addon in Kubernetes Cluster, see What is kubernetes addon.
 * > **NOTE:** Available since v1.150.0.
 * > **NOTE:** From version 1.166.0, support specifying addon customizable configuration.
 * ## Import
 * Cluster addon can be imported by cluster id and addon name. Then write the addon.tf file according to the result of `pulumi preview`.
 * ```sh
 * $ pulumi import alicloud:cs/kubernetesAddon:KubernetesAddon my_addon <cluster_id>:<addon_name>
 * ```
 * @property cleanupCloudResources Whether to clean up cloud resources when deleting. Currently only works for addon `ack-virtual-node` and you must specify it when uninstall addon `ack-virtual-node`. Valid values: `true`: clean up, `false`: do not clean up.
 * @property clusterId The id of kubernetes cluster.
 * @property config The customized configuration of addon. Your customized configuration will be merged to existed configuration stored in server. If you want to clean one configuration, you must set the configuration to empty value, removing from code cannot make effect. You can checkout the customized configuration of the addon through datasource `alicloud.cs.getKubernetesAddonMetadata`, the returned format is the standard json schema. If return empty, it means that the addon does not support custom configuration yet. You can also checkout the current custom configuration through the data source `alicloud.cs.getKubernetesAddons`.
 * @property name The name of addon.
 * @property version The current version of addon.
 */
public data class KubernetesAddonArgs(
    public val cleanupCloudResources: Output<Boolean>? = null,
    public val clusterId: Output<String>? = null,
    public val config: Output<String>? = null,
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.KubernetesAddonArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.KubernetesAddonArgs =
        com.pulumi.alicloud.cs.KubernetesAddonArgs.builder()
            .cleanupCloudResources(cleanupCloudResources?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .config(config?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesAddonArgs].
 */
@PulumiTagMarker
public class KubernetesAddonArgsBuilder internal constructor() {
    private var cleanupCloudResources: Output<Boolean>? = null

    private var clusterId: Output<String>? = null

    private var config: Output<String>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Whether to clean up cloud resources when deleting. Currently only works for addon `ack-virtual-node` and you must specify it when uninstall addon `ack-virtual-node`. Valid values: `true`: clean up, `false`: do not clean up.
     */
    @JvmName("typqxynbdvueaubm")
    public suspend fun cleanupCloudResources(`value`: Output<Boolean>) {
        this.cleanupCloudResources = value
    }

    /**
     * @param value The id of kubernetes cluster.
     */
    @JvmName("ixauamyxvyodttmf")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The customized configuration of addon. Your customized configuration will be merged to existed configuration stored in server. If you want to clean one configuration, you must set the configuration to empty value, removing from code cannot make effect. You can checkout the customized configuration of the addon through datasource `alicloud.cs.getKubernetesAddonMetadata`, the returned format is the standard json schema. If return empty, it means that the addon does not support custom configuration yet. You can also checkout the current custom configuration through the data source `alicloud.cs.getKubernetesAddons`.
     */
    @JvmName("ebrincthtrsqjaej")
    public suspend fun config(`value`: Output<String>) {
        this.config = value
    }

    /**
     * @param value The name of addon.
     */
    @JvmName("nmesoejwxrvhpnrf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The current version of addon.
     */
    @JvmName("xgbiftfslfnxjqkc")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Whether to clean up cloud resources when deleting. Currently only works for addon `ack-virtual-node` and you must specify it when uninstall addon `ack-virtual-node`. Valid values: `true`: clean up, `false`: do not clean up.
     */
    @JvmName("gvimxjjnqlyefkeo")
    public suspend fun cleanupCloudResources(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cleanupCloudResources = mapped
    }

    /**
     * @param value The id of kubernetes cluster.
     */
    @JvmName("nbabxdlminddphrq")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The customized configuration of addon. Your customized configuration will be merged to existed configuration stored in server. If you want to clean one configuration, you must set the configuration to empty value, removing from code cannot make effect. You can checkout the customized configuration of the addon through datasource `alicloud.cs.getKubernetesAddonMetadata`, the returned format is the standard json schema. If return empty, it means that the addon does not support custom configuration yet. You can also checkout the current custom configuration through the data source `alicloud.cs.getKubernetesAddons`.
     */
    @JvmName("nbqeiapmckwgmdba")
    public suspend fun config(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value The name of addon.
     */
    @JvmName("igdskkkjgjvnsxuy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The current version of addon.
     */
    @JvmName("aqgejwfsctnicxds")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): KubernetesAddonArgs = KubernetesAddonArgs(
        cleanupCloudResources = cleanupCloudResources,
        clusterId = clusterId,
        config = config,
        name = name,
        version = version,
    )
}
