@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.KubernetesArgs.builder
import com.pulumi.alicloud.cs.kotlin.inputs.KubernetesAddonArgs
import com.pulumi.alicloud.cs.kotlin.inputs.KubernetesAddonArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.KubernetesDeleteOptionArgs
import com.pulumi.alicloud.cs.kotlin.inputs.KubernetesDeleteOptionArgsBuilder
import com.pulumi.alicloud.cs.kotlin.inputs.KubernetesRuntimeArgs
import com.pulumi.alicloud.cs.kotlin.inputs.KubernetesRuntimeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This resource will help you to manage a Kubernetes Cluster in Alibaba Cloud Kubernetes Service, see [What is kubernetes](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/create-an-ask-cluster-1).
 * > **NOTE:** Available since v1.9.0.
 * > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
 * A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
 * VPC, you can set `new_nat_gateway` to "true" to create one automatically.
 * > **NOTE:** Each kubernetes cluster contains 3 master nodes and those number cannot be changed at now.
 * > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.
 * > **NOTE:** From version 1.9.4, the provider supports to download kube config, client certificate, client key and cluster ca certificate
 * after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.
 * > **NOTE:** From version 1.16.0, the provider supports Multiple Availability Zones Kubernetes Cluster. To create a cluster of this kind, you must specify 3 or 5 items in `master_vswitch_ids` and `master_instance_types`.
 * > **NOTE:** From version 1.20.0, the provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.
 * > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.
 * > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
 * Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).
 * > **NOTE:** From version 1.75.0, Some parameters have been removed from resource,You can check them below and re-import the cluster if necessary.
 * > **NOTE:** From version 1.101.0+, We supported the `professional managed clusters(ack-pro)`, You can create a pro cluster by setting the the value of `cluster_spec`.
 * > **NOTE:** From version 1.177.0+, `exclude_autoscaler_nodes`,`worker_number`,`worker_vswitch_ids`,`worker_instance_types`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_port_range`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id` are deprecated.
 * We Suggest you using resource **`alicloud.cs.NodePool`** to manage your cluster worker nodes.
 * > **NOTE:** From version 1.212.0, `exclude_autoscaler_nodes`,`worker_number`,`worker_vswitch_ids`,`worker_instance_types`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_port_range`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`kube_config`,`availability_zone` are removed.
 * Please use resource **`alicloud.cs.NodePool`** to manage your cluster worker nodes.
 * ## Import
 * Kubernetes cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.
 * ```sh
 * $ pulumi import alicloud:cs/kubernetes:Kubernetes main cluster-id
 * ```
 * @property addons The addon you want to install in cluster. See `addons` below.
 * *Network params*
 * @property apiAudiences A list of API audiences for [Service Account Token Volume Projection](https://www&#46;alibabacloud&#46;com/help/doc-detail/160384&#46;htm)&#46; Set this to `["https://kubernetes&#46;default&#46;svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
 * @property clientCert The path of client certificate, like `~/.kube/client-cert.pem`.
 * @property clientKey The path of client key, like `~/.kube/client-key.pem`.
 * @property clusterCaCert The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
 * *Removed params*
 * @property clusterDomain Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
 * @property customSan Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
 * @property deleteOptions Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
 * @property deletionProtection Whether to enable cluster deletion protection.
 * @property enableSsh Enable login to the node through SSH. Default to `false`.
 * @property imageId Custom Image support. Must based on CentOS7 or AliyunLinux2.
 * @property installCloudMonitor Install cloud monitor agent on ECS. Default to `true`.
 * @property isEnterpriseSecurityGroup Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
 * @property keyName The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
 * @property kmsEncryptedPassword An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 * @property loadBalancerSpec The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
 * @property masterAutoRenew Enable master payment auto-renew, defaults to false.
 * @property masterAutoRenewPeriod Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
 * @property masterDiskCategory The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
 * @property masterDiskPerformanceLevel Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
 * @property masterDiskSize The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
 * @property masterDiskSnapshotPolicyId Master node system disk auto snapshot policy.
 * *Computed params*
 * @property masterInstanceChargeType Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
 * @property masterInstanceTypes The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
 * @property masterPeriod Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
 * @property masterPeriodUnit Master payment period unit, the valid value is `Month`.
 * @property masterVswitchIds The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
 * @property name The kubernetes cluster's name. It is unique in one Alicloud account.
 * @property namePrefix
 * @property newNatGateway Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
 * @property nodeCidrMask The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
 * @property nodeNameMode Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
 * @property osType The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
 * @property password The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
 * @property platform The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
 * @property podCidr [Flannel Specific] The CIDR block for the pod network when using Flannel.
 * @property podVswitchIds [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `worker_vswitch_ids` and `master_vswitch_ids` but must be in same availability zones.
 * @property proxyMode Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
 * @property rdsInstances RDS instance list, You can choose which RDS instances whitelist to add instances to.
 * @property resourceGroupId The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
 * @property retainResources
 * @property runtime The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). See `runtime` below.
 * @property securityGroupId The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
 * @property serviceAccountIssuer The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
 * @property serviceCidr The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
 * @property slbInternetEnabled Whether to create internet load balancer for API Server. Default to true.
 * > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specify the `pod_vswitch_ids` field and addons with `terway-eniip`.
 * If you want to use `Flannel` as CNI network plugin, You need to specify the `pod_cidr` field and addons with `flannel`.
 * *Master params*
 * @property tags Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
 * @property timezone When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
 * @property userCa The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
 * @property version Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
 */
public data class KubernetesArgs(
    public val addons: Output<List<KubernetesAddonArgs>>? = null,
    public val apiAudiences: Output<List<String>>? = null,
    public val clientCert: Output<String>? = null,
    public val clientKey: Output<String>? = null,
    public val clusterCaCert: Output<String>? = null,
    public val clusterDomain: Output<String>? = null,
    public val customSan: Output<String>? = null,
    public val deleteOptions: Output<List<KubernetesDeleteOptionArgs>>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val enableSsh: Output<Boolean>? = null,
    public val imageId: Output<String>? = null,
    public val installCloudMonitor: Output<Boolean>? = null,
    public val isEnterpriseSecurityGroup: Output<Boolean>? = null,
    public val keyName: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    public val loadBalancerSpec: Output<String>? = null,
    public val masterAutoRenew: Output<Boolean>? = null,
    public val masterAutoRenewPeriod: Output<Int>? = null,
    public val masterDiskCategory: Output<String>? = null,
    public val masterDiskPerformanceLevel: Output<String>? = null,
    public val masterDiskSize: Output<Int>? = null,
    public val masterDiskSnapshotPolicyId: Output<String>? = null,
    public val masterInstanceChargeType: Output<String>? = null,
    public val masterInstanceTypes: Output<List<String>>? = null,
    public val masterPeriod: Output<Int>? = null,
    public val masterPeriodUnit: Output<String>? = null,
    public val masterVswitchIds: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name_prefix' has been deprecated from provider version 1.75.0.
  """,
    )
    public val namePrefix: Output<String>? = null,
    public val newNatGateway: Output<Boolean>? = null,
    public val nodeCidrMask: Output<Int>? = null,
    public val nodeNameMode: Output<String>? = null,
    public val osType: Output<String>? = null,
    public val password: Output<String>? = null,
    public val platform: Output<String>? = null,
    public val podCidr: Output<String>? = null,
    public val podVswitchIds: Output<List<String>>? = null,
    public val proxyMode: Output<String>? = null,
    public val rdsInstances: Output<List<String>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val retainResources: Output<List<String>>? = null,
    public val runtime: Output<KubernetesRuntimeArgs>? = null,
    public val securityGroupId: Output<String>? = null,
    public val serviceAccountIssuer: Output<String>? = null,
    public val serviceCidr: Output<String>? = null,
    public val slbInternetEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timezone: Output<String>? = null,
    public val userCa: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.KubernetesArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.KubernetesArgs =
        com.pulumi.alicloud.cs.KubernetesArgs.builder()
            .addons(addons?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .apiAudiences(apiAudiences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clientCert(clientCert?.applyValue({ args0 -> args0 }))
            .clientKey(clientKey?.applyValue({ args0 -> args0 }))
            .clusterCaCert(clusterCaCert?.applyValue({ args0 -> args0 }))
            .clusterDomain(clusterDomain?.applyValue({ args0 -> args0 }))
            .customSan(customSan?.applyValue({ args0 -> args0 }))
            .deleteOptions(
                deleteOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .enableSsh(enableSsh?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .installCloudMonitor(installCloudMonitor?.applyValue({ args0 -> args0 }))
            .isEnterpriseSecurityGroup(isEnterpriseSecurityGroup?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .loadBalancerSpec(loadBalancerSpec?.applyValue({ args0 -> args0 }))
            .masterAutoRenew(masterAutoRenew?.applyValue({ args0 -> args0 }))
            .masterAutoRenewPeriod(masterAutoRenewPeriod?.applyValue({ args0 -> args0 }))
            .masterDiskCategory(masterDiskCategory?.applyValue({ args0 -> args0 }))
            .masterDiskPerformanceLevel(masterDiskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .masterDiskSize(masterDiskSize?.applyValue({ args0 -> args0 }))
            .masterDiskSnapshotPolicyId(masterDiskSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .masterInstanceChargeType(masterInstanceChargeType?.applyValue({ args0 -> args0 }))
            .masterInstanceTypes(masterInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .masterPeriod(masterPeriod?.applyValue({ args0 -> args0 }))
            .masterPeriodUnit(masterPeriodUnit?.applyValue({ args0 -> args0 }))
            .masterVswitchIds(masterVswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .newNatGateway(newNatGateway?.applyValue({ args0 -> args0 }))
            .nodeCidrMask(nodeCidrMask?.applyValue({ args0 -> args0 }))
            .nodeNameMode(nodeNameMode?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0 }))
            .podCidr(podCidr?.applyValue({ args0 -> args0 }))
            .podVswitchIds(podVswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .proxyMode(proxyMode?.applyValue({ args0 -> args0 }))
            .rdsInstances(rdsInstances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .retainResources(retainResources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .runtime(runtime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .serviceAccountIssuer(serviceAccountIssuer?.applyValue({ args0 -> args0 }))
            .serviceCidr(serviceCidr?.applyValue({ args0 -> args0 }))
            .slbInternetEnabled(slbInternetEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timezone(timezone?.applyValue({ args0 -> args0 }))
            .userCa(userCa?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesArgs].
 */
@PulumiTagMarker
public class KubernetesArgsBuilder internal constructor() {
    private var addons: Output<List<KubernetesAddonArgs>>? = null

    private var apiAudiences: Output<List<String>>? = null

    private var clientCert: Output<String>? = null

    private var clientKey: Output<String>? = null

    private var clusterCaCert: Output<String>? = null

    private var clusterDomain: Output<String>? = null

    private var customSan: Output<String>? = null

    private var deleteOptions: Output<List<KubernetesDeleteOptionArgs>>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var enableSsh: Output<Boolean>? = null

    private var imageId: Output<String>? = null

    private var installCloudMonitor: Output<Boolean>? = null

    private var isEnterpriseSecurityGroup: Output<Boolean>? = null

    private var keyName: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var loadBalancerSpec: Output<String>? = null

    private var masterAutoRenew: Output<Boolean>? = null

    private var masterAutoRenewPeriod: Output<Int>? = null

    private var masterDiskCategory: Output<String>? = null

    private var masterDiskPerformanceLevel: Output<String>? = null

    private var masterDiskSize: Output<Int>? = null

    private var masterDiskSnapshotPolicyId: Output<String>? = null

    private var masterInstanceChargeType: Output<String>? = null

    private var masterInstanceTypes: Output<List<String>>? = null

    private var masterPeriod: Output<Int>? = null

    private var masterPeriodUnit: Output<String>? = null

    private var masterVswitchIds: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var newNatGateway: Output<Boolean>? = null

    private var nodeCidrMask: Output<Int>? = null

    private var nodeNameMode: Output<String>? = null

    private var osType: Output<String>? = null

    private var password: Output<String>? = null

    private var platform: Output<String>? = null

    private var podCidr: Output<String>? = null

    private var podVswitchIds: Output<List<String>>? = null

    private var proxyMode: Output<String>? = null

    private var rdsInstances: Output<List<String>>? = null

    private var resourceGroupId: Output<String>? = null

    private var retainResources: Output<List<String>>? = null

    private var runtime: Output<KubernetesRuntimeArgs>? = null

    private var securityGroupId: Output<String>? = null

    private var serviceAccountIssuer: Output<String>? = null

    private var serviceCidr: Output<String>? = null

    private var slbInternetEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timezone: Output<String>? = null

    private var userCa: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The addon you want to install in cluster. See `addons` below.
     * *Network params*
     */
    @JvmName("vwmbamubqxuvgasi")
    public suspend fun addons(`value`: Output<List<KubernetesAddonArgs>>) {
        this.addons = value
    }

    @JvmName("vqiwgrdsqhyfgbne")
    public suspend fun addons(vararg values: Output<KubernetesAddonArgs>) {
        this.addons = Output.all(values.asList())
    }

    /**
     * @param values The addon you want to install in cluster. See `addons` below.
     * *Network params*
     */
    @JvmName("psyyoamcrnouenix")
    public suspend fun addons(values: List<Output<KubernetesAddonArgs>>) {
        this.addons = Output.all(values)
    }

    /**
     * @param value A list of API audiences for [Service Account Token Volume Projection](https://www&#46;alibabacloud&#46;com/help/doc-detail/160384&#46;htm)&#46; Set this to `["https://kubernetes&#46;default&#46;svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
     */
    @JvmName("cvaabisbifoiuqgm")
    public suspend fun apiAudiences(`value`: Output<List<String>>) {
        this.apiAudiences = value
    }

    @JvmName("drinjrprjhdpfuqi")
    public suspend fun apiAudiences(vararg values: Output<String>) {
        this.apiAudiences = Output.all(values.asList())
    }

    /**
     * @param values A list of API audiences for [Service Account Token Volume Projection](https://www&#46;alibabacloud&#46;com/help/doc-detail/160384&#46;htm)&#46; Set this to `["https://kubernetes&#46;default&#46;svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
     */
    @JvmName("tysnlwudbljhgyfc")
    public suspend fun apiAudiences(values: List<Output<String>>) {
        this.apiAudiences = Output.all(values)
    }

    /**
     * @param value The path of client certificate, like `~/.kube/client-cert.pem`.
     */
    @JvmName("lcwwwqdoiwqqfmmf")
    public suspend fun clientCert(`value`: Output<String>) {
        this.clientCert = value
    }

    /**
     * @param value The path of client key, like `~/.kube/client-key.pem`.
     */
    @JvmName("feruqwqgfvxxcwbb")
    public suspend fun clientKey(`value`: Output<String>) {
        this.clientKey = value
    }

    /**
     * @param value The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
     * *Removed params*
     */
    @JvmName("lfjoxdrtxbkmnvky")
    public suspend fun clusterCaCert(`value`: Output<String>) {
        this.clusterCaCert = value
    }

    /**
     * @param value Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
     */
    @JvmName("sdbmogqmwnvyaryq")
    public suspend fun clusterDomain(`value`: Output<String>) {
        this.clusterDomain = value
    }

    /**
     * @param value Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
     */
    @JvmName("vjkmxjlqyujuvnkj")
    public suspend fun customSan(`value`: Output<String>) {
        this.customSan = value
    }

    /**
     * @param value Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
     */
    @JvmName("tuyydlreqajgsduw")
    public suspend fun deleteOptions(`value`: Output<List<KubernetesDeleteOptionArgs>>) {
        this.deleteOptions = value
    }

    @JvmName("qoecwpidmfbpogjd")
    public suspend fun deleteOptions(vararg values: Output<KubernetesDeleteOptionArgs>) {
        this.deleteOptions = Output.all(values.asList())
    }

    /**
     * @param values Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
     */
    @JvmName("umsnkmmhmwdtvjeb")
    public suspend fun deleteOptions(values: List<Output<KubernetesDeleteOptionArgs>>) {
        this.deleteOptions = Output.all(values)
    }

    /**
     * @param value Whether to enable cluster deletion protection.
     */
    @JvmName("mxqiuufqkdwhqiam")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value Enable login to the node through SSH. Default to `false`.
     */
    @JvmName("ygqecxeephqtiolb")
    public suspend fun enableSsh(`value`: Output<Boolean>) {
        this.enableSsh = value
    }

    /**
     * @param value Custom Image support. Must based on CentOS7 or AliyunLinux2.
     */
    @JvmName("jddfxhffvhmjcmwj")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Install cloud monitor agent on ECS. Default to `true`.
     */
    @JvmName("techbddxdidnkiyh")
    public suspend fun installCloudMonitor(`value`: Output<Boolean>) {
        this.installCloudMonitor = value
    }

    /**
     * @param value Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
     */
    @JvmName("bkjkuqvcjtcndaxw")
    public suspend fun isEnterpriseSecurityGroup(`value`: Output<Boolean>) {
        this.isEnterpriseSecurityGroup = value
    }

    /**
     * @param value The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("svwsldfmqpobbsit")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("kjrdpkhvygulvmsu")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("yifmnffoypohsvyk")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
     */
    @JvmName("pchsvmxyiscrnsol")
    public suspend fun loadBalancerSpec(`value`: Output<String>) {
        this.loadBalancerSpec = value
    }

    /**
     * @param value Enable master payment auto-renew, defaults to false.
     */
    @JvmName("rxfejtcdqceimtqq")
    public suspend fun masterAutoRenew(`value`: Output<Boolean>) {
        this.masterAutoRenew = value
    }

    /**
     * @param value Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
     */
    @JvmName("wowvhwxpktusbwub")
    public suspend fun masterAutoRenewPeriod(`value`: Output<Int>) {
        this.masterAutoRenewPeriod = value
    }

    /**
     * @param value The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
     */
    @JvmName("rbntqfniaaaafeog")
    public suspend fun masterDiskCategory(`value`: Output<String>) {
        this.masterDiskCategory = value
    }

    /**
     * @param value Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
     */
    @JvmName("osrpomrvnuutupir")
    public suspend fun masterDiskPerformanceLevel(`value`: Output<String>) {
        this.masterDiskPerformanceLevel = value
    }

    /**
     * @param value The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
     */
    @JvmName("amtjkhlgctvhilam")
    public suspend fun masterDiskSize(`value`: Output<Int>) {
        this.masterDiskSize = value
    }

    /**
     * @param value Master node system disk auto snapshot policy.
     * *Computed params*
     */
    @JvmName("aqeveeydutwubvvs")
    public suspend fun masterDiskSnapshotPolicyId(`value`: Output<String>) {
        this.masterDiskSnapshotPolicyId = value
    }

    /**
     * @param value Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
     */
    @JvmName("exlmorehamohqxoo")
    public suspend fun masterInstanceChargeType(`value`: Output<String>) {
        this.masterInstanceChargeType = value
    }

    /**
     * @param value The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
     */
    @JvmName("ugtrlymfoffbifst")
    public suspend fun masterInstanceTypes(`value`: Output<List<String>>) {
        this.masterInstanceTypes = value
    }

    @JvmName("rurqbdnqaplififv")
    public suspend fun masterInstanceTypes(vararg values: Output<String>) {
        this.masterInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
     */
    @JvmName("eijuauqptmwstgyt")
    public suspend fun masterInstanceTypes(values: List<Output<String>>) {
        this.masterInstanceTypes = Output.all(values)
    }

    /**
     * @param value Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
     */
    @JvmName("iasuirbfwjbyfhhl")
    public suspend fun masterPeriod(`value`: Output<Int>) {
        this.masterPeriod = value
    }

    /**
     * @param value Master payment period unit, the valid value is `Month`.
     */
    @JvmName("ynlymvvegjgjdjkv")
    public suspend fun masterPeriodUnit(`value`: Output<String>) {
        this.masterPeriodUnit = value
    }

    /**
     * @param value The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
     */
    @JvmName("hinwcyrukujpxink")
    public suspend fun masterVswitchIds(`value`: Output<List<String>>) {
        this.masterVswitchIds = value
    }

    @JvmName("hrliamuuojwmskah")
    public suspend fun masterVswitchIds(vararg values: Output<String>) {
        this.masterVswitchIds = Output.all(values.asList())
    }

    /**
     * @param values The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
     */
    @JvmName("ecmijlxfxbftshqt")
    public suspend fun masterVswitchIds(values: List<Output<String>>) {
        this.masterVswitchIds = Output.all(values)
    }

    /**
     * @param value The kubernetes cluster's name. It is unique in one Alicloud account.
     */
    @JvmName("yxgyskcpgewdgprs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'name_prefix' has been deprecated from provider version 1.75.0.
  """,
    )
    @JvmName("gyghnwksknfqivph")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
     */
    @JvmName("mqmtquwduhdirlgj")
    public suspend fun newNatGateway(`value`: Output<Boolean>) {
        this.newNatGateway = value
    }

    /**
     * @param value The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
     */
    @JvmName("bhusdgdvpoypinqr")
    public suspend fun nodeCidrMask(`value`: Output<Int>) {
        this.nodeCidrMask = value
    }

    /**
     * @param value Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
     */
    @JvmName("oasqsvbraofbjwqm")
    public suspend fun nodeNameMode(`value`: Output<String>) {
        this.nodeNameMode = value
    }

    /**
     * @param value The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
     */
    @JvmName("rggnyuscpshbqrlq")
    public suspend fun osType(`value`: Output<String>) {
        this.osType = value
    }

    /**
     * @param value The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("byilruoqpbwxvwww")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
     */
    @JvmName("opuhgasxsxkgbulx")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value [Flannel Specific] The CIDR block for the pod network when using Flannel.
     */
    @JvmName("ojejqxulgfpworsj")
    public suspend fun podCidr(`value`: Output<String>) {
        this.podCidr = value
    }

    /**
     * @param value [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `worker_vswitch_ids` and `master_vswitch_ids` but must be in same availability zones.
     */
    @JvmName("rmyrfrxetowogxcg")
    public suspend fun podVswitchIds(`value`: Output<List<String>>) {
        this.podVswitchIds = value
    }

    @JvmName("kaicwdgohrkgsywg")
    public suspend fun podVswitchIds(vararg values: Output<String>) {
        this.podVswitchIds = Output.all(values.asList())
    }

    /**
     * @param values [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `worker_vswitch_ids` and `master_vswitch_ids` but must be in same availability zones.
     */
    @JvmName("mijvvvacarxqfkyw")
    public suspend fun podVswitchIds(values: List<Output<String>>) {
        this.podVswitchIds = Output.all(values)
    }

    /**
     * @param value Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
     */
    @JvmName("wkgsxlwjgpkoleff")
    public suspend fun proxyMode(`value`: Output<String>) {
        this.proxyMode = value
    }

    /**
     * @param value RDS instance list, You can choose which RDS instances whitelist to add instances to.
     */
    @JvmName("mwjkvmfskqclsyrs")
    public suspend fun rdsInstances(`value`: Output<List<String>>) {
        this.rdsInstances = value
    }

    @JvmName("byetxwrmaywfogfm")
    public suspend fun rdsInstances(vararg values: Output<String>) {
        this.rdsInstances = Output.all(values.asList())
    }

    /**
     * @param values RDS instance list, You can choose which RDS instances whitelist to add instances to.
     */
    @JvmName("oyroqdmuttsqfwrp")
    public suspend fun rdsInstances(values: List<Output<String>>) {
        this.rdsInstances = Output.all(values)
    }

    /**
     * @param value The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
     */
    @JvmName("cqjoefiaqrcirmva")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("esbolpblppmwocho")
    public suspend fun retainResources(`value`: Output<List<String>>) {
        this.retainResources = value
    }

    @JvmName("vgngedogikurofjr")
    public suspend fun retainResources(vararg values: Output<String>) {
        this.retainResources = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("diwjeeyyppxdprtl")
    public suspend fun retainResources(values: List<Output<String>>) {
        this.retainResources = Output.all(values)
    }

    /**
     * @param value The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). See `runtime` below.
     */
    @JvmName("tobfrksrdjpexdar")
    public suspend fun runtime(`value`: Output<KubernetesRuntimeArgs>) {
        this.runtime = value
    }

    /**
     * @param value The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
     */
    @JvmName("exuvxqyapeqdjhcn")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
     */
    @JvmName("tafjfkfmecyogqjd")
    public suspend fun serviceAccountIssuer(`value`: Output<String>) {
        this.serviceAccountIssuer = value
    }

    /**
     * @param value The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
     */
    @JvmName("qdsdjomofstxpbeg")
    public suspend fun serviceCidr(`value`: Output<String>) {
        this.serviceCidr = value
    }

    /**
     * @param value Whether to create internet load balancer for API Server. Default to true.
     * > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specify the `pod_vswitch_ids` field and addons with `terway-eniip`.
     * If you want to use `Flannel` as CNI network plugin, You need to specify the `pod_cidr` field and addons with `flannel`.
     * *Master params*
     */
    @JvmName("wpfubqmodtvditbx")
    public suspend fun slbInternetEnabled(`value`: Output<Boolean>) {
        this.slbInternetEnabled = value
    }

    /**
     * @param value Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
     */
    @JvmName("cakpeovfrmlmbcpl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
     */
    @JvmName("tbciqrmutryvamwj")
    public suspend fun timezone(`value`: Output<String>) {
        this.timezone = value
    }

    /**
     * @param value The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
     */
    @JvmName("lbudmdnrayimwvoo")
    public suspend fun userCa(`value`: Output<String>) {
        this.userCa = value
    }

    /**
     * @param value Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
     */
    @JvmName("dqpvbdqyxqewsbwe")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The addon you want to install in cluster. See `addons` below.
     * *Network params*
     */
    @JvmName("bjywhjwbtylyjqty")
    public suspend fun addons(`value`: List<KubernetesAddonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addons = mapped
    }

    /**
     * @param argument The addon you want to install in cluster. See `addons` below.
     * *Network params*
     */
    @JvmName("scaqgvytclnsyesf")
    public suspend fun addons(argument: List<suspend KubernetesAddonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KubernetesAddonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param argument The addon you want to install in cluster. See `addons` below.
     * *Network params*
     */
    @JvmName("maondtbualhyhlap")
    public suspend fun addons(vararg argument: suspend KubernetesAddonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KubernetesAddonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param argument The addon you want to install in cluster. See `addons` below.
     * *Network params*
     */
    @JvmName("vwctbjlvqfylxavq")
    public suspend fun addons(argument: suspend KubernetesAddonArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KubernetesAddonArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.addons = mapped
    }

    /**
     * @param values The addon you want to install in cluster. See `addons` below.
     * *Network params*
     */
    @JvmName("bgskmvpxphtyadvs")
    public suspend fun addons(vararg values: KubernetesAddonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addons = mapped
    }

    /**
     * @param value A list of API audiences for [Service Account Token Volume Projection](https://www&#46;alibabacloud&#46;com/help/doc-detail/160384&#46;htm)&#46; Set this to `["https://kubernetes&#46;default&#46;svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
     */
    @JvmName("uocjkbloyorkqrkm")
    public suspend fun apiAudiences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiAudiences = mapped
    }

    /**
     * @param values A list of API audiences for [Service Account Token Volume Projection](https://www&#46;alibabacloud&#46;com/help/doc-detail/160384&#46;htm)&#46; Set this to `["https://kubernetes&#46;default&#46;svc"]` if you want to enable the Token Volume Projection feature requires specifying `service_account_issuer` as well. From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
     */
    @JvmName("qthpufddthdokgqk")
    public suspend fun apiAudiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiAudiences = mapped
    }

    /**
     * @param value The path of client certificate, like `~/.kube/client-cert.pem`.
     */
    @JvmName("oaejgfvpsjscpblr")
    public suspend fun clientCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCert = mapped
    }

    /**
     * @param value The path of client key, like `~/.kube/client-key.pem`.
     */
    @JvmName("fwqyypvcmurcplbj")
    public suspend fun clientKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientKey = mapped
    }

    /**
     * @param value The path of cluster ca certificate, like `~/.kube/cluster-ca-cert.pem`
     * *Removed params*
     */
    @JvmName("mrtrlheyigvokwkt")
    public suspend fun clusterCaCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterCaCert = mapped
    }

    /**
     * @param value Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
     */
    @JvmName("bnydkoskpcjgpkxg")
    public suspend fun clusterDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterDomain = mapped
    }

    /**
     * @param value Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
     */
    @JvmName("dfauyetpaqulerro")
    public suspend fun customSan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSan = mapped
    }

    /**
     * @param value Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
     */
    @JvmName("kgdddyqryqlxmdtj")
    public suspend fun deleteOptions(`value`: List<KubernetesDeleteOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOptions = mapped
    }

    /**
     * @param argument Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
     */
    @JvmName("jhsxmsqdkunddirk")
    public suspend fun deleteOptions(argument: List<suspend KubernetesDeleteOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KubernetesDeleteOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.deleteOptions = mapped
    }

    /**
     * @param argument Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
     */
    @JvmName("vcyjajxrnsfsulpc")
    public suspend fun deleteOptions(vararg argument: suspend KubernetesDeleteOptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KubernetesDeleteOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.deleteOptions = mapped
    }

    /**
     * @param argument Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
     */
    @JvmName("lonktktkedpdhhgi")
    public suspend fun deleteOptions(argument: suspend KubernetesDeleteOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KubernetesDeleteOptionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.deleteOptions = mapped
    }

    /**
     * @param values Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
     */
    @JvmName("cmkrfvxeigeqqjov")
    public suspend fun deleteOptions(vararg values: KubernetesDeleteOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOptions = mapped
    }

    /**
     * @param value Whether to enable cluster deletion protection.
     */
    @JvmName("hsjoggkbmfyedgnc")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value Enable login to the node through SSH. Default to `false`.
     */
    @JvmName("rgqqrxyuhkqfgehb")
    public suspend fun enableSsh(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSsh = mapped
    }

    /**
     * @param value Custom Image support. Must based on CentOS7 or AliyunLinux2.
     */
    @JvmName("qmyafggwdeweddij")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Install cloud monitor agent on ECS. Default to `true`.
     */
    @JvmName("pfjgjxaklsvhdvda")
    public suspend fun installCloudMonitor(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installCloudMonitor = mapped
    }

    /**
     * @param value Enable to create advanced security group. default: false. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
     */
    @JvmName("scnpasvrrkrlpeqh")
    public suspend fun isEnterpriseSecurityGroup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnterpriseSecurityGroup = mapped
    }

    /**
     * @param value The keypair of ssh login cluster node, you have to create it first. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("xydrtuscyunwuria")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("vqpxkryntqurfgro")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("vawbdnsspplhcsvu")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("nonfxxxfcwetdano")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value The cluster api server load balance instance specification, default `slb.s1.small`. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html).
     */
    @JvmName("flwydkracownpsix")
    public suspend fun loadBalancerSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerSpec = mapped
    }

    /**
     * @param value Enable master payment auto-renew, defaults to false.
     */
    @JvmName("ptmwumudrmggwyog")
    public suspend fun masterAutoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterAutoRenew = mapped
    }

    /**
     * @param value Master payment auto-renew period, it can be one of {1, 2, 3, 6, 12}.
     */
    @JvmName("revfnusokrpodkoy")
    public suspend fun masterAutoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterAutoRenewPeriod = mapped
    }

    /**
     * @param value The system disk category of master node. Its valid value are `cloud_ssd`, `cloud_essd` and `cloud_efficiency`. Default to `cloud_efficiency`.
     */
    @JvmName("qlaspviegdomxssn")
    public suspend fun masterDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterDiskCategory = mapped
    }

    /**
     * @param value Master node system disk performance level. When `master_disk_category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity. For more information, see [Enhanced SSDs](https://www.alibabacloud.com/help/doc-detail/122389.htm). Default is `PL1`.
     */
    @JvmName("qpkxjxfllbjiytlg")
    public suspend fun masterDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterDiskPerformanceLevel = mapped
    }

    /**
     * @param value The system disk size of master node. Its valid value range [20~500] in GB. Default to 20.
     */
    @JvmName("srxurxavbeblmmhr")
    public suspend fun masterDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterDiskSize = mapped
    }

    /**
     * @param value Master node system disk auto snapshot policy.
     * *Computed params*
     */
    @JvmName("wqqnnpxubnmlyyji")
    public suspend fun masterDiskSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterDiskSnapshotPolicyId = mapped
    }

    /**
     * @param value Master payment type. or `PostPaid` or `PrePaid`, defaults to `PostPaid`. If value is `PrePaid`, the files `master_period`, `master_period_unit`, `master_auto_renew` and `master_auto_renew_period` are required.
     */
    @JvmName("fvypgmgakgkofsnh")
    public suspend fun masterInstanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterInstanceChargeType = mapped
    }

    /**
     * @param value The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
     */
    @JvmName("bmdftjpkdstlsids")
    public suspend fun masterInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterInstanceTypes = mapped
    }

    /**
     * @param values The instance type of master node. Specify one type for single AZ Cluster, three types for MultiAZ Cluster.
     */
    @JvmName("uwvtxohrvjvywirk")
    public suspend fun masterInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.masterInstanceTypes = mapped
    }

    /**
     * @param value Master payment period.Its valid value is one of {1, 2, 3, 6, 12, 24, 36, 48, 60}.
     */
    @JvmName("xlkgsronjsfjjeaj")
    public suspend fun masterPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterPeriod = mapped
    }

    /**
     * @param value Master payment period unit, the valid value is `Month`.
     */
    @JvmName("iaqhqrddmpxhxjsi")
    public suspend fun masterPeriodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterPeriodUnit = mapped
    }

    /**
     * @param value The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
     */
    @JvmName("pcjsufauuvkfjyam")
    public suspend fun masterVswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterVswitchIds = mapped
    }

    /**
     * @param values The vswitches used by master, you can specific 3 or 5 vswitches because of the amount of masters. Detailed below.
     */
    @JvmName("asfbfgttebjxhcgj")
    public suspend fun masterVswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.masterVswitchIds = mapped
    }

    /**
     * @param value The kubernetes cluster's name. It is unique in one Alicloud account.
     */
    @JvmName("qouabkwmusrxeojr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'name_prefix' has been deprecated from provider version 1.75.0.
  """,
    )
    @JvmName("hojwsetikqxvpydt")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Your cluster nodes and applications will have public network access. If there is a NAT gateway in the selected VPC, ACK will use this gateway by default; if there is no NAT gateway in the selected VPC, ACK will create a new NAT gateway for you and automatically configure SNAT rules.
     */
    @JvmName("olyjowufqvobalgd")
    public suspend fun newNatGateway(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newNatGateway = mapped
    }

    /**
     * @param value The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
     */
    @JvmName("jygxxtosovfqkpsk")
    public suspend fun nodeCidrMask(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCidrMask = mapped
    }

    /**
     * @param value Each node name consists of a prefix, an IP substring, and a suffix, the input format is `customized,<prefix>,IPSubStringLen,<suffix>`. For example "customized,aliyun.com-,5,-test", if the node IP address is 192.168.59.176, the prefix is aliyun.com-, IP substring length is 5, and the suffix is -test, the node name will be aliyun.com-59176-test.
     */
    @JvmName("sjgfelsthsdlcmaa")
    public suspend fun nodeNameMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeNameMode = mapped
    }

    /**
     * @param value The operating system of the nodes that run pods, its valid value is either `Linux` or `Windows`. Default to `Linux`.
     */
    @JvmName("qrterrsyvehcfuix")
    public suspend fun osType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The password of ssh login cluster node. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
     */
    @JvmName("rniueqbxbbtthafs")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The architecture of the nodes that run pods, its valid value is either `CentOS` or `AliyunLinux`. Default to `CentOS`.
     */
    @JvmName("dqpinkjtuvugupuq")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value [Flannel Specific] The CIDR block for the pod network when using Flannel.
     */
    @JvmName("xnprvemyotjxsqov")
    public suspend fun podCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podCidr = mapped
    }

    /**
     * @param value [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `worker_vswitch_ids` and `master_vswitch_ids` but must be in same availability zones.
     */
    @JvmName("ekyfgpeaomnryxxq")
    public suspend fun podVswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podVswitchIds = mapped
    }

    /**
     * @param values [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `worker_vswitch_ids` and `master_vswitch_ids` but must be in same availability zones.
     */
    @JvmName("eorkoxhfmaexjohq")
    public suspend fun podVswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.podVswitchIds = mapped
    }

    /**
     * @param value Proxy mode is option of kube-proxy. options: iptables | ipvs. default: ipvs.
     */
    @JvmName("nylshfrfqoyafwdb")
    public suspend fun proxyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyMode = mapped
    }

    /**
     * @param value RDS instance list, You can choose which RDS instances whitelist to add instances to.
     */
    @JvmName("nnwgvtnekfbduews")
    public suspend fun rdsInstances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdsInstances = mapped
    }

    /**
     * @param values RDS instance list, You can choose which RDS instances whitelist to add instances to.
     */
    @JvmName("khtsxbyjwjtbclrv")
    public suspend fun rdsInstances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rdsInstances = mapped
    }

    /**
     * @param value The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
     */
    @JvmName("yfimvgbxigtwflke")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("emsgwermuabdlsww")
    public suspend fun retainResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainResources = mapped
    }

    /**
     * @param values
     */
    @JvmName("nqvptvaydkpchcgv")
    public suspend fun retainResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retainResources = mapped
    }

    /**
     * @param value The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). See `runtime` below.
     */
    @JvmName("gwmvchfedxddwqdg")
    public suspend fun runtime(`value`: KubernetesRuntimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param argument The runtime of containers. If you select another container runtime, see [How do I select between Docker and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm?spm=a2c63.p38356.b99.440.22563866AJkBgI). See `runtime` below.
     */
    @JvmName("cuyeomeieynssafa")
    public suspend fun runtime(argument: suspend KubernetesRuntimeArgsBuilder.() -> Unit) {
        val toBeMapped = KubernetesRuntimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runtime = mapped
    }

    /**
     * @param value The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
     */
    @JvmName("kdehwvwvlodsftag")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22+, Service Account Token Volume Projection will be enabled by default.
     */
    @JvmName("swcyewfoipqslnqq")
    public suspend fun serviceAccountIssuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountIssuer = mapped
    }

    /**
     * @param value The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
     */
    @JvmName("lelpjmcpyxsnkors")
    public suspend fun serviceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidr = mapped
    }

    /**
     * @param value Whether to create internet load balancer for API Server. Default to true.
     * > **NOTE:** If you want to use `Terway` as CNI network plugin, You need to specify the `pod_vswitch_ids` field and addons with `terway-eniip`.
     * If you want to use `Flannel` as CNI network plugin, You need to specify the `pod_cidr` field and addons with `flannel`.
     * *Master params*
     */
    @JvmName("opfwlfkjneynubwj")
    public suspend fun slbInternetEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slbInternetEnabled = mapped
    }

    /**
     * @param value Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
     */
    @JvmName("mhjgpooearwsovqg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Default nil, A map of tags assigned to the kubernetes cluster and work nodes.
     */
    @JvmName("yefwomwijvcmpmvy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value When you create a cluster, set the time zones for the Master and Worker nodes. You can only change the managed node time zone if you create a cluster. Once the cluster is created, you can only change the time zone of the Worker node.
     */
    @JvmName("vkxxxaqklypmsbco")
    public suspend fun timezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezone = mapped
    }

    /**
     * @param value The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
     */
    @JvmName("uoeqymyfsxxktpon")
    public suspend fun userCa(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userCa = mapped
    }

    /**
     * @param value Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK.
     */
    @JvmName("taueggrxxjqhjxjm")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): KubernetesArgs = KubernetesArgs(
        addons = addons,
        apiAudiences = apiAudiences,
        clientCert = clientCert,
        clientKey = clientKey,
        clusterCaCert = clusterCaCert,
        clusterDomain = clusterDomain,
        customSan = customSan,
        deleteOptions = deleteOptions,
        deletionProtection = deletionProtection,
        enableSsh = enableSsh,
        imageId = imageId,
        installCloudMonitor = installCloudMonitor,
        isEnterpriseSecurityGroup = isEnterpriseSecurityGroup,
        keyName = keyName,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        loadBalancerSpec = loadBalancerSpec,
        masterAutoRenew = masterAutoRenew,
        masterAutoRenewPeriod = masterAutoRenewPeriod,
        masterDiskCategory = masterDiskCategory,
        masterDiskPerformanceLevel = masterDiskPerformanceLevel,
        masterDiskSize = masterDiskSize,
        masterDiskSnapshotPolicyId = masterDiskSnapshotPolicyId,
        masterInstanceChargeType = masterInstanceChargeType,
        masterInstanceTypes = masterInstanceTypes,
        masterPeriod = masterPeriod,
        masterPeriodUnit = masterPeriodUnit,
        masterVswitchIds = masterVswitchIds,
        name = name,
        namePrefix = namePrefix,
        newNatGateway = newNatGateway,
        nodeCidrMask = nodeCidrMask,
        nodeNameMode = nodeNameMode,
        osType = osType,
        password = password,
        platform = platform,
        podCidr = podCidr,
        podVswitchIds = podVswitchIds,
        proxyMode = proxyMode,
        rdsInstances = rdsInstances,
        resourceGroupId = resourceGroupId,
        retainResources = retainResources,
        runtime = runtime,
        securityGroupId = securityGroupId,
        serviceAccountIssuer = serviceAccountIssuer,
        serviceCidr = serviceCidr,
        slbInternetEnabled = slbInternetEnabled,
        tags = tags,
        timezone = timezone,
        userCa = userCa,
        version = version,
    )
}
