@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesAutoscalerNodepool
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesAutoscalerNodepool.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [KubernetesAutoscaler].
 */
@PulumiTagMarker
public class KubernetesAutoscalerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KubernetesAutoscalerArgs = KubernetesAutoscalerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KubernetesAutoscalerArgsBuilder.() -> Unit) {
        val builder = KubernetesAutoscalerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KubernetesAutoscaler {
        val builtJavaResource = com.pulumi.alicloud.cs.KubernetesAutoscaler(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KubernetesAutoscaler(builtJavaResource)
    }
}

public class KubernetesAutoscaler internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.KubernetesAutoscaler,
) : KotlinCustomResource(javaResource, KubernetesAutoscalerMapper) {
    /**
     * The id of kubernetes cluster.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The cool_down_duration option of cluster-autoscaler.
     */
    public val coolDownDuration: Output<String>
        get() = javaResource.coolDownDuration().applyValue({ args0 -> args0 })

    /**
     * The defer_scale_in_duration option of cluster-autoscaler.
     */
    public val deferScaleInDuration: Output<String>
        get() = javaResource.deferScaleInDuration().applyValue({ args0 -> args0 })

    /**
     * The list of the node pools. See `nodepools` below.
     */
    public val nodepools: Output<List<KubernetesAutoscalerNodepool>>?
        get() = javaResource.nodepools().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
     */
    public val useEcsRamRoleToken: Output<Boolean>?
        get() = javaResource.useEcsRamRoleToken().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The utilization option of cluster-autoscaler.
     */
    public val utilization: Output<String>
        get() = javaResource.utilization().applyValue({ args0 -> args0 })
}

public object KubernetesAutoscalerMapper : ResourceMapper<KubernetesAutoscaler> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.KubernetesAutoscaler::class == javaResource::class

    override fun map(javaResource: Resource): KubernetesAutoscaler = KubernetesAutoscaler(
        javaResource
            as com.pulumi.alicloud.cs.KubernetesAutoscaler,
    )
}

/**
 * @see [KubernetesAutoscaler].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KubernetesAutoscaler].
 */
public suspend fun kubernetesAutoscaler(
    name: String,
    block: suspend KubernetesAutoscalerResourceBuilder.() -> Unit,
): KubernetesAutoscaler {
    val builder = KubernetesAutoscalerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KubernetesAutoscaler].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kubernetesAutoscaler(name: String): KubernetesAutoscaler {
    val builder = KubernetesAutoscalerResourceBuilder()
    builder.name(name)
    return builder.build()
}
