@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.KubernetesAutoscalerArgs.builder
import com.pulumi.alicloud.cs.kotlin.inputs.KubernetesAutoscalerNodepoolArgs
import com.pulumi.alicloud.cs.kotlin.inputs.KubernetesAutoscalerNodepoolArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clusterId The id of kubernetes cluster.
 * @property coolDownDuration The cool_down_duration option of cluster-autoscaler.
 * @property deferScaleInDuration The defer_scale_in_duration option of cluster-autoscaler.
 * @property nodepools The list of the node pools. See `nodepools` below.
 * @property useEcsRamRoleToken Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
 * @property utilization The utilization option of cluster-autoscaler.
 */
public data class KubernetesAutoscalerArgs(
    public val clusterId: Output<String>? = null,
    public val coolDownDuration: Output<String>? = null,
    public val deferScaleInDuration: Output<String>? = null,
    public val nodepools: Output<List<KubernetesAutoscalerNodepoolArgs>>? = null,
    public val useEcsRamRoleToken: Output<Boolean>? = null,
    public val utilization: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.KubernetesAutoscalerArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.KubernetesAutoscalerArgs =
        com.pulumi.alicloud.cs.KubernetesAutoscalerArgs.builder()
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .coolDownDuration(coolDownDuration?.applyValue({ args0 -> args0 }))
            .deferScaleInDuration(deferScaleInDuration?.applyValue({ args0 -> args0 }))
            .nodepools(
                nodepools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .useEcsRamRoleToken(useEcsRamRoleToken?.applyValue({ args0 -> args0 }))
            .utilization(utilization?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesAutoscalerArgs].
 */
@PulumiTagMarker
public class KubernetesAutoscalerArgsBuilder internal constructor() {
    private var clusterId: Output<String>? = null

    private var coolDownDuration: Output<String>? = null

    private var deferScaleInDuration: Output<String>? = null

    private var nodepools: Output<List<KubernetesAutoscalerNodepoolArgs>>? = null

    private var useEcsRamRoleToken: Output<Boolean>? = null

    private var utilization: Output<String>? = null

    /**
     * @param value The id of kubernetes cluster.
     */
    @JvmName("myhvlmlhmjajggfu")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The cool_down_duration option of cluster-autoscaler.
     */
    @JvmName("rywpvtapndwqxeyn")
    public suspend fun coolDownDuration(`value`: Output<String>) {
        this.coolDownDuration = value
    }

    /**
     * @param value The defer_scale_in_duration option of cluster-autoscaler.
     */
    @JvmName("tdmdlyalniobonnj")
    public suspend fun deferScaleInDuration(`value`: Output<String>) {
        this.deferScaleInDuration = value
    }

    /**
     * @param value The list of the node pools. See `nodepools` below.
     */
    @JvmName("bukstngmggjvosva")
    public suspend fun nodepools(`value`: Output<List<KubernetesAutoscalerNodepoolArgs>>) {
        this.nodepools = value
    }

    @JvmName("pwjgqmtwhjssftwq")
    public suspend fun nodepools(vararg values: Output<KubernetesAutoscalerNodepoolArgs>) {
        this.nodepools = Output.all(values.asList())
    }

    /**
     * @param values The list of the node pools. See `nodepools` below.
     */
    @JvmName("bdghmlggwoelvtmn")
    public suspend fun nodepools(values: List<Output<KubernetesAutoscalerNodepoolArgs>>) {
        this.nodepools = Output.all(values)
    }

    /**
     * @param value Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
     */
    @JvmName("hydpmhkfenidahib")
    public suspend fun useEcsRamRoleToken(`value`: Output<Boolean>) {
        this.useEcsRamRoleToken = value
    }

    /**
     * @param value The utilization option of cluster-autoscaler.
     */
    @JvmName("mpepkpvhvwmjnfbc")
    public suspend fun utilization(`value`: Output<String>) {
        this.utilization = value
    }

    /**
     * @param value The id of kubernetes cluster.
     */
    @JvmName("gpnaycptgcheeiee")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The cool_down_duration option of cluster-autoscaler.
     */
    @JvmName("uwqdyuegwhxigpyn")
    public suspend fun coolDownDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coolDownDuration = mapped
    }

    /**
     * @param value The defer_scale_in_duration option of cluster-autoscaler.
     */
    @JvmName("gcnkqtchwovtimto")
    public suspend fun deferScaleInDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferScaleInDuration = mapped
    }

    /**
     * @param value The list of the node pools. See `nodepools` below.
     */
    @JvmName("kkljviwcfxnscdtl")
    public suspend fun nodepools(`value`: List<KubernetesAutoscalerNodepoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodepools = mapped
    }

    /**
     * @param argument The list of the node pools. See `nodepools` below.
     */
    @JvmName("lcgmioyseljhybgp")
    public suspend fun nodepools(argument: List<suspend KubernetesAutoscalerNodepoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KubernetesAutoscalerNodepoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodepools = mapped
    }

    /**
     * @param argument The list of the node pools. See `nodepools` below.
     */
    @JvmName("idfasqvvpughgkjh")
    public suspend fun nodepools(vararg argument: suspend KubernetesAutoscalerNodepoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KubernetesAutoscalerNodepoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodepools = mapped
    }

    /**
     * @param argument The list of the node pools. See `nodepools` below.
     */
    @JvmName("vkrlpxpgntrcyegu")
    public suspend fun nodepools(argument: suspend KubernetesAutoscalerNodepoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            KubernetesAutoscalerNodepoolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.nodepools = mapped
    }

    /**
     * @param values The list of the node pools. See `nodepools` below.
     */
    @JvmName("jvcyfbkaqkjxsibg")
    public suspend fun nodepools(vararg values: KubernetesAutoscalerNodepoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodepools = mapped
    }

    /**
     * @param value Enable autoscaler access to alibabacloud service by ecs ramrole token. default: false
     */
    @JvmName("intngbdinhlyocmv")
    public suspend fun useEcsRamRoleToken(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEcsRamRoleToken = mapped
    }

    /**
     * @param value The utilization option of cluster-autoscaler.
     */
    @JvmName("qyywtfsupgrgnhxy")
    public suspend fun utilization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.utilization = mapped
    }

    internal fun build(): KubernetesAutoscalerArgs = KubernetesAutoscalerArgs(
        clusterId = clusterId,
        coolDownDuration = coolDownDuration,
        deferScaleInDuration = deferScaleInDuration,
        nodepools = nodepools,
        useEcsRamRoleToken = useEcsRamRoleToken,
        utilization = utilization,
    )
}
