@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesPermissionPermission
import com.pulumi.alicloud.cs.kotlin.outputs.KubernetesPermissionPermission.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [KubernetesPermission].
 */
@PulumiTagMarker
public class KubernetesPermissionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KubernetesPermissionArgs = KubernetesPermissionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KubernetesPermissionArgsBuilder.() -> Unit) {
        val builder = KubernetesPermissionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KubernetesPermission {
        val builtJavaResource = com.pulumi.alicloud.cs.KubernetesPermission(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KubernetesPermission(builtJavaResource)
    }
}

/**
 * This resource will help you implement RBAC authorization for the kubernetes cluster, see [What is kubernetes permissions](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/api-grantpermissions).
 * > **NOTE:** Please make sure that the target RAM user has been granted a RAM policy with at least read-only permission of the target cluster in the RAM console. Otherwise, the `ErrorRamPolicyConfig` error will be returned.
 * For more information about how to authorize a RAM user by attaching RAM policies, see [Create a custom RAM policy](https://www.alibabacloud.com/help/doc-detail/86485.htm).
 * > **NOTE:** If you call this operation as a RAM user, make sure that this RAM user has the permissions to grant other RAM users the permissions to manage ACK clusters. Otherwise, the `StatusForbidden` or `ForbiddenGrantPermissions` errors will be returned. For more information, see [Use a RAM user to grant RBAC permissions to other RAM users](https://www.alibabacloud.com/help/faq-detail/119035.htm).
 * > **NOTE:** This operation overwrites the permissions that have been granted to the specified RAM user. When you call this operation, make sure that the required permissions are included.
 * > **NOTE:** Available since v1.122.0.
 */
public class KubernetesPermission internal constructor(
    override val javaResource: com.pulumi.alicloud.cs.KubernetesPermission,
) : KotlinCustomResource(javaResource, KubernetesPermissionMapper) {
    /**
     * A list of user permission. See `permissions` below.
     */
    public val permissions: Output<List<KubernetesPermissionPermission>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The ID of the Ram user, and it can also be the id of the Ram Role. If you use Ram Role id, you need to set `is_ram_role` to `true` during authorization.
     */
    public val uid: Output<String>
        get() = javaResource.uid().applyValue({ args0 -> args0 })
}

public object KubernetesPermissionMapper : ResourceMapper<KubernetesPermission> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cs.KubernetesPermission::class == javaResource::class

    override fun map(javaResource: Resource): KubernetesPermission = KubernetesPermission(
        javaResource
            as com.pulumi.alicloud.cs.KubernetesPermission,
    )
}

/**
 * @see [KubernetesPermission].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KubernetesPermission].
 */
public suspend fun kubernetesPermission(
    name: String,
    block: suspend KubernetesPermissionResourceBuilder.() -> Unit,
): KubernetesPermission {
    val builder = KubernetesPermissionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KubernetesPermission].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kubernetesPermission(name: String): KubernetesPermission {
    val builder = KubernetesPermissionResourceBuilder()
    builder.name(name)
    return builder.build()
}
