@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cs.kotlin

import com.pulumi.alicloud.cs.KubernetesPermissionArgs.builder
import com.pulumi.alicloud.cs.kotlin.inputs.KubernetesPermissionPermissionArgs
import com.pulumi.alicloud.cs.kotlin.inputs.KubernetesPermissionPermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * This resource will help you implement RBAC authorization for the kubernetes cluster, see [What is kubernetes permissions](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/developer-reference/api-grantpermissions).
 * > **NOTE:** Please make sure that the target RAM user has been granted a RAM policy with at least read-only permission of the target cluster in the RAM console. Otherwise, the `ErrorRamPolicyConfig` error will be returned.
 * For more information about how to authorize a RAM user by attaching RAM policies, see [Create a custom RAM policy](https://www.alibabacloud.com/help/doc-detail/86485.htm).
 * > **NOTE:** If you call this operation as a RAM user, make sure that this RAM user has the permissions to grant other RAM users the permissions to manage ACK clusters. Otherwise, the `StatusForbidden` or `ForbiddenGrantPermissions` errors will be returned. For more information, see [Use a RAM user to grant RBAC permissions to other RAM users](https://www.alibabacloud.com/help/faq-detail/119035.htm).
 * > **NOTE:** This operation overwrites the permissions that have been granted to the specified RAM user. When you call this operation, make sure that the required permissions are included.
 * > **NOTE:** Available since v1.122.0.
 * @property permissions A list of user permission. See `permissions` below.
 * @property uid The ID of the Ram user, and it can also be the id of the Ram Role. If you use Ram Role id, you need to set `is_ram_role` to `true` during authorization.
 */
public data class KubernetesPermissionArgs(
    public val permissions: Output<List<KubernetesPermissionPermissionArgs>>? = null,
    public val uid: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cs.KubernetesPermissionArgs> {
    override fun toJava(): com.pulumi.alicloud.cs.KubernetesPermissionArgs =
        com.pulumi.alicloud.cs.KubernetesPermissionArgs.builder()
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .uid(uid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesPermissionArgs].
 */
@PulumiTagMarker
public class KubernetesPermissionArgsBuilder internal constructor() {
    private var permissions: Output<List<KubernetesPermissionPermissionArgs>>? = null

    private var uid: Output<String>? = null

    /**
     * @param value A list of user permission. See `permissions` below.
     */
    @JvmName("ukkoerfuqgcemrkd")
    public suspend fun permissions(`value`: Output<List<KubernetesPermissionPermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("tgswjysgaepomfxx")
    public suspend fun permissions(vararg values: Output<KubernetesPermissionPermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A list of user permission. See `permissions` below.
     */
    @JvmName("dnrxobbahihlfmmx")
    public suspend fun permissions(values: List<Output<KubernetesPermissionPermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value The ID of the Ram user, and it can also be the id of the Ram Role. If you use Ram Role id, you need to set `is_ram_role` to `true` during authorization.
     */
    @JvmName("tyfptxfwhbjplatx")
    public suspend fun uid(`value`: Output<String>) {
        this.uid = value
    }

    /**
     * @param value A list of user permission. See `permissions` below.
     */
    @JvmName("lsqxepnqgnlfxbqh")
    public suspend fun permissions(`value`: List<KubernetesPermissionPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A list of user permission. See `permissions` below.
     */
    @JvmName("idgjiidvcpbfpqsl")
    public suspend fun permissions(argument: List<suspend KubernetesPermissionPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KubernetesPermissionPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A list of user permission. See `permissions` below.
     */
    @JvmName("piacefixgwjyarhs")
    public suspend fun permissions(vararg argument: suspend KubernetesPermissionPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KubernetesPermissionPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A list of user permission. See `permissions` below.
     */
    @JvmName("ltfaefnghwhxqjab")
    public suspend fun permissions(argument: suspend KubernetesPermissionPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            KubernetesPermissionPermissionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A list of user permission. See `permissions` below.
     */
    @JvmName("fyqvgeqeoajqqoyk")
    public suspend fun permissions(vararg values: KubernetesPermissionPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The ID of the Ram user, and it can also be the id of the Ram Role. If you use Ram Role id, you need to set `is_ram_role` to `true` during authorization.
     */
    @JvmName("kgxibwtjmqtpvmxg")
    public suspend fun uid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uid = mapped
    }

    internal fun build(): KubernetesPermissionArgs = KubernetesPermissionArgs(
        permissions = permissions,
        uid = uid,
    )
}
